/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.IUserDetailsRoleListService;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.api.ui.INavigationComponent;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.output.SimpleOutputHandler;
import org.pentaho.platform.engine.core.solution.ActionInfo;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.acls.PentahoAclEntry;
import org.pentaho.platform.engine.services.SoapHelper;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.uifoundation.chart.ChartHelper;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.request.HttpWebServiceRequestHandler;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.xml.sax.EntityResolver;

public class HttpWebService
extends ServletBase {
    private static final long serialVersionUID = -2011812808062152707L;
    private static final Log logger = LogFactory.getLog(HttpWebService.class);

    public Log getLogger() {
        return logger;
    }

    public String getPayloadAsString(HttpServletRequest request) throws IOException {
        ServletInputStream is = request.getInputStream();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        String content = null;
        try {
            byte[] buffer = new byte[2048];
            int b = is.read(buffer);
            while (b > 0) {
                os.write(buffer, 0, b);
                b = is.read(buffer);
            }
            content = os.toString(LocaleHelper.getSystemEncoding());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetFixMe(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block19: {
            try {
                String solutionName = request.getParameter("solution");
                String actionPath = request.getParameter("path");
                String actionName = request.getParameter("action");
                String component = request.getParameter("component");
                String content = this.getPayloadAsString(request);
                HttpRequestParameterProvider parameterProvider = null;
                HashMap<String, String> parameters = new HashMap<String, String>();
                if (content != null && content.length() > 0) {
                    Document doc = XmlDom4JHelper.getDocFromString((String)content, (EntityResolver)new PentahoEntityResolver());
                    List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
                    for (int i = 0; i < parameterNodes.size(); ++i) {
                        Node parameterNode = (Node)parameterNodes.get(i);
                        String parameterName = parameterNode.getName();
                        String parameterValue = parameterNode.getText();
                        if ("action".equals(parameterName)) {
                            ActionInfo info = ActionInfo.parseActionString((String)parameterValue);
                            solutionName = info.getSolutionName();
                            actionPath = info.getPath();
                            actionName = info.getActionName();
                            continue;
                        }
                        if ("component".equals(parameterName)) {
                            component = parameterValue;
                            continue;
                        }
                        parameters.put(parameterName, parameterValue);
                    }
                    parameterProvider = new SimpleParameterProvider(parameters);
                } else {
                    parameterProvider = new HttpRequestParameterProvider(request);
                }
                response.setContentType("text/xml");
                response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
                IPentahoSession userSession = this.getPentahoSession(request);
                String instanceId = request.getParameter("instance-id");
                String processId = ((Object)((Object)this)).getClass().getName();
                ByteArrayOutputStream contentStream = new ByteArrayOutputStream();
                SimpleOutputHandler outputHandler = new SimpleOutputHandler((OutputStream)contentStream, false);
                ServletOutputStream outputStream = response.getOutputStream();
                if (component == null || "action".equals(component)) {
                    HttpWebServiceRequestHandler requestHandler = new HttpWebServiceRequestHandler(userSession, null, (IOutputHandler)outputHandler, (IParameterProvider)parameterProvider, null);
                    requestHandler.setParameterProvider("session", (IParameterProvider)new HttpSessionParameterProvider(userSession));
                    requestHandler.setInstanceId(instanceId);
                    requestHandler.setProcessId(processId);
                    requestHandler.setAction(actionPath, actionName);
                    requestHandler.setSolutionName(solutionName);
                    this.debug(Messages.getString("HttpWebService.DEBUG_WEB_SERVICE_START"));
                    IRuntimeContext runtime = null;
                    outputStream.write(SoapHelper.getSoapHeader().getBytes(LocaleHelper.getSystemEncoding()));
                    try {
                        runtime = requestHandler.handleActionRequest(0, 0);
                        SoapHelper.generateSoapResponse((IRuntimeContext)runtime, (OutputStream)outputStream, (SimpleOutputHandler)outputHandler, (OutputStream)contentStream, (List)requestHandler.getMessages());
                        outputStream.write(SoapHelper.getSoapFooter().getBytes(LocaleHelper.getSystemEncoding()));
                        break block19;
                    }
                    finally {
                        if (runtime != null) {
                            runtime.dispose();
                        }
                    }
                }
                if ("dial".equals(component)) {
                    this.doDial(solutionName, actionPath, actionName, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession);
                } else if ("chart".equals(component)) {
                    this.doChart(solutionName, actionPath, actionName, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession);
                } else if ("navigate".equals(component)) {
                    this.doNavigate(solutionName, actionPath, actionName, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession);
                } else if ("xaction-parameter".equals(component)) {
                    this.doParameter(solutionName, actionPath, actionName, (IParameterProvider)parameterProvider, (OutputStream)outputStream, userSession, response);
                }
            }
            catch (Throwable t) {
                this.error(Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE"), t);
            }
        }
        this.debug(Messages.getString("HttpWebService.DEBUG_WEB_SERVICE_END"));
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void doParameter(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession, HttpServletResponse response) throws IOException {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)userSession);
        IActionSequence actionSequence = repository.getActionSequence(solutionName, actionPath, actionName, PentahoSystem.loggingLevel, 1);
        if (actionSequence == null) {
            logger.debug((Object)Messages.getString("HttpWebService.ERROR_0002_NOTFOUND", solutionName, actionPath, actionName));
            response.sendError(500);
            return;
        }
        Document document = DocumentHelper.createDocument();
        try {
            Element parametersElement = document.addElement("parameters");
            Map params = actionSequence.getInputDefinitionsForParameterProvider("request");
            for (Map.Entry entry : params.entrySet()) {
                String paramName = (String)entry.getKey();
                IActionParameter paramDef = (IActionParameter)entry.getValue();
                String value = paramDef.getStringValue();
                Class type = "list".equalsIgnoreCase(paramDef.getType()) ? String[].class : String.class;
                String label = paramDef.getSelectionDisplayName();
                String[] values = StringUtils.isEmpty((String)value) ? new String[]{} : new String[]{value};
                this.createParameterElement(parametersElement, paramName, type, label, "user", "parameters", values);
            }
            this.createParameterElement(parametersElement, "solution", String.class, null, "system", "system", new String[]{solutionName});
            this.createParameterElement(parametersElement, "path", String.class, null, "system", "system", new String[]{actionPath});
            this.createParameterElement(parametersElement, "action", String.class, null, "system", "system", new String[]{actionName});
            this.createParameterElement(parametersElement, "prompt", String.class, null, "system", "system", new String[]{"yes", "no"});
            this.createParameterElement(parametersElement, "instance-id", String.class, null, "system", "system", new String[]{parameterProvider.getStringParameter("instance-id", null)});
        }
        catch (Exception e) {
            logger.warn((Object)Messages.getString("HttpWebService.ERROR_0003_UNEXPECTED"), (Throwable)e);
            response.sendError(500);
            return;
        }
        XMLWriter writer = new XMLWriter(outputStream, OutputFormat.createPrettyPrint());
        writer.write(document);
        writer.flush();
    }

    private Element createParameterElement(Element parametersElement, String paramName, Class type, String label, String role, String group, String[] values) {
        Element parameterElement = parametersElement.addElement("parameter");
        parameterElement.addAttribute("name", paramName);
        parameterElement.addAttribute("type", type.getName());
        if (!StringUtils.isEmpty((String)label)) {
            Element labelAttr = parameterElement.addElement("attribute");
            labelAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
            labelAttr.addAttribute("name", "label");
            labelAttr.addAttribute("value", label);
        }
        Element roleAttr = parameterElement.addElement("attribute");
        roleAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        roleAttr.addAttribute("name", "role");
        roleAttr.addAttribute("value", role);
        Element paramGroupAttr = parameterElement.addElement("attribute");
        paramGroupAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        paramGroupAttr.addAttribute("name", "parameter-group");
        paramGroupAttr.addAttribute("value", group);
        Element paramGroupLabelAttr = parameterElement.addElement("attribute");
        paramGroupLabelAttr.addAttribute("namespace", "http://reporting.pentaho.org/namespaces/engine/parameter-attributes/core");
        paramGroupLabelAttr.addAttribute("name", "parameter-group-label");
        paramGroupLabelAttr.addAttribute("value", this.lookupParameterGroupLabel(group));
        if (values.length > 0) {
            Element valuesElement = parameterElement.addElement("values");
            for (String value : values) {
                Element valueAttr = valuesElement.addElement("value");
                valueAttr.addAttribute("type", String.class.getName());
                valueAttr.addAttribute("value", value);
                valueAttr.addAttribute("selected", String.valueOf(values.length == 1));
            }
        }
        return parameterElement;
    }

    private String lookupParameterGroupLabel(String group) {
        if ("system".equals(group)) {
            return Messages.getString("HttpWebService.PARAMETER_GROUP_SYSTEM");
        }
        return Messages.getString("HttpWebService.PARAMETER_GROUP_USER");
    }

    private void doNavigate(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        String contextPath = requestContext.getContextPath();
        String hrefUrl = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
        String onClick = "";
        String thisUrl = contextPath + "Navigate?";
        SimpleUrlFactory urlFactory = new SimpleUrlFactory(thisUrl);
        ArrayList messages = new ArrayList();
        if ("".equals(solutionName)) {
            solutionName = null;
        }
        INavigationComponent navigate = (INavigationComponent)PentahoSystem.get(INavigationComponent.class, (IPentahoSession)userSession);
        navigate.setHrefUrl(hrefUrl);
        navigate.setOnClick(onClick);
        navigate.setSolutionParamName("solution");
        navigate.setPathParamName("path");
        navigate.setAllowNavigation(new Boolean(false));
        navigate.setOptions("");
        navigate.setUrlFactory((IPentahoUrlFactory)urlFactory);
        navigate.setMessages(messages);
        navigate.validate(userSession, null);
        navigate.setParameterProvider("request", parameterProvider);
        Document doc = navigate.getXmlContent();
        try {
            this.writeDocumentAsSoapResponse(outputStream, doc);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void writeDocumentAsSoapResponse(OutputStream outputStream, Document doc) throws IOException {
        this.writeStringAsSoapResponse(outputStream, doc.getRootElement().asXML());
    }

    public void writeStringAsSoapResponse(OutputStream outputStream, String doc) throws IOException {
        outputStream.write(SoapHelper.getSoapHeader().getBytes(LocaleHelper.getSystemEncoding()));
        outputStream.write(SoapHelper.openSoapResponse().getBytes(LocaleHelper.getSystemEncoding()));
        outputStream.write("<content>".getBytes(LocaleHelper.getSystemEncoding()));
        outputStream.write(doc.getBytes(LocaleHelper.getSystemEncoding()));
        outputStream.write("</content>".getBytes(LocaleHelper.getSystemEncoding()));
        outputStream.write(SoapHelper.closeSoapResponse().getBytes(LocaleHelper.getSystemEncoding()));
        outputStream.write(SoapHelper.getSoapFooter().getBytes(LocaleHelper.getSystemEncoding()));
    }

    private void doDial(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        StringBuffer buffer = new StringBuffer();
        ArrayList messages = new ArrayList();
        boolean ok = ChartHelper.doDial((String)solutionName, (String)actionPath, (String)actionName, (IParameterProvider)parameterProvider, (StringBuffer)buffer, (IPentahoSession)userSession, messages, (ILogger)this);
        if (!ok) {
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", Messages.getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), messages, buffer);
        }
        try {
            this.writeStringAsSoapResponse(outputStream, buffer.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void doChart(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        String chartTypeStr = parameterProvider.getStringParameter("chart-type", "");
        if ("PieChart".equals(chartTypeStr)) {
            this.doPieChart(solutionName, actionPath, actionName, parameterProvider, outputStream, userSession);
        } else {
            this.doOtherChart(solutionName, actionPath, actionName, parameterProvider, outputStream, userSession);
        }
    }

    private void doPieChart(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        StringBuffer buffer = new StringBuffer();
        ArrayList messages = new ArrayList();
        boolean ok = ChartHelper.doPieChart((String)solutionName, (String)actionPath, (String)actionName, (IParameterProvider)parameterProvider, (StringBuffer)buffer, (IPentahoSession)userSession, messages, (ILogger)this);
        if (!ok) {
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", Messages.getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), messages, buffer);
        }
        try {
            this.writeStringAsSoapResponse(outputStream, buffer.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void doOtherChart(String solutionName, String actionPath, String actionName, IParameterProvider parameterProvider, OutputStream outputStream, IPentahoSession userSession) {
        StringBuffer buffer = new StringBuffer();
        ArrayList messages = new ArrayList();
        boolean ok = ChartHelper.doChart((String)solutionName, (String)actionPath, (String)actionName, (IParameterProvider)parameterProvider, (StringBuffer)buffer, (IPentahoSession)userSession, messages, (ILogger)this);
        if (!ok) {
            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", Messages.getString("Widget.ERROR_0001_COULD_NOT_CREATE_WIDGET"), messages, buffer);
        }
        try {
            this.writeStringAsSoapResponse(outputStream, buffer.toString());
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            if (!this.isSecurityDetailsRequest(request)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getString("HttpWebService.DEBUG_MISSING_ACTION_PARAMETER"));
                }
                this.doGetFixMe(request, response);
                return;
            }
            response.setContentType("text/xml");
            response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            String details = this.getDetailsParameter(request);
            if ("users".equalsIgnoreCase(details)) {
                StringBuffer buf = new StringBuffer();
                this.doUsers(request, response, buf);
                this.doACLs(request, response, buf);
                this.writeStringAsSoapResponse((OutputStream)response.getOutputStream(), buf.toString());
            } else if ("roles".equalsIgnoreCase(details)) {
                StringBuffer buf = new StringBuffer();
                this.doRoles(request, response, buf);
                this.doACLs(request, response, buf);
                this.writeStringAsSoapResponse((OutputStream)response.getOutputStream(), buf.toString());
            } else if ("acls".equalsIgnoreCase(details)) {
                StringBuffer buf = new StringBuffer();
                this.doACLs(request, response, buf);
                this.writeStringAsSoapResponse((OutputStream)response.getOutputStream(), buf.toString());
            } else {
                if (!"all".equalsIgnoreCase(details) && logger.isWarnEnabled()) {
                    logger.warn((Object)Messages.getString("HttpWebService.WARN_MISSING_DETAILS_PARAMETER"));
                }
                StringBuffer buf = new StringBuffer();
                this.doAll(request, response, buf);
                this.writeStringAsSoapResponse((OutputStream)response.getOutputStream(), buf.toString());
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected boolean isSecurityDetailsRequest(HttpServletRequest request) {
        return this.hasActionInQueryString(request) || this.hasActionInBody(request);
    }

    protected String getDetailsParameter(HttpServletRequest request) {
        Map parameters;
        Object obj;
        String payload;
        String details = request.getParameter("details");
        if (null != details) {
            return details;
        }
        try {
            payload = this.getPayloadAsString(request);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)e);
            }
            return null;
        }
        if (null != payload && payload.length() > 0 && null != (obj = (parameters = this.getParameterMapFromPayload(payload)).get("details"))) {
            return obj.toString();
        }
        return null;
    }

    protected boolean hasActionInBody(HttpServletRequest request) {
        Map parameters;
        Object obj;
        String payload;
        try {
            payload = this.getPayloadAsString(request);
        }
        catch (IOException e) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)e);
            }
            return false;
        }
        return null != payload && payload.length() > 0 && null != (obj = (parameters = this.getParameterMapFromPayload(payload)).get("action")) && obj.toString().equalsIgnoreCase("securitydetails");
    }

    protected boolean hasActionInQueryString(HttpServletRequest request) {
        String action = request.getParameter("action");
        return "securitydetails".equalsIgnoreCase(action);
    }

    protected Map getParameterMapFromPayload(String xml) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        Document doc = null;
        try {
            doc = XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new PentahoEntityResolver());
        }
        catch (XmlParseException e) {
            this.error(Messages.getErrorString("HttpWebService.ERROR_0001_ERROR_DURING_WEB_SERVICE"), e);
            return parameters;
        }
        List parameterNodes = doc.selectNodes("//SOAP-ENV:Body/*/*");
        for (int i = 0; i < parameterNodes.size(); ++i) {
            Node parameterNode = (Node)parameterNodes.get(i);
            String parameterName = parameterNode.getName();
            String parameterValue = parameterNode.getText();
            parameters.put(parameterName, parameterValue);
        }
        return parameters;
    }

    protected void doAll(HttpServletRequest request, HttpServletResponse response, StringBuffer buf) throws ServletException, IOException {
        this.doUsers(request, response, buf);
        this.doRoles(request, response, buf);
        this.doACLs(request, response, buf);
    }

    protected void doUsers(HttpServletRequest request, HttpServletResponse response, StringBuffer buf) throws ServletException, IOException {
        IUserDetailsRoleListService service = PentahoSystem.getUserDetailsRoleListService();
        buf.append("<users>");
        if (service != null) {
            List users = service.getAllUsers();
            Iterator usersIterator = users.iterator();
            while (usersIterator.hasNext()) {
                String username = usersIterator.next().toString();
                if (null == username || username.length() <= 0) continue;
                buf.append("<user><![CDATA[" + username + "]]></user>");
            }
        }
        buf.append("</users>");
    }

    protected void doRoles(HttpServletRequest request, HttpServletResponse response, StringBuffer buf) throws ServletException, IOException {
        IUserDetailsRoleListService service = PentahoSystem.getUserDetailsRoleListService();
        buf.append("<roles>");
        if (service != null) {
            List roles = service.getAllRoles();
            Iterator rolesIterator = roles.iterator();
            while (rolesIterator.hasNext()) {
                String roleName = rolesIterator.next().toString();
                if (null == roleName || roleName.length() <= 0) continue;
                buf.append("<role><![CDATA[" + roleName + "]]></role>");
            }
        }
        buf.append("</roles>");
    }

    protected void doACLs(HttpServletRequest request, HttpServletResponse response, StringBuffer buf) throws ServletException, IOException {
        Map validPermissionsNameMap = PentahoAclEntry.getValidPermissionsNameMap((String)"all");
        buf.append("<acls>");
        if (validPermissionsNameMap != null) {
            Set aclsKeySet = validPermissionsNameMap.keySet();
            Iterator aclsIterator = aclsKeySet.iterator();
            while (aclsIterator.hasNext()) {
                String aclMask;
                String aclName = aclsIterator.next().toString();
                String string = aclMask = null != validPermissionsNameMap.get(aclName) ? validPermissionsNameMap.get(aclName).toString() : null;
                if (null == aclName || aclName.length() <= 0 || null == aclMask || aclMask.length() <= 0) continue;
                buf.append("<acl>");
                buf.append("<name><![CDATA[");
                buf.append(aclName);
                buf.append("]]></name>");
                buf.append("<mask>");
                buf.append(aclMask);
                buf.append("</mask>");
                buf.append("</acl>");
            }
        }
        buf.append("</acls>");
    }
}

