/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import mondrian.rolap.agg.AggregationManager;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogServiceException;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianDataSource;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianSchema;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.RepositoryFilePublisher;
import org.pentaho.platform.web.servlet.messages.Messages;

public class MondrianCatalogPublisher
extends RepositoryFilePublisher {
    private static final Log logger = LogFactory.getLog(MondrianCatalogPublisher.class);
    private static final long serialVersionUID = -6052692173173633694L;
    private static final int FILE_ADD_DATASOURCE_PROBLEM = 6;
    private static final int FILE_ADD_XMLA_SCHEMA_EXISTS = 8;
    private static final int DATASOURCE_DRIVER_MISSING = 9;
    private IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)PentahoSessionHolder.getSession());
    private String fullyQualifiedServerURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();

    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            String dsUrl;
            resp.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
            String publishPath = req.getParameter("publishPath");
            String publishKey = req.getParameter("publishKey");
            String jndiName = req.getParameter("jndiName");
            boolean overwrite = Boolean.valueOf(req.getParameter("overwrite"));
            boolean mkdirs = Boolean.valueOf(req.getParameter("mkdirs"));
            boolean enableXmla = Boolean.valueOf(req.getParameter("enableXmla"));
            List<FileItem> fileItems = Collections.emptyList();
            try {
                fileItems = this.getFileItems(req);
            }
            catch (FileUploadException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0002_EXCEPTION_OCCURRED"), (Throwable)e);
                }
                resp.getWriter().println(2);
                PentahoSystem.systemExitPoint();
                return;
            }
            int status = 2;
            try {
                status = this.doPublish(fileItems, publishPath, publishKey, null, null, null, null, null, overwrite, mkdirs, pentahoSession);
            }
            catch (Exception e) {
                logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0005_PUBLISH_EXCEPTION"), (Throwable)e);
            }
            if (status != 3) {
                resp.getWriter().println(status);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("publishPath=" + publishPath));
            }
            if (publishPath != null && (publishPath.endsWith("/") || publishPath.endsWith("\\"))) {
                publishPath = publishPath.substring(0, publishPath.length() - 1);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("jndiName=" + jndiName));
            }
            if (StringUtils.isBlank((String)jndiName)) {
                throw new ServletException(Messages.getErrorString("MondrianCatalogPublisher.ERROR_0003_JNDINAME_REQUIRED"));
            }
            if (fileItems.size() != 1) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0004_FILE_COUNT", "" + fileItems.size()));
                }
                resp.getWriter().println(2);
                return;
            }
            FileItem fi = fileItems.iterator().next();
            String catDef = "solution:" + publishPath + "/" + fi.getName();
            MondrianSchema mondrianSchema = this.mondrianCatalogService.loadMondrianSchema(catDef, pentahoSession);
            String catName = mondrianSchema.getName();
            try {
                IDatasourceService datasourceService = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, null);
                datasourceService.getDataSource(jndiName);
            }
            catch (ObjectFactoryException objface) {
                logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0006_UNABLE_TO_FACTORY_OBJECT", jndiName), (Throwable)objface);
            }
            catch (DatasourceServiceException dse) {
                if (dse.getCause() instanceof ClassNotFoundException) {
                    logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0009_DATASOURCE_DRIVER_MISSING", jndiName), (Throwable)dse);
                    resp.getWriter().println(9);
                } else {
                    logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0001_JNDI_NAMING_ERROR", jndiName), (Throwable)dse);
                    resp.getWriter().println(6);
                }
                PentahoSystem.systemExitPoint();
                return;
            }
            String catConnectStr = "Provider=mondrian;DataSource=" + jndiName;
            if (!enableXmla) {
                catConnectStr = catConnectStr + ";EnableXmla=False";
            }
            if (!(dsUrl = this.fullyQualifiedServerURL).endsWith("/")) {
                dsUrl = dsUrl + "/";
            }
            dsUrl = dsUrl + "Xmla";
            MondrianDataSource ds = new MondrianDataSource("Provider=Mondrian;DataSource=Pentaho", "Pentaho BI Platform Datasources", dsUrl, "Provider=Mondrian", "PentahoXMLA", "MDP", "Unauthenticated", null);
            MondrianCatalog cat = new MondrianCatalog(catName, catConnectStr, catDef, ds, new MondrianSchema(catName, new ArrayList()));
            try {
                this.mondrianCatalogService.addCatalog(cat, overwrite, pentahoSession);
            }
            catch (MondrianCatalogServiceException e) {
                if (logger.isErrorEnabled()) {
                    logger.error((Object)Messages.getErrorString("MondrianCatalogPublisher.ERROR_0002_EXCEPTION_OCCURRED"), (Throwable)e);
                }
                if (e.getReason().equals((Object)MondrianCatalogServiceException.Reason.XMLA_SCHEMA_NAME_EXISTS)) {
                    resp.getWriter().println(8);
                } else {
                    resp.getWriter().println(2);
                }
                PentahoSystem.systemExitPoint();
                return;
            }
            AggregationManager.instance().getCacheControl(null, null).flushSchemaCache();
            resp.getWriter().println(3);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    public IMondrianCatalogService getMondrianCatalogService() {
        return this.mondrianCatalogService;
    }

    public void setMondrianCatalogService(IMondrianCatalogService mondrianCatalogService) {
        this.mondrianCatalogService = mondrianCatalogService;
    }

    public String getFullyQualifiedServerURL() {
        return this.fullyQualifiedServerURL;
    }

    public void setFullyQualifiedServerURL(String fullyQualifiedServerURL) {
        this.fullyQualifiedServerURL = fullyQualifiedServerURL;
    }
}

