/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import javax.sql.DataSource;
import mondrian.spi.DataSourceResolver;
import org.apache.log4j.Logger;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;
import org.pentaho.platform.api.engine.ObjectFactoryException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.messages.Messages;

public class PentahoDataSourceResolver
implements DataSourceResolver {
    Logger logger = Logger.getLogger(PentahoDataSourceResolver.class);

    public DataSource lookup(String dataSourceName) throws Exception {
        try {
            IDatasourceService datasourceSvc = (IDatasourceService)PentahoSystem.getObjectFactory().get(IDatasourceService.class, PentahoSessionHolder.getSession());
            DataSource datasource = datasourceSvc.getDataSource(datasourceSvc.getDSUnboundName(dataSourceName));
            return datasource;
        }
        catch (ObjectFactoryException e) {
            this.logger.error((Object)Messages.getErrorString("PentahoXmlaServlet.ERROR_0002_UNABLE_TO_INSTANTIATE"), (Throwable)e);
            throw e;
        }
        catch (DatasourceServiceException e) {
            this.logger.error((Object)Messages.getErrorString("PentahoXmlaServlet.ERROR_0002_UNABLE_TO_INSTANTIATE"), (Throwable)e);
            throw e;
        }
    }
}

