/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import mondrian.olap.Connection;
import mondrian.olap.DriverManager;
import mondrian.olap.MondrianServer;
import mondrian.server.DynamicContentFinder;
import mondrian.server.FileRepository;
import mondrian.server.RepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.impl.DynamicDatasourceXmlaServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.olap4j.OlapConnection;
import org.pentaho.platform.api.engine.IConnectionUserRoleMapper;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.PentahoEntityResolver;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.xml.sax.EntityResolver;

public class PentahoXmlaServlet
extends DynamicDatasourceXmlaServlet {
    private static final long serialVersionUID = 5801343357261568600L;
    private static final Log logger = LogFactory.getLog(PentahoXmlaServlet.class);

    protected DynamicContentFinder makeContentFinder(String dataSourcesUrl) {
        return new DynamicContentFinder(dataSourcesUrl){

            public String getContent() {
                String original = super.getContent();
                PentahoEntityResolver loader = new PentahoEntityResolver();
                Document originalDocument = null;
                try {
                    originalDocument = XmlDom4JHelper.getDocFromString((String)original, (EntityResolver)loader);
                }
                catch (XmlParseException e) {
                    logger.error((Object)Messages.getString("PentahoXmlaServlet.ERROR_0004_UNABLE_TO_GET_DOCUMENT_FROM_STRING"), (Throwable)e);
                    return null;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getString("PentahoXmlaServlet.DEBUG_ORIG_DOC", originalDocument.asXML()));
                }
                Document modifiedDocument = (Document)originalDocument.clone();
                List nodesToRemove = modifiedDocument.selectNodes("/DataSources/DataSource/Catalogs/Catalog[contains(DataSourceInfo, 'EnableXmla=False')]");
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getString("PentahoXmlaServlet.DEBUG_NODES_TO_REMOVE", String.valueOf(nodesToRemove.size())));
                }
                for (Node node : nodesToRemove) {
                    node.detach();
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)Messages.getString("PentahoXmlaServlet.DEBUG_MOD_DOC", modifiedDocument.asXML()));
                }
                return modifiedDocument.asXML();
            }
        };
    }

    protected CatalogLocator makeCatalogLocator(ServletConfig servletConfig) {
        return new ServletContextCatalogLocator(servletConfig.getServletContext()){

            public String locate(String catalogPath) {
                if (catalogPath.startsWith("solution:")) {
                    if ((catalogPath = catalogPath.substring(9)).startsWith("/")) {
                        catalogPath = catalogPath.substring(1);
                    }
                    return "file:" + PentahoSystem.getApplicationContext().getSolutionPath(catalogPath);
                }
                return super.locate(catalogPath);
            }
        };
    }

    protected String makeDataSourcesUrl(ServletConfig config) {
        String path = "file:" + PentahoSystem.getApplicationContext().getSolutionPath("system/olap/datasources.xml");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)Messages.getString("PentahoXmlaServlet.DEBUG_SCHEMA_FILE_PATH", path));
        }
        return path;
    }

    protected XmlaHandler.ConnectionFactory createConnectionFactory(final ServletConfig servletConfig) throws ServletException {
        final XmlaHandler.ConnectionFactory delegate = super.createConnectionFactory(servletConfig);
        return new XmlaHandler.ConnectionFactory(){

            public Map<String, Object> getPreConfiguredDiscoverDatasourcesResponse() {
                return delegate.getPreConfiguredDiscoverDatasourcesResponse();
            }

            public OlapConnection getConnection(String databaseName, String catalogName, String roleName, Properties props) throws SQLException {
                IPentahoSession session = PentahoSessionHolder.getSession();
                IConnectionUserRoleMapper mondrianUserRoleMapper = (IConnectionUserRoleMapper)PentahoSystem.get(IConnectionUserRoleMapper.class, (String)"Mondrian-UserRoleMapper", null);
                String[] effectiveRoles = new String[]{};
                if (mondrianUserRoleMapper != null && catalogName != null) {
                    try {
                        effectiveRoles = mondrianUserRoleMapper.mapConnectionRoles(session, catalogName);
                        if (effectiveRoles == null) {
                            effectiveRoles = new String[]{};
                        }
                    }
                    catch (PentahoAccessControlException e) {
                        throw new SQLException(e);
                    }
                }
                boolean addComma = false;
                roleName = "";
                for (String role : effectiveRoles) {
                    if (addComma) {
                        roleName = roleName.concat(",");
                    }
                    roleName = roleName.concat(role);
                    addComma = true;
                }
                if (catalogName == null) {
                    return delegate.getConnection(databaseName, catalogName, roleName.equals("") ? null : roleName, props);
                }
                MondrianCatalog mc = MondrianCatalogHelper.getInstance().getCatalog(catalogName, PentahoSessionHolder.getSession());
                Connection con = DriverManager.getConnection((String)(mc.getDataSourceInfo() + ";Catalog=" + mc.getDefinition()), (CatalogLocator)PentahoXmlaServlet.this.makeCatalogLocator(servletConfig));
                MondrianServer server = MondrianServer.forConnection((Connection)con);
                FileRepository fr = new FileRepository((RepositoryContentFinder)PentahoXmlaServlet.this.makeContentFinder(PentahoXmlaServlet.this.makeDataSourcesUrl(servletConfig)), PentahoXmlaServlet.this.makeCatalogLocator(servletConfig));
                return fr.getConnection(server, databaseName, catalogName, roleName, props);
            }
        };
    }
}

