/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

public class ProxyServlet
extends ServletBase {
    private static final long serialVersionUID = 4680027723733552639L;
    private static final Log logger = LogFactory.getLog(ProxyServlet.class);
    String proxyURL = null;
    String errorURL = null;

    public Log getLogger() {
        return logger;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.proxyURL = servletConfig.getInitParameter("ProxyURL");
        if (this.proxyURL == null) {
            this.error(Messages.getString("ProxyServlet.ERROR_0001_NO_PROXY_URL_SPECIFIED"));
        } else {
            this.proxyURL.trim();
            try {
                URL url = new URL(this.proxyURL);
                this.info(Messages.getString("ProxyServlet.INFO_0001_URL_SELECTED", url.toExternalForm()));
            }
            catch (Throwable t) {
                this.error(Messages.getErrorString("ProxyServlet.ERROR_0002_INVALID_URL", this.proxyURL));
                this.proxyURL = null;
            }
        }
        this.errorURL = servletConfig.getInitParameter("ErrorURL");
        super.init(servletConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProxy(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.proxyURL == null) {
            return;
        }
        String servletPath = request.getServletPath();
        PentahoSystem.systemEntryPoint();
        try {
            String theUrl = this.proxyURL + servletPath;
            PostMethod method = new PostMethod(theUrl);
            Map paramMap = request.getParameterMap();
            for (Map.Entry entry : paramMap.entrySet()) {
                String[] array;
                for (String element : array = (String[])entry.getValue()) {
                    method.addParameter((String)entry.getKey(), element);
                }
            }
            method.removeParameter("_TRUST_USER_");
            IPentahoSession userSession = this.getPentahoSession(request);
            String name = userSession.getName();
            if (name != null && name.length() > 0) {
                method.addParameter("_TRUST_USER_", name);
            } else if (this.errorURL != null && this.errorURL.trim().length() > 0) {
                response.sendRedirect(this.errorURL);
                return;
            }
            this.debug(Messages.getString("ProxyServlet.DEBUG_0001_OUTPUT_URL", theUrl));
            HttpClient client = new HttpClient();
            try {
                int statusCode = client.executeMethod((HttpMethod)method);
                if (statusCode != 200) {
                    this.error(Messages.getErrorString("ProxyServlet.ERROR_0003_REMOTE_HTTP_CALL_FAILED", method.getStatusLine().toString()));
                    return;
                }
                this.setHeader("Content-Type", (HttpMethod)method, response);
                this.setHeader("Content-Length", (HttpMethod)method, response);
                InputStream inStr = method.getResponseBodyAsStream();
                ServletOutputStream outStr = response.getOutputStream();
                int inCnt = 0;
                byte[] buf = new byte[2048];
                while (-1 != (inCnt = inStr.read(buf))) {
                    outStr.write(buf, 0, inCnt);
                }
            }
            catch (HttpException e) {
                this.error(Messages.getErrorString("ProxyServlet.ERROR_0004_PROTOCOL_FAILURE"), e);
                e.printStackTrace();
            }
            catch (IOException e) {
                this.error(Messages.getErrorString("ProxyServlet.ERROR_0005_TRANSPORT_FAILURE"), e);
                e.printStackTrace();
            }
            finally {
                method.releaseConnection();
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    void setHeader(String headerStr, HttpMethod method, HttpServletResponse response) {
        Header header = method.getResponseHeader(headerStr);
        if (header != null) {
            response.setHeader(headerStr, header.getValue());
        }
    }

    protected void service(HttpServletRequest arg0, HttpServletResponse arg1) throws ServletException, IOException {
        super.service(arg0, arg1);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProxy(request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProxy(request, response);
    }
}

