/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISolutionRepository;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.client.PublisherUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.servlet.GetContent;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryFilePublisher
extends ServletBase {
    private static final long serialVersionUID = 9019152264205996418L;
    private static final long DEFAULT_MAX_FILE_SIZE = 10000000L;
    private static final Log logger = LogFactory.getLog(GetContent.class);
    private static final String PublishConfigFile = "publisher_config.xml";

    @Override
    public Log getLogger() {
        return logger;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        try {
            response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
            String publishPath = request.getParameter("publishPath");
            String publishKey = request.getParameter("publishKey");
            String jndiName = request.getParameter("jndiName");
            String jdbcDriver = request.getParameter("jdbcDriver");
            String jdbcUrl = request.getParameter("jdbcUrl");
            String jdbcUserId = request.getParameter("jdbcUserId");
            String jdbcPassword = request.getParameter("jdbcPassword");
            boolean overwrite = Boolean.valueOf(request.getParameter("overwrite"));
            boolean mkdirs = Boolean.valueOf(request.getParameter("mkdirs"));
            List<FileItem> fileItems = Collections.emptyList();
            try {
                fileItems = this.getFileItems(request);
            }
            catch (FileUploadException e) {
                e.printStackTrace();
                if (logger.isErrorEnabled()) {
                    logger.error((Object)"an exception occurred", (Throwable)e);
                }
                response.getWriter().println(2);
                PentahoSystem.systemExitPoint();
                return;
            }
            int status = this.doPublish(fileItems, publishPath, publishKey, jndiName, jdbcDriver, jdbcUrl, jdbcUserId, jdbcPassword, overwrite, mkdirs, pentahoSession);
            response.getWriter().println(status);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected List<FileItem> getFileItems(HttpServletRequest request) throws FileUploadException {
        ServletFileUpload fu = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        long sizeLimit = 10000000L;
        String maxFileSizeString = PentahoSystem.getSystemSetting((String)"file-upload-defaults/max-file-limit", (String)String.valueOf(10000000L));
        try {
            sizeLimit = Long.parseLong(maxFileSizeString);
        }
        catch (Exception mostlyIgnored) {
            logger.error((Object)Messages.getErrorString("RepositoryFilePublisher.ERROR_0001_INVALID_MAX_FILE_SIZE"));
        }
        fu.setSizeMax(sizeLimit);
        return fu.parseRequest(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int doPublish(List<FileItem> fileItems, String publishPath, String publishKey, String jndiName, String jdbcDriver, String jdbcUrl, String jdbcUserId, String jdbcPassword, boolean overwrite, boolean mkdirs, IPentahoSession pentahoSession) {
        ISolutionRepository repository = (ISolutionRepository)PentahoSystem.get(ISolutionRepository.class, (IPentahoSession)pentahoSession);
        int status = 3;
        String cleanPublishPath = publishPath;
        if (publishPath != null && (publishPath.endsWith("/") || publishPath.endsWith("\\"))) {
            cleanPublishPath = publishPath.substring(0, publishPath.length() - 1);
        }
        cleanPublishPath = cleanPublishPath.replace('\\', '/');
        if (!RepositoryFilePublisher.checkPublisherKey(publishKey)) return 4;
        String solutionPath = PentahoSystem.getApplicationContext().getSolutionPath("");
        try {
            PentahoSystem.systemEntryPoint();
            ISolutionFile folder = repository.getSolutionFile(cleanPublishPath, 4);
            if (folder == null) {
                if (mkdirs) {
                    StringTokenizer tokenizer = new StringTokenizer(cleanPublishPath, "/");
                    StringBuilder testPath = new StringBuilder();
                    int idx = 1;
                    while (tokenizer.hasMoreTokens()) {
                        String folderName = tokenizer.nextToken();
                        testPath.append('/').append(folderName);
                        ISolutionFile testFolder = repository.getSolutionFile(testPath.toString(), 4);
                        if (idx == 1 && testFolder == null) {
                            status = 2;
                            break;
                        }
                        if (testFolder == null) {
                            String newFolderPath = PentahoSystem.getApplicationContext().getSolutionPath(testPath.toString());
                            File newFolder = new File(newFolderPath);
                            repository.createFolder(newFolder);
                        }
                        ++idx;
                    }
                } else {
                    status = 2;
                }
            }
            if (status != 3) return status;
            int i = 0;
            while (i < fileItems.size()) {
                if (status != 3) return status;
                FileItem fi = fileItems.get(i);
                String name = URLDecoder.decode(fi.getName(), "UTF-8");
                status = repository.publish(solutionPath, cleanPublishPath, name, fi.get(), overwrite);
                ++i;
            }
            return status;
        }
        catch (PentahoAccessControlException e) {
            status = 2;
            if (!logger.isErrorEnabled()) return status;
            logger.error((Object)"an error occurred", (Throwable)e);
            return status;
        }
        catch (IOException e) {
            status = 2;
            if (!logger.isErrorEnabled()) return status;
            logger.error((Object)"an error occurred", (Throwable)e);
            return status;
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    public static final boolean checkPublisherKey(String key) {
        String setting;
        Node node;
        Document doc;
        if (key != null && (doc = PentahoSystem.getSystemSettings().getSystemSettingsDocument(PublishConfigFile)) != null && (node = doc.selectSingleNode("//publisher-config/publisher-password")) != null && (setting = node.getText()) != null && setting.length() > 0) {
            if (setting.startsWith("MD5:")) {
                String pubKey = setting.substring(4);
                return pubKey.equals(key);
            }
            String pubKey = PublisherUtil.getPasswordKey((String)setting);
            return pubKey.equals(key);
        }
        return false;
    }
}

