/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.api.repository.ISolutionRepositoryService;
import org.pentaho.platform.api.repository.SolutionRepositoryServiceException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.WebServiceUtil;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.messages.Messages;
import org.w3c.dom.Document;

public class SolutionRepositoryService
extends ServletBase {
    private static final long serialVersionUID = -5870073658756939643L;
    private static final Log logger = LogFactory.getLog(SolutionRepositoryService.class);

    public Log getLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        ServletOutputStream outputStream = response.getOutputStream();
        try {
            boolean wrapWithSoap = "false".equals(request.getParameter("ajax"));
            String component = request.getParameter("component");
            response.setContentType("text/xml");
            response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
            IPentahoSession userSession = this.getPentahoSession(request);
            response.setHeader("expires", "0");
            this.dispatch(request, response, component, (OutputStream)outputStream, userSession, wrapWithSoap);
        }
        catch (SolutionRepositoryServiceException ex) {
            this.commonErrorHandler((OutputStream)outputStream, (Exception)((Object)ex));
        }
        catch (PentahoAccessControlException ex) {
            this.commonErrorHandler((OutputStream)outputStream, (Exception)((Object)ex));
        }
        catch (TransformerConfigurationException ex) {
            this.commonErrorHandler((OutputStream)outputStream, ex);
        }
        catch (ParserConfigurationException ex) {
            this.commonErrorHandler((OutputStream)outputStream, ex);
        }
        catch (TransformerException ex) {
            this.commonErrorHandler((OutputStream)outputStream, ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            this.commonErrorHandler((OutputStream)outputStream, ex.getException());
        }
        catch (IOException ex) {
            this.debugErrorHandler((OutputStream)outputStream, ex);
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
        this.debug(Messages.getString("HttpWebService.DEBUG_WEB_SERVICE_END"));
    }

    protected void debugErrorHandler(OutputStream outputStream, Exception ex) throws IOException {
        String msg = Messages.getErrorString("SolutionRepositoryService.ERROR_0001_ERROR_DURING_SERVICE_REQUEST");
        this.debug(msg, ex);
        WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
    }

    protected void commonErrorHandler(OutputStream outputStream, Exception ex) throws IOException {
        String msg = Messages.getErrorString("SolutionRepositoryService.ERROR_0001_ERROR_DURING_SERVICE_REQUEST");
        this.error(msg, ex);
        WebServiceUtil.writeString((OutputStream)outputStream, (String)WebServiceUtil.getErrorXml((String)msg), (boolean)false);
    }

    protected String[] getFilters(HttpServletRequest request) {
        String filter = request.getParameter("filter");
        ArrayList<String> filters = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)filter)) {
            StringTokenizer st = new StringTokenizer(filter, "*.,");
            while (st.hasMoreTokens()) {
                filters.add(st.nextToken());
            }
        }
        return filters.toArray(new String[0]);
    }

    protected void dispatch(HttpServletRequest request, HttpServletResponse response, String component, OutputStream outputStream, IPentahoSession userSession, boolean wrapWithSOAP) throws IOException, SolutionRepositoryServiceException, PentahoAccessControlException, ParserConfigurationException, TransformerConfigurationException, TransformerException, TransformerFactoryConfigurationError {
        ISolutionRepositoryService service = (ISolutionRepositoryService)PentahoSystem.get(ISolutionRepositoryService.class, (IPentahoSession)userSession);
        HttpRequestParameterProvider parameterProvider = new HttpRequestParameterProvider(request);
        if ("getSolutionRepositoryDoc".equals(component)) {
            String[] filters = this.getFilters(request);
            Document doc = service.getSolutionRepositoryDoc(userSession, filters);
            WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSOAP);
        } else if ("getSolutionRepositoryFileDetails".equals(component)) {
            String fullPath = request.getParameter("fullPath");
            Document doc = service.getSolutionRepositoryFileDetails(userSession, fullPath);
            WebServiceUtil.writeDocument((OutputStream)outputStream, (Document)doc, (boolean)wrapWithSOAP);
        } else if ("createNewFolder".equals(component)) {
            String solution = request.getParameter("solution");
            String path = request.getParameter("path");
            String name = request.getParameter("name");
            String desc = request.getParameter("desc");
            boolean result = service.createFolder(userSession, solution, path, name, desc);
            WebServiceUtil.writeString((OutputStream)outputStream, (String)("<result>" + result + "</result>"), (boolean)wrapWithSOAP);
        } else if ("delete".equals(component)) {
            String solution = request.getParameter("solution");
            String path = request.getParameter("path");
            String name = request.getParameter("name");
            boolean result = service.delete(userSession, solution, path, name);
            WebServiceUtil.writeString((OutputStream)outputStream, (String)("<result>" + result + "</result>"), (boolean)wrapWithSOAP);
        } else if ("setAcl".equals(component)) {
            String solution = parameterProvider.getStringParameter("solution", null);
            String path = parameterProvider.getStringParameter("path", null);
            String filename = parameterProvider.getStringParameter("filename", null);
            String strAclXml = parameterProvider.getStringParameter("aclXml", null);
            service.setAcl(solution, path, filename, strAclXml, userSession);
            String msg = WebServiceUtil.getStatusXml((String)Messages.getString("AdhocWebService.ACL_UPDATE_SUCCESSFUL"));
            WebServiceUtil.writeString((OutputStream)outputStream, (String)msg, (boolean)wrapWithSOAP);
        } else if ("getAcl".equals(component)) {
            String solution = parameterProvider.getStringParameter("solution", null);
            String path = parameterProvider.getStringParameter("path", null);
            String filename = parameterProvider.getStringParameter("filename", null);
            String aclXml = service.getAclXml(solution, path, filename, userSession);
            WebServiceUtil.writeString((OutputStream)outputStream, (String)aclXml, (boolean)wrapWithSOAP);
        } else {
            throw new RuntimeException(Messages.getErrorString("HttpWebService.UNRECOGNIZED_COMPONENT_REQUEST", component));
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public Document getSolutionRepositoryDoc(IPentahoSession session, String[] filters) throws ParserConfigurationException {
        ISolutionRepositoryService service = (ISolutionRepositoryService)PentahoSystem.get(ISolutionRepositoryService.class, (IPentahoSession)session);
        return service.getSolutionRepositoryDoc(session, filters);
    }
}

