/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IMessageFormatter;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.repository.SubscriptionAdminException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.PentahoHttpSessionHelper;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.jsp.messages.Messages;
import org.pentaho.platform.web.refactor.SubscriptionAdminUIComponent;
import org.pentaho.platform.web.servlet.ServletBase;

public class SubscriptionAdminServlet
extends ServletBase {
    private static final Log logger = LogFactory.getLog(SubscriptionAdminServlet.class);
    private static final long serialVersionUID = 420L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block13: {
            PentahoSystem.systemEntryPoint();
            IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
            try {
                response.setCharacterEncoding(LocaleHelper.getSystemEncoding());
                String baseUrl = PentahoSystem.getApplicationContext().getBaseUrl();
                String mimeType = request.getParameter("requestedMimeType");
                if (StringUtils.isEmpty((String)mimeType)) {
                    mimeType = "text/html";
                }
                IPentahoSession userSession = PentahoHttpSessionHelper.getPentahoSession((HttpServletRequest)request);
                HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
                HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
                String thisUrl = requestContext.getContextPath() + "SubscriptionAdmin?";
                SimpleUrlFactory urlFactory = new SimpleUrlFactory(thisUrl);
                ArrayList messages = new ArrayList();
                String content = "";
                SubscriptionAdminUIComponent admin = null;
                String intro = "";
                String footer = "";
                try {
                    admin = new SubscriptionAdminUIComponent((IPentahoUrlFactory)urlFactory, messages);
                    admin.validate(userSession, null);
                    admin.setParameterProvider("request", (IParameterProvider)requestParameters);
                    admin.setParameterProvider("session", (IParameterProvider)sessionParameters);
                    content = admin.getContent(mimeType);
                    if ("text/html".equals(mimeType)) {
                        IUITemplater templater;
                        response.setHeader("Pragma", "no-cache");
                        response.setHeader("Cache-Control", "no-store, no-cache, private, must-revalidate, max-stale=0");
                        response.setHeader("Expires", "0");
                        if (content == null) {
                            StringBuffer buffer = new StringBuffer();
                            ((IMessageFormatter)PentahoSystem.get(IMessageFormatter.class, (IPentahoSession)userSession)).formatErrorMessage("text/html", "ERROR", messages, buffer);
                            content = buffer.toString();
                        }
                        if ((templater = (IUITemplater)PentahoSystem.get(IUITemplater.class, (IPentahoSession)userSession)) != null) {
                            String[] sections = templater.breakTemplate("template.html", "Subscribe Manager", userSession);
                            if (sections != null && sections.length > 0) {
                                intro = sections[0];
                            }
                            if (sections != null && sections.length > 1) {
                                footer = sections[1];
                            }
                        } else {
                            intro = Messages.getString((String)"UI.ERROR_0002_BAD_TEMPLATE_OBJECT");
                        }
                        content = content.replaceAll("\\\\", "\\\\\\\\");
                        content = content.replaceAll("\\$", "\\\\\\$");
                        response.getWriter().print(intro);
                        response.getWriter().print(content);
                        response.getWriter().print(footer);
                        break block13;
                    }
                    if (content == null) {
                        content = "<error msg='Error'></error>";
                    }
                    response.getWriter().print(content);
                }
                catch (SubscriptionAdminException e) {
                    content = "<error msg='Error'></error>";
                    response.getWriter().print(content);
                }
            }
            finally {
                PentahoSystem.systemExitPoint();
            }
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public Log getLogger() {
        return logger;
    }
}

