/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IBackgroundExecution;
import org.pentaho.platform.api.engine.IMimeTypeListener;
import org.pentaho.platform.api.engine.IOutputHandler;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPentahoUrlFactory;
import org.pentaho.platform.api.engine.IUITemplater;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.scheduler.BackgroundExecutionException;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ActionSequenceContentGenerator;
import org.pentaho.platform.repository.subscription.SubscriptionHelper;
import org.pentaho.platform.util.web.SimpleUrlFactory;
import org.pentaho.platform.web.http.HttpOutputHandler;
import org.pentaho.platform.web.http.request.HttpRequestParameterProvider;
import org.pentaho.platform.web.http.session.HttpSessionParameterProvider;
import org.pentaho.platform.web.servlet.HttpMimeTypeListener;
import org.pentaho.platform.web.servlet.ServletBase;
import org.pentaho.platform.web.servlet.ViewAction;
import org.pentaho.platform.web.servlet.messages.Messages;

public class ViewActionExperimental
extends ServletBase {
    private static final long serialVersionUID = 4680027723733552639L;
    private static final Log logger = LogFactory.getLog(ViewAction.class);

    public Log getLogger() {
        return logger;
    }

    protected boolean doBackgroundExecution(HttpServletRequest request, HttpServletResponse response, IPentahoSession userSession) throws ServletException, IOException {
        if ("true".equals(request.getParameter("background"))) {
            IBackgroundExecution backgroundExecutionHandler = (IBackgroundExecution)PentahoSystem.get(IBackgroundExecution.class, (IPentahoSession)userSession);
            if (backgroundExecutionHandler != null) {
                HttpRequestParameterProvider parameterProvider = new HttpRequestParameterProvider(request);
                String intro = "";
                String footer = "";
                IUITemplater templater = (IUITemplater)PentahoSystem.get(IUITemplater.class, (IPentahoSession)userSession);
                if (templater != null) {
                    String[] sections = templater.breakTemplate("template-dialog.html", "", userSession);
                    if (sections != null && sections.length > 0) {
                        intro = sections[0];
                    }
                    if (sections != null && sections.length > 1) {
                        footer = sections[1];
                    }
                } else {
                    intro = Messages.getString("ViewAction.ERROR_0002_BAD_TEMPLATE_OBJECT");
                }
                response.getWriter().print(intro);
                String backgroundResponse = null;
                try {
                    backgroundResponse = backgroundExecutionHandler.backgroundExecuteAction(userSession, (IParameterProvider)parameterProvider);
                }
                catch (BackgroundExecutionException bex) {
                    backgroundResponse = bex.getLocalizedMessage();
                    response.getWriter().print(backgroundResponse);
                    response.getWriter().print(footer);
                    this.error(Messages.getErrorString("ViewAction.ERROR_0004_UNABLE_TO_PERFORM_BACKGROUND_EXECUTION"));
                    return false;
                }
                response.getWriter().print(backgroundResponse);
                response.getWriter().print(footer);
                return true;
            }
            this.error(Messages.getErrorString("ViewAction.ERROR_0001_BACKGROUND_EXECUTE_NOT_SUPPORTED"));
        }
        return false;
    }

    protected OutputStream getOutputStream(HttpServletResponse response, boolean doMessages) throws ServletException, IOException {
        Object outputStream = null;
        outputStream = doMessages ? new ByteArrayOutputStream() : response.getOutputStream();
        return outputStream;
    }

    protected boolean doMessages(HttpServletRequest request) {
        return "true".equalsIgnoreCase(request.getParameter("debug"));
    }

    protected void handleActionRequest(HttpServletRequest request, HttpServletResponse response, HttpOutputHandler outputHandler, OutputStream outputStream, IContentItem contentItem, IPentahoSession userSession) throws ServletException, IOException {
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        try {
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
            HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
            HashMap<String, Object> parameterProviders = new HashMap<String, Object>();
            parameterProviders.put("request", requestParameters);
            parameterProviders.put("session", sessionParameters);
            SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath() + "ViewAction?");
            ArrayList messages = new ArrayList();
            ActionSequenceContentGenerator contentGenerator = new ActionSequenceContentGenerator();
            contentGenerator.setOutputHandler((IOutputHandler)outputHandler);
            contentGenerator.setMessagesList(messages);
            contentGenerator.setParameterProviders(parameterProviders);
            contentGenerator.setSession(userSession);
            contentGenerator.setUrlFactory((IPentahoUrlFactory)urlFactory);
            contentGenerator.createContent();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (contentItem != null) {
            contentItem.closeOutputStream();
        }
    }

    protected HttpOutputHandler createOutputHandler(HttpServletResponse response, OutputStream outputStream) {
        return new HttpOutputHandler(response, outputStream, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PentahoSystem.systemEntryPoint();
        IContentItem contentItem = null;
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        try {
            IPentahoSession userSession = this.getPentahoSession(request);
            if (!this.doBackgroundExecution(request, response, userSession)) {
                OutputStream outputStream = this.getOutputStream(response, this.doMessages(request));
                HttpOutputHandler outputHandler = this.createOutputHandler(response, outputStream);
                outputHandler.setSession(userSession);
                HttpMimeTypeListener listener = new HttpMimeTypeListener(request, response);
                outputHandler.setMimeTypeListener((IMimeTypeListener)listener);
                SimpleUrlFactory urlFactory = new SimpleUrlFactory(requestContext.getContextPath() + "ViewAction?");
                HttpRequestParameterProvider requestParameters = new HttpRequestParameterProvider(request);
                if (!this.handleSubscriptions(request, response, userSession, (IParameterProvider)requestParameters, outputStream, urlFactory)) {
                    this.handleActionRequest(request, response, outputHandler, outputStream, contentItem, userSession);
                }
            }
        }
        finally {
            PentahoSystem.systemExitPoint();
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    protected boolean handleSubscriptions(HttpServletRequest request, HttpServletResponse response, IPentahoSession userSession, IParameterProvider requestParameters, OutputStream outputStream, SimpleUrlFactory urlFactory) throws ServletException, IOException {
        String name;
        int pos;
        String subscribeAction = request.getParameter("subscribe");
        if ("run".equals(subscribeAction)) {
            String name2 = requestParameters.getStringParameter("subscribe-name", null);
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
            HttpOutputHandler outputHandler = new HttpOutputHandler(response, outputStream, true);
            SubscriptionHelper.runSubscription((String)name2, (IPentahoSession)userSession, (IParameterProvider)sessionParameters, (SimpleUrlFactory)urlFactory, (IOutputHandler)outputHandler);
            return true;
        }
        if ("archived".equals(subscribeAction)) {
            String name3 = requestParameters.getStringParameter("subscribe-name", null);
            int pos2 = name3.lastIndexOf(58);
            if (pos2 != -1) {
                String fileId = name3.substring(pos2 + 1);
                name3 = name3.substring(0, pos2);
                HttpOutputHandler outputHandler = new HttpOutputHandler(response, outputStream, true);
                SubscriptionHelper.getArchived((String)name3, (String)fileId, (IPentahoSession)userSession, (IOutputHandler)outputHandler);
            }
            return true;
        }
        if ("archive".equals(subscribeAction)) {
            String name4 = requestParameters.getStringParameter("subscribe-name", null);
            HttpSessionParameterProvider sessionParameters = new HttpSessionParameterProvider(userSession);
            HttpOutputHandler outputHandler = new HttpOutputHandler(response, outputStream, true);
            IContentItem contentItem = outputHandler.getOutputContentItem("response", "content", null, null, "text/html");
            outputStream = contentItem.getOutputStream(name4);
            String resp = null;
            try {
                resp = SubscriptionHelper.createSubscriptionArchive((String)name4, (IPentahoSession)userSession, null, (IParameterProvider)sessionParameters);
            }
            catch (BackgroundExecutionException bex) {
                resp = bex.getLocalizedMessage();
                this.error(Messages.getErrorString("ViewAction.ERROR_0003_UNABLE_TO_CREATE_SUBSCRIPTION_ARCHIVE"));
                outputStream.write(resp.getBytes());
                contentItem.closeOutputStream();
                return false;
            }
            outputStream.write(resp.getBytes());
            contentItem.closeOutputStream();
            return true;
        }
        if ("save".equals(subscribeAction)) {
            String solutionName = requestParameters.getStringParameter("solution", null);
            String actionPath = requestParameters.getStringParameter("path", null);
            String actionName = requestParameters.getStringParameter("action", null);
            String actionReference = solutionName + "/" + actionPath + "/" + actionName;
            String result = SubscriptionHelper.saveSubscription((IParameterProvider)requestParameters, (String)actionReference, (IPentahoSession)userSession);
            outputStream.write(result.getBytes());
            return true;
        }
        if ("edit".equals(subscribeAction)) {
            String name5 = requestParameters.getStringParameter("subscribe-name", null);
            SubscriptionHelper.editSubscription((String)name5, (IPentahoSession)userSession, (SimpleUrlFactory)urlFactory, (OutputStream)outputStream);
            return true;
        }
        if ("delete".equals(subscribeAction)) {
            String name6 = requestParameters.getStringParameter("subscribe-name", null);
            String result = SubscriptionHelper.deleteSubscription((String)name6, (IPentahoSession)userSession);
            outputStream.write(result.getBytes());
            return true;
        }
        if ("delete-archived".equals(subscribeAction) && (pos = (name = requestParameters.getStringParameter("subscribe-name", null)).lastIndexOf(58)) != -1) {
            String fileId = name.substring(pos + 1);
            name = name.substring(0, pos);
            String result = SubscriptionHelper.deleteSubscriptionArchive((String)name, (String)fileId, (IPentahoSession)userSession);
            outputStream.write(result.getBytes());
            return true;
        }
        return false;
    }
}

