/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TRACKMOUSEEVENT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int DRAW_BACKGROUND = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int TRACK_MOUSE = 8192;
    static final int FOREIGN_HANDLE = 16384;
    static final int DRAG_DETECT = 32768;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int MAJOR = 5;
    static final int MINOR = 80;

    static {
        if (!OS.IsWinCE && OS.COMCTL32_VERSION < OS.VERSION(5, 80)) {
            System.out.println("***WARNING: SWT requires comctl32.dll version 5.80 or greater");
            System.out.println("***WARNING: Detected: " + OS.COMCTL32_MAJOR + "." + OS.COMCTL32_MINOR);
        }
        OS.InitCommonControls();
    }

    Widget() {
    }

    public Widget(Widget widget, int n) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n;
        this.display = widget.display;
    }

    void _addListener(int n, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n, listener);
    }

    public void addListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        return 0;
    }

    static int checkBits(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = n2 | n3 | n4 | n5 | n6 | n7;
        if ((n & n8) == 0) {
            n |= n2;
        }
        if ((n & n2) != 0) {
            n = n & ~n8 | n2;
        }
        if ((n & n3) != 0) {
            n = n & ~n8 | n3;
        }
        if ((n & n4) != 0) {
            n = n & ~n8 | n4;
        }
        if ((n & n5) != 0) {
            n = n & ~n8 | n5;
        }
        if ((n & n6) != 0) {
            n = n & ~n8 | n6;
        }
        if ((n & n7) != 0) {
            n = n & ~n8 | n7;
        }
        return n;
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkOpened() {
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpened();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    int DeferWindowPos(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (OS.IsWinCE && (n8 & 1) == 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(n2, rECT);
            if (n7 == rECT.bottom - rECT.top && n6 == rECT.right - rECT.left) {
                n8 &= 0xFFFFFFDF;
                n8 |= 1;
            }
        }
        return OS.DeferWindowPos(n, n2, n3, n4, n5, n6, n7, n8);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    boolean dragDetect(int n, int n2, int n3, boolean bl, boolean[] blArray, boolean[] blArray2) {
        if (blArray2 != null) {
            blArray2[0] = false;
        }
        if (blArray != null) {
            blArray[0] = true;
        }
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        OS.ClientToScreen(n, pOINT);
        return OS.DragDetect(n, pOINT);
    }

    void error(int n) {
        SWT.error(n);
    }

    boolean filters(int n) {
        return this.display.filters(n);
    }

    Widget findItem(int n) {
        return null;
    }

    char[] fixMnemonic(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            if (cArray[n] == '&') {
                if (n + 1 < cArray.length && cArray[n + 1] == '&') {
                    cArray[n2++] = 32;
                    ++n;
                }
                ++n;
                continue;
            }
            cArray[n2++] = cArray[n++];
        }
        while (n2 < cArray.length) {
            cArray[n2++] = '\u0000';
        }
        return cArray;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            int n = 1;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) {
                    return objectArray[n + 1];
                }
                n += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    Menu getMenu() {
        return null;
    }

    String getName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int n) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n) {
        this.checkWidget();
        return this.hooks(n);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void mapEvent(int n, Event event) {
    }

    GC new_GC(GCData gCData) {
        return null;
    }

    public void notifyListeners(int n, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n, event);
    }

    void postEvent(int n) {
        this.sendEvent(n, null, false);
    }

    void postEvent(int n, Event event) {
        this.sendEvent(n, event, false);
    }

    void release(boolean bl) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (bl) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, listener);
    }

    protected void removeListener(int n, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    boolean sendDragEvent(int n, int n2, int n3) {
        Event event = new Event();
        event.button = n;
        event.x = n2;
        event.y = n3;
        this.setInputState(event, 29);
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendDragEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        event.button = n;
        event.x = n3;
        event.y = n4;
        event.stateMask = n2;
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n) {
        this.sendEvent(n, null, true);
    }

    void sendEvent(int n, Event event) {
        this.sendEvent(n, event, true);
    }

    void sendEvent(int n, Event event, boolean bl) {
        if (this.eventTable == null && !this.display.filters(n)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4) {
        Event event = new Event();
        if (!this.setKeyState(event, n, n3, n4)) {
            return true;
        }
        return this.sendKeyEvent(n, n2, n3, n4, event);
    }

    boolean sendKeyEvent(int n, int n2, int n3, int n4, Event event) {
        this.sendEvent(n, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        return this.sendMouseEvent(n, n2, this.display.getClickCount(n, n2, n3, n6), 0, false, n3, n4, n5, n6);
    }

    boolean sendMouseEvent(int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7, int n8) {
        if (!this.hooks(n) && !this.filters(n)) {
            return true;
        }
        Event event = new Event();
        event.button = n2;
        event.detail = n4;
        event.count = n3;
        event.x = (short)(n8 & 0xFFFF);
        event.y = (short)(n8 >> 16);
        this.setInputState(event, n);
        this.mapEvent(n5, event);
        if (bl) {
            this.sendEvent(n, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n, event);
        }
        return event.doit;
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n = 1;
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            while (n < objectArray.length) {
                if (string.equals(objectArray[n])) break;
                n += 2;
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n] = string;
            objectArray[n + 1] = object;
        } else if ((this.state & 4) != 0 && n != objectArray.length) {
            int n2 = objectArray.length - 2;
            if (n2 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n2];
                System.arraycopy(objectArray, 0, objectArray3, 0, n);
                System.arraycopy(objectArray, n + 2, objectArray3, n, n2 - n);
                this.data = objectArray3;
            }
        }
    }

    boolean sendFocusEvent(int n) {
        this.sendEvent(n);
        return true;
    }

    boolean setInputState(Event event, int n) {
        if (OS.GetKeyState(18) < 0) {
            event.stateMask |= 0x10000;
        }
        if (OS.GetKeyState(16) < 0) {
            event.stateMask |= 0x20000;
        }
        if (OS.GetKeyState(17) < 0) {
            event.stateMask |= 0x40000;
        }
        if (OS.GetKeyState(1) < 0) {
            event.stateMask |= 0x80000;
        }
        if (OS.GetKeyState(4) < 0) {
            event.stateMask |= 0x100000;
        }
        if (OS.GetKeyState(2) < 0) {
            event.stateMask |= 0x200000;
        }
        if (OS.GetKeyState(5) < 0) {
            event.stateMask |= 0x800000;
        }
        if (OS.GetKeyState(6) < 0) {
            event.stateMask |= 0x2000000;
        }
        switch (n) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n, int n2, int n3) {
        switch (this.display.lastAscii) {
            case 127: {
                if (this.display.lastKey != 8) break;
                this.display.lastAscii = 8;
                break;
            }
            case 10: {
                if (this.display.lastKey != 13) break;
                this.display.lastAscii = 13;
            }
        }
        if (this.display.lastKey == 13 && this.display.lastAscii == 13 && (n3 & 0x1000000) != 0) {
            this.display.lastKey = 0x1000050;
        }
        if (this.display.lastVirtual) {
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (this.display.lastKey == 3) {
                this.display.lastAscii = 0;
            }
            event.keyCode = Display.translateKey(this.display.lastKey);
        } else {
            event.keyCode = this.display.lastKey;
        }
        if (this.display.lastAscii != 0 || this.display.lastNull) {
            event.character = Display.mbcsToWcs((char)this.display.lastAscii);
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !this.display.lastNull) {
            return false;
        }
        return this.setInputState(event, n);
    }

    boolean SetWindowPos(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (OS.IsWinCE && (n7 & 1) == 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(n, rECT);
            if (n6 == rECT.bottom - rECT.top && n5 == rECT.right - rECT.left) {
                n7 &= 0xFFFFFFDF;
                n7 |= 1;
            }
        }
        return OS.SetWindowPos(n, n2, n3, n4, n5, n6, n7);
    }

    boolean showMenu(int n, int n2) {
        Event event = new Event();
        event.x = n;
        event.y = n2;
        this.sendEvent(35, event);
        if (!event.doit) {
            return true;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (n != event.x || n2 != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    LRESULT wmCaptureChanged(int n, int n2, int n3) {
        this.display.captureChanged = true;
        return null;
    }

    LRESULT wmChar(int n, int n2, int n3) {
        byte by;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by = (byte)(n2 & 0xFF))) {
            return null;
        }
        this.display.lastAscii = n2;
        boolean bl = this.display.lastNull = n2 == 0;
        if (!this.sendKeyEvent(1, 258, n2, n3)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmContextMenu(int n, int n2, int n3) {
        if (n2 != n) {
            return null;
        }
        if (OS.IsWinCE) {
            return null;
        }
        short s = 0;
        short s2 = 0;
        if (n3 != -1) {
            POINT pOINT = new POINT();
            short s3 = (short)(n3 & 0xFFFF);
            pOINT.x = s3;
            s = s3;
            short s4 = (short)(n3 >> 16);
            pOINT.y = s4;
            s2 = s4;
            OS.ScreenToClient(n, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(n, rECT);
            if (!OS.PtInRect(rECT, pOINT)) {
                return null;
            }
        } else {
            int n4 = OS.GetMessagePos();
            s = (short)(n4 & 0xFFFF);
            s2 = (short)(n4 >> 16);
        }
        return this.showMenu(s, s2) ? LRESULT.ZERO : null;
    }

    LRESULT wmIMEChar(int n, int n2, int n3) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n2;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n2, n3)) {
            return LRESULT.ONE;
        }
        this.sendKeyEvent(2, 646, n2, n3);
        display.lastAscii = 0;
        display.lastKey = 0;
        return LRESULT.ONE;
    }

    LRESULT wmKeyDown(int n, int n2, int n3) {
        byte by;
        switch (n2) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((n3 & 0x40000000) == 0) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by = (byte)(n2 & 0xFF))) {
            return null;
        }
        by = 0;
        if (OS.IsWinCE) {
            switch (n2) {
                case 8: {
                    by = (byte)8;
                    break;
                }
                case 13: {
                    by = (byte)13;
                    break;
                }
                case 46: {
                    by = (byte)127;
                    break;
                }
                case 27: {
                    by = (byte)27;
                    break;
                }
                case 9: {
                    by = (byte)9;
                }
            }
        } else {
            by = (byte)OS.MapVirtualKey(n2, 2);
        }
        if (OS.IsWinNT ? (by & Integer.MIN_VALUE) != 0 : (by & 0x8000) != 0) {
            return null;
        }
        MSG mSG = new MSG();
        int n4 = 10420226;
        if (OS.PeekMessage(mSG, n, 259, 259, n4)) {
            this.display.lastDead = true;
            this.display.lastVirtual = by == 0;
            this.display.lastKey = this.display.lastVirtual ? n2 : (int)by;
            return null;
        }
        if (this.isDisposed()) {
            return LRESULT.ONE;
        }
        boolean bl = this.display.lastVirtual = by == 0 || this.display.numpadKey(n2) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = n2;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                if (this.display.asciiKey(this.display.lastKey) != 0) {
                    return null;
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            int n5;
            this.display.lastKey = OS.CharLower(by);
            if (n2 == 3) {
                this.display.lastVirtual = true;
            }
            if ((n5 = this.display.asciiKey(n2)) != 0) {
                if (n5 == 32) {
                    return null;
                }
                if (n5 != n2) {
                    return null;
                }
                if (n2 == 3) {
                    return null;
                }
            }
            if (OS.GetKeyState(17) >= 0) {
                return null;
            }
            if (OS.GetKeyState(16) < 0) {
                this.display.lastAscii = this.display.shiftedKey(n2);
                if (this.display.lastAscii == 0) {
                    this.display.lastAscii = by;
                }
            } else {
                this.display.lastAscii = OS.CharLower(by);
            }
            if (this.display.lastAscii == 64) {
                return null;
            }
            this.display.lastAscii = this.display.controlKey(this.display.lastAscii);
        }
        if (!this.sendKeyEvent(1, 256, n2, n3)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmKeyUp(int n, int n2, int n3) {
        Display display = this.display;
        if (OS.IsWinCE && 193 <= n2 && n2 <= 198) {
            int n4;
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            Event event = new Event();
            event.detail = n2 - 193 + 1;
            int n5 = n4 = (n3 & 0x40000000) != 0 ? 34 : 33;
            if (this.setInputState(event, n4)) {
                this.sendEvent(n4, event);
            }
            return null;
        }
        if (!this.hooks(2) && !display.filters(2)) {
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            return null;
        }
        int n6 = 0;
        if (OS.IsWinCE) {
            switch (n2) {
                case 8: {
                    n6 = 8;
                    break;
                }
                case 13: {
                    n6 = 13;
                    break;
                }
                case 46: {
                    n6 = 127;
                    break;
                }
                case 27: {
                    n6 = 27;
                    break;
                }
                case 9: {
                    n6 = 9;
                }
            }
        } else {
            n6 = OS.MapVirtualKey(n2, 2);
        }
        if (OS.IsWinNT ? (n6 & Integer.MIN_VALUE) != 0 : (n6 & 0x8000) != 0) {
            return null;
        }
        if (display.lastDead) {
            return null;
        }
        boolean bl = display.lastVirtual = n6 == 0 || display.numpadKey(n2) != 0;
        if (display.lastVirtual) {
            display.lastKey = n2;
        } else {
            if (n2 == 3) {
                display.lastVirtual = true;
            }
            if (display.lastKey == 0) {
                display.lastAscii = 0;
                display.lastDead = false;
                display.lastNull = false;
                return null;
            }
        }
        LRESULT lRESULT = null;
        if (!this.sendKeyEvent(2, 257, n2, n3)) {
            lRESULT = LRESULT.ONE;
        }
        display.lastAscii = 0;
        display.lastKey = 0;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        return lRESULT;
    }

    LRESULT wmKillFocus(int n, int n2, int n3) {
        int n4 = this.callWindowProc(n, 8, n2, n3);
        this.sendFocusEvent(16);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (n4 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n4);
    }

    LRESULT wmLButtonDblClk(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, n, 513, n2, n3);
        lRESULT = this.sendMouseEvent(8, 1, n, 515, n2, n3) ? new LRESULT(this.callWindowProc(n, 515, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmLButtonDown(int n, int n2, int n3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        short s = (short)(n3 & 0xFFFF);
        short s2 = (short)(n3 >> 16);
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        boolean bl = false;
        boolean bl2 = true;
        int n4 = display.getClickCount(3, 1, n, n3);
        if (n4 == 1 && (this.state & 0x8000) != 0 && this.hooks(29) && !OS.IsWinCE) {
            blArray2 = new boolean[1];
            blArray = new boolean[1];
            bl = this.dragDetect(n, s, s2, true, blArray2, blArray);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            bl2 = OS.GetKeyState(1) < 0;
        }
        display.captureChanged = false;
        boolean bl3 = this.sendMouseEvent(3, 1, n4, 0, false, n, 513, n2, n3);
        lRESULT = bl3 && (blArray == null || !blArray[0]) ? new LRESULT(this.callWindowProc(n, 513, n2, n3)) : LRESULT.ZERO;
        if (OS.IsPPC) {
            boolean bl4;
            Menu menu = this.getMenu();
            boolean bl5 = bl4 = menu != null && !menu.isDisposed();
            if (bl4 || this.hooks(35)) {
                SHRGINFO sHRGINFO = new SHRGINFO();
                sHRGINFO.cbSize = SHRGINFO.sizeof;
                sHRGINFO.hwndClient = n;
                sHRGINFO.ptDown_x = s;
                sHRGINFO.ptDown_y = s2;
                sHRGINFO.dwFlags = 1;
                int n5 = OS.SHRecognizeGesture(sHRGINFO);
                if (n5 == 1000) {
                    this.showMenu(s, s2);
                }
            }
        }
        if (bl2 && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        if (bl) {
            this.sendDragEvent(1, s, s2);
        } else if (blArray2 != null && blArray2[0] && OS.GetKeyState(27) >= 0) {
            OS.SendMessage(n, 514, n2, n3);
        }
        return lRESULT;
    }

    LRESULT wmLButtonUp(int n, int n2, int n3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        lRESULT = this.sendMouseEvent(4, 1, n, 514, n2, n3) ? new LRESULT(this.callWindowProc(n, 514, n2, n3)) : LRESULT.ZERO;
        int n4 = 19;
        if (display.xMouse) {
            n4 |= 0x60;
        }
        if ((n2 & 0xFFFF & n4) == 0 && OS.GetCapture() == n) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmMButtonDblClk(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 2, n, 519, n2, n3);
        lRESULT = this.sendMouseEvent(8, 2, n, 521, n2, n3) ? new LRESULT(this.callWindowProc(n, 521, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmMButtonDown(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        lRESULT = this.sendMouseEvent(3, 2, n, 519, n2, n3) ? new LRESULT(this.callWindowProc(n, 519, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmMButtonUp(int n, int n2, int n3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        lRESULT = this.sendMouseEvent(4, 2, n, 520, n2, n3) ? new LRESULT(this.callWindowProc(n, 520, n2, n3)) : LRESULT.ZERO;
        int n4 = 19;
        if (display.xMouse) {
            n4 |= 0x60;
        }
        if ((n2 & 0xFFFF & n4) == 0 && OS.GetCapture() == n) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmMouseHover(int n, int n2, int n3) {
        if (!this.sendMouseEvent(32, 0, n, 673, n2, n3)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseLeave(int n, int n2, int n3) {
        if (!this.hooks(7) && !this.filters(7)) {
            return null;
        }
        int n4 = OS.GetMessagePos();
        POINT pOINT = new POINT();
        pOINT.x = (short)(n4 & 0xFFFF);
        pOINT.y = (short)(n4 >> 16);
        OS.ScreenToClient(n, pOINT);
        n3 = pOINT.x & 0xFFFF | pOINT.y << 16 & 0xFFFF0000;
        if (!this.sendMouseEvent(7, 0, n, 675, n2, n3)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseMove(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        int n4 = OS.GetMessagePos();
        if (n4 != display.lastMouse || display.captureChanged) {
            if (!OS.IsWinCE) {
                boolean bl;
                boolean bl2 = (this.state & 0x2000) != 0;
                boolean bl3 = this.hooks(6) || display.filters(6);
                boolean bl4 = this.hooks(7) || display.filters(7);
                boolean bl5 = bl = this.hooks(32) || display.filters(32);
                if (bl2 || bl3 || bl4 || bl) {
                    TRACKMOUSEEVENT tRACKMOUSEEVENT = new TRACKMOUSEEVENT();
                    tRACKMOUSEEVENT.cbSize = TRACKMOUSEEVENT.sizeof;
                    tRACKMOUSEEVENT.dwFlags = 0x40000000;
                    tRACKMOUSEEVENT.hwndTrack = n;
                    OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    if (tRACKMOUSEEVENT.dwFlags == 0) {
                        tRACKMOUSEEVENT.dwFlags = 3;
                        tRACKMOUSEEVENT.hwndTrack = n;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                        if (bl3) {
                            MSG mSG = new MSG();
                            int n5 = 10420227;
                            while (OS.PeekMessage(mSG, 0, 675, 675, n5)) {
                                OS.TranslateMessage(mSG);
                                OS.DispatchMessage(mSG);
                            }
                            this.sendMouseEvent(6, 0, n, 512, n2, n3);
                        }
                    } else {
                        tRACKMOUSEEVENT.dwFlags = 1;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    }
                }
            }
            if (n4 != display.lastMouse) {
                display.lastMouse = n4;
                if (!this.sendMouseEvent(5, 0, n, 512, n2, n3)) {
                    lRESULT = LRESULT.ZERO;
                }
            }
        }
        display.captureChanged = false;
        return lRESULT;
    }

    LRESULT wmMouseWheel(int n, int n2, int n3) {
        int n4;
        int n5;
        if (!this.hooks(37) && !this.filters(37)) {
            return null;
        }
        int n6 = n2 >> 16;
        int[] nArray = new int[1];
        OS.SystemParametersInfo(104, 0, nArray, 0);
        if (nArray[0] == -1) {
            n5 = 2;
            n4 = n6 / 120;
        } else {
            n5 = 1;
            n4 = nArray[0] * n6 / 120;
        }
        POINT pOINT = new POINT();
        pOINT.x = (short)(n3 & 0xFFFF);
        pOINT.y = (short)(n3 >> 16);
        OS.ScreenToClient(n, pOINT);
        n3 = pOINT.x & 0xFFFF | pOINT.y << 16 & 0xFFFF0000;
        if (!this.sendMouseEvent(37, 0, n4, n5, true, n, 522, n2, n3)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmPaint(int n, int n2, int n3) {
        if (!this.hooks(9) && !this.filters(9)) {
            return null;
        }
        int n4 = 0;
        if (OS.IsWinCE) {
            RECT rECT = new RECT();
            OS.GetUpdateRect(n, rECT, false);
            n4 = this.callWindowProc(n, 15, n2, n3);
            OS.HideCaret(n);
            OS.InvalidateRect(n, rECT, false);
            OS.ShowCaret(n);
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            GCData gCData = new GCData();
            gCData.ps = pAINTSTRUCT;
            gCData.hwnd = n;
            GC gC = this.new_GC(gCData);
            if (gC != null) {
                int n5 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n6 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n5 != 0 && n6 != 0) {
                    Event event = new Event();
                    event.gc = gC;
                    event.x = pAINTSTRUCT.left;
                    event.y = pAINTSTRUCT.top;
                    event.width = n5;
                    event.height = n6;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
                gC.dispose();
            }
        } else {
            int n7 = OS.CreateRectRgn(0, 0, 0, 0);
            OS.GetUpdateRgn(n, n7, false);
            n4 = this.callWindowProc(n, 15, n2, n3);
            GCData gCData = new GCData();
            gCData.hwnd = n;
            GC gC = this.new_GC(gCData);
            if (gC != null) {
                OS.HideCaret(n);
                RECT rECT = new RECT();
                OS.GetRgnBox(n7, rECT);
                int n8 = rECT.right - rECT.left;
                int n9 = rECT.bottom - rECT.top;
                if (n8 != 0 && n9 != 0) {
                    int n10 = gC.handle;
                    OS.SelectClipRgn(n10, n7);
                    OS.SetMetaRgn(n10);
                    Event event = new Event();
                    event.gc = gC;
                    event.x = rECT.left;
                    event.y = rECT.top;
                    event.width = n8;
                    event.height = n9;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
                gC.dispose();
                OS.ShowCaret(n);
            }
            OS.DeleteObject(n7);
        }
        if (n4 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n4);
    }

    LRESULT wmPrint(int n, int n2, int n3) {
        int n4;
        if ((n3 & 2) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && ((n4 = OS.GetWindowLong(n, -20)) & 0x200) != 0) {
            int n5 = this.callWindowProc(n, 791, n2, n3);
            RECT rECT = new RECT();
            OS.GetWindowRect(n, rECT);
            rECT.right -= rECT.left;
            rECT.bottom -= rECT.top;
            rECT.top = 0;
            rECT.left = 0;
            int n6 = OS.GetSystemMetrics(45);
            OS.ExcludeClipRect(n2, n6, n6, rECT.right - n6, rECT.bottom - n6);
            OS.DrawThemeBackground(this.display.hEditTheme(), n2, 1, 1, rECT, null);
            return new LRESULT(n5);
        }
        return null;
    }

    LRESULT wmRButtonDblClk(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, n, 516, n2, n3);
        lRESULT = this.sendMouseEvent(8, 3, n, 518, n2, n3) ? new LRESULT(this.callWindowProc(n, 518, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmRButtonDown(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        lRESULT = this.sendMouseEvent(3, 3, n, 516, n2, n3) ? new LRESULT(this.callWindowProc(n, 516, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmRButtonUp(int n, int n2, int n3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        if (this.sendMouseEvent(4, 3, n, 517, n2, n3)) {
            lRESULT = new LRESULT(this.callWindowProc(n, 517, n2, n3));
        } else {
            OS.DefWindowProc(n, 517, n2, n3);
            lRESULT = LRESULT.ZERO;
        }
        int n4 = 19;
        if (display.xMouse) {
            n4 |= 0x60;
        }
        if ((n2 & 0xFFFF & n4) == 0 && OS.GetCapture() == n) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmSetFocus(int n, int n2, int n3) {
        int n4 = this.callWindowProc(n, 7, n2, n3);
        this.sendFocusEvent(15);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (n4 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n4);
    }

    LRESULT wmSysChar(int n, int n2, int n3) {
        Display display = this.display;
        display.lastAscii = n2;
        boolean bl = display.lastNull = n2 == 0;
        if (!this.hooks(1) && !display.filters(1)) {
            return null;
        }
        boolean bl2 = display.mnemonicKeyHit;
        display.mnemonicKeyHit = true;
        int n4 = this.callWindowProc(n, 262, n2, n3);
        boolean bl3 = false;
        if (!display.mnemonicKeyHit) {
            bl3 = !this.sendKeyEvent(1, 262, n2, n3);
        }
        display.mnemonicKeyHit = bl2;
        return (bl3 |= display.mnemonicKeyHit) ? LRESULT.ONE : new LRESULT(n4);
    }

    LRESULT wmSysKeyDown(int n, int n2, int n3) {
        int n4;
        if (n2 != 121 && (n3 & 0x20000000) == 0) {
            return null;
        }
        switch (n2) {
            case 115: {
                n4 = n;
                while (OS.GetParent(n4) != 0) {
                    if (OS.GetWindow(n4, 4) != 0) break;
                    n4 = OS.GetParent(n4);
                }
                int n5 = OS.GetWindowLong(n4, -16);
                if ((n5 & 0x80000) == 0) break;
                return null;
            }
        }
        switch (n2) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((n3 & 0x40000000) == 0) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        n4 = 0;
        if (OS.IsWinCE) {
            switch (n2) {
                case 8: {
                    n4 = 8;
                    break;
                }
                case 13: {
                    n4 = 13;
                    break;
                }
                case 46: {
                    n4 = 127;
                    break;
                }
                case 27: {
                    n4 = 27;
                    break;
                }
                case 9: {
                    n4 = 9;
                }
            }
        } else {
            n4 = OS.MapVirtualKey(n2, 2);
        }
        boolean bl = this.display.lastVirtual = n4 == 0 || this.display.numpadKey(n2) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = n2;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                switch (this.display.lastKey) {
                    case 106: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: {
                        return null;
                    }
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            this.display.lastKey = OS.CharLower((short)n4);
            if (OS.IsWinNT) {
                return null;
            }
            if (n2 != 13) {
                return null;
            }
            this.display.lastAscii = 13;
        }
        if (!this.sendKeyEvent(1, 260, n2, n3)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmSysKeyUp(int n, int n2, int n3) {
        return this.wmKeyUp(n, n2, n3);
    }

    LRESULT wmXButtonDblClk(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        int n4 = n2 >> 16 == 1 ? 4 : 5;
        this.sendMouseEvent(3, n4, n, 523, n2, n3);
        lRESULT = this.sendMouseEvent(8, n4, n, 525, n2, n3) ? new LRESULT(this.callWindowProc(n, 525, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmXButtonDown(int n, int n2, int n3) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        display.xMouse = true;
        int n4 = n2 >> 16 == 1 ? 4 : 5;
        lRESULT = this.sendMouseEvent(3, n4, n, 523, n2, n3) ? new LRESULT(this.callWindowProc(n, 523, n2, n3)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n) {
            OS.SetCapture(n);
        }
        return lRESULT;
    }

    LRESULT wmXButtonUp(int n, int n2, int n3) {
        Display display = this.display;
        LRESULT lRESULT = null;
        int n4 = n2 >> 16 == 1 ? 4 : 5;
        lRESULT = this.sendMouseEvent(4, n4, n, 524, n2, n3) ? new LRESULT(this.callWindowProc(n, 524, n2, n3)) : LRESULT.ZERO;
        int n5 = 19;
        if (display.xMouse) {
            n5 |= 0x60;
        }
        if ((n2 & 0xFFFF & n5) == 0 && OS.GetCapture() == n) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }
}

