/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;

public class RepositoryUtilities {
    private RepositoryUtilities() {
    }

    public static ContentEntity getEntity(Repository repository, String[] name) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (name == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int length = name.length;
        if (length == 0) {
            return repository.getRoot();
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < length - 1; ++i) {
            String nameItem = name[i];
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                throw new ContentIOException("No such item: " + nameItem + " in " + node.getContentId());
            }
            node = (ContentLocation)entry;
        }
        return node.getEntry(name[length - 1]);
    }

    public static boolean isExistsEntity(Repository repository, String[] name) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (name == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int length = name.length;
        if (length == 0) {
            return true;
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < length - 1; ++i) {
            String nameItem = name[i];
            if (!node.exists(nameItem)) {
                return false;
            }
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                return false;
            }
            node = (ContentLocation)entry;
        }
        return node.exists(name[length - 1]);
    }

    public static ContentItem createItem(Repository repository, String[] name) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (name == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int length = name.length;
        if (length == 0) {
            throw new IllegalArgumentException("Empty name not permitted.");
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < length - 1; ++i) {
            String nameItem = name[i];
            if (!node.exists(nameItem)) {
                node = node.createLocation(nameItem);
                continue;
            }
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            node = (ContentLocation)entry;
        }
        return node.createItem(name[length - 1]);
    }

    public static ContentLocation createLocation(Repository repository, String[] name) throws ContentIOException {
        if (repository == null) {
            throw new NullPointerException("Repository given must not be null.");
        }
        if (name == null) {
            throw new NullPointerException("Path-Name array must not be null.");
        }
        int length = name.length;
        if (length == 0) {
            throw new IllegalArgumentException("Empty name not permitted.");
        }
        ContentLocation node = repository.getRoot();
        for (int i = 0; i < length - 1; ++i) {
            String nameItem = name[i];
            if (!node.exists(nameItem)) {
                node = node.createLocation(nameItem);
                continue;
            }
            ContentEntity entry = node.getEntry(nameItem);
            if (!(entry instanceof ContentLocation)) {
                throw new ContentIOException("No such item.");
            }
            node = (ContentLocation)entry;
        }
        return node.createLocation(name[length - 1]);
    }

    public static String[] splitPath(String name, String separator) {
        if (name == null) {
            throw new NullPointerException("Path-Name must not be null.");
        }
        if (separator == null) {
            throw new NullPointerException("Separator must not be null.");
        }
        StringTokenizer strtok = new StringTokenizer(name, separator, false);
        int tokenCount = strtok.countTokens();
        String[] retval = new String[tokenCount];
        int i = 0;
        boolean emptyTokenRemoved = false;
        while (strtok.hasMoreTokens()) {
            String token;
            retval[i] = token = strtok.nextToken();
            if (!"".equals(token)) {
                ++i;
                continue;
            }
            emptyTokenRemoved = true;
        }
        if (!emptyTokenRemoved) {
            return retval;
        }
        String[] reducedArray = new String[i];
        System.arraycopy(retval, 0, reducedArray, 0, i);
        return reducedArray;
    }

    public static String[] split(String name, String separator) {
        if (name == null) {
            throw new NullPointerException("Path-Name must not be null.");
        }
        if (separator == null) {
            throw new NullPointerException("Separator must not be null.");
        }
        StringTokenizer strtok = new StringTokenizer(name, separator, false);
        int tokenCount = strtok.countTokens();
        String[] retval = new String[tokenCount];
        int i = 0;
        while (strtok.hasMoreTokens()) {
            String token;
            retval[i] = token = strtok.nextToken();
            ++i;
        }
        return retval;
    }

    public static String[] buildNameArray(ContentEntity entity) {
        if (entity == null) {
            throw new NullPointerException("Entity given must not be null.");
        }
        ArrayList<String> collector = new ArrayList<String>(20);
        while (entity != null) {
            ContentLocation parent = entity.getParent();
            if (parent != null) {
                collector.add(0, entity.getName());
            }
            entity = parent;
        }
        return collector.toArray(new String[collector.size()]);
    }

    public static String buildName(ContentEntity entity, String separator) {
        int maxIdx;
        if (entity == null) {
            throw new NullPointerException("ContentEntity must not be null.");
        }
        if (separator == null) {
            throw new NullPointerException("Separator must not be null.");
        }
        int size = 0;
        ArrayList<String> collector = new ArrayList<String>();
        while (entity != null) {
            ContentLocation parent = entity.getParent();
            if (parent != null) {
                String name = entity.getName();
                if (name.length() == 0) {
                    throw new IllegalStateException("ContentLocation with an empty name");
                }
                if (RepositoryUtilities.isInvalidPathName(name)) {
                    throw new IllegalStateException("ContentLocation with an illegal name: " + name);
                }
                collector.add(name);
                ++size;
                size += name.length();
            }
            entity = parent;
        }
        StringBuilder builder = new StringBuilder(size);
        for (int i = maxIdx = collector.size() - 1; i >= 0; --i) {
            String s = (String)collector.get(i);
            if (i != maxIdx) {
                builder.append(separator);
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public static boolean isInvalidPathName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        boolean onlyDots = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (onlyDots && c != '.') {
                onlyDots = false;
            }
            if (c != '\\' && c != '/') continue;
            return true;
        }
        return onlyDots;
    }

    public static void writeAsZip(OutputStream outputStream, Repository repository) throws IOException, ContentIOException {
        ZipOutputStream zipout = new ZipOutputStream(outputStream);
        RepositoryUtilities.writeToZipStream(zipout, repository);
        zipout.finish();
        zipout.flush();
    }

    public static void writeToZipStream(ZipOutputStream zipOutputStream, Repository repository) throws IOException, ContentIOException {
        RepositoryUtilities.writeLocation(repository.getRoot(), zipOutputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeLocation(ContentLocation location, ZipOutputStream outputStream) throws IOException, ContentIOException {
        ContentEntity[] contentEntities = location.listContents();
        for (int i = 0; i < contentEntities.length; ++i) {
            Date date;
            Object version;
            Object comment;
            ContentEntity entity = contentEntities[i];
            String fullName = RepositoryUtilities.buildName(entity, "/");
            if (entity instanceof ContentLocation) {
                ContentLocation childlocation = (ContentLocation)entity;
                ZipEntry dirEntry = new ZipEntry(fullName + '/');
                comment = entity.getAttribute("org.jfree.repository.zip", "comment");
                if (comment != null) {
                    dirEntry.setComment(String.valueOf(comment));
                }
                if ((version = entity.getAttribute("org.jfree.repository", "version")) instanceof Date) {
                    date = (Date)version;
                    dirEntry.setTime(date.getTime());
                }
                outputStream.putNextEntry(dirEntry);
                RepositoryUtilities.writeLocation(childlocation, outputStream);
                continue;
            }
            if (!(entity instanceof ContentItem)) continue;
            ContentItem item = (ContentItem)entity;
            ZipEntry itemEntry = new ZipEntry(fullName);
            comment = entity.getAttribute("org.jfree.repository.zip", "comment");
            if (comment != null) {
                itemEntry.setComment(String.valueOf(comment));
            }
            if ((version = entity.getAttribute("org.jfree.repository", "version")) instanceof Date) {
                date = (Date)version;
                itemEntry.setTime(date.getTime());
            }
            Object crc32 = entity.getAttribute("org.jfree.repository.zip", "crc32");
            Object size = entity.getAttribute("org.jfree.repository", "size");
            if (crc32 instanceof Long && size instanceof Long) {
                Long crc32Long = (Long)crc32;
                Long sizeLong = (Long)size;
                itemEntry.setSize(sizeLong);
                itemEntry.setCrc(crc32Long);
                int method = RepositoryUtilities.getZipMethod(item);
                int compression = RepositoryUtilities.getZipLevel(item);
                outputStream.setMethod(method);
                outputStream.setLevel(compression);
            }
            outputStream.putNextEntry(itemEntry);
            InputStream inputStream = item.getInputStream();
            try {
                IOUtils.getInstance().copyStreams(inputStream, (OutputStream)outputStream);
            }
            finally {
                inputStream.close();
            }
            outputStream.closeEntry();
        }
    }

    public static int getZipLevel(ContentItem item) {
        Object method = item.getAttribute("org.jfree.repository.zip", "compression");
        if (!(method instanceof Number)) {
            return -1;
        }
        Number n = (Number)method;
        int level = n.intValue();
        if (level < 0 || level > 9) {
            return -1;
        }
        return level;
    }

    public static int getZipMethod(ContentItem item) {
        Object method = item.getAttribute("org.jfree.repository.zip", "method");
        if (!(method instanceof Number)) {
            return 8;
        }
        Number n = (Number)method;
        int level = n.intValue();
        if (level != 0) {
            return 8;
        }
        return 0;
    }
}

