/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.repository.file;

import java.io.File;
import java.io.IOException;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentCreationException;
import org.pentaho.reporting.libraries.repository.ContentEntity;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentItem;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.Repository;
import org.pentaho.reporting.libraries.repository.RepositoryUtilities;
import org.pentaho.reporting.libraries.repository.file.FileContentEntity;
import org.pentaho.reporting.libraries.repository.file.FileContentItem;

public class FileContentLocation
extends FileContentEntity
implements ContentLocation {
    private static final long serialVersionUID = -5452372293937107734L;

    public FileContentLocation(ContentLocation parent, File backend) throws ContentIOException {
        super(parent, backend);
        if (!backend.exists() || !backend.isDirectory()) {
            throw new ContentIOException("The given backend-file is not a directory.");
        }
    }

    public FileContentLocation(Repository repository, File backend) throws ContentIOException {
        super(repository, backend);
        if (!backend.exists() || !backend.isDirectory()) {
            throw new ContentIOException("The given backend-file is not a directory.");
        }
    }

    public ContentEntity[] listContents() throws ContentIOException {
        File file = this.getBackend();
        File[] files = file.listFiles();
        ContentEntity[] entities = new ContentEntity[files.length];
        for (int i = 0; i < files.length; ++i) {
            File child = files[i];
            if (RepositoryUtilities.isInvalidPathName(child.getName())) continue;
            if (child.isDirectory()) {
                entities[i] = new FileContentLocation(this, child);
                continue;
            }
            if (!child.isFile()) continue;
            entities[i] = new FileContentLocation(this, child);
        }
        return entities;
    }

    public ContentEntity getEntry(String name) throws ContentIOException {
        if (RepositoryUtilities.isInvalidPathName(name)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        File file = this.getBackend();
        File child = new File(file, name);
        if (!child.exists()) {
            throw new ContentIOException("Not found:" + child);
        }
        try {
            if (!IOUtils.getInstance().isSubDirectory(file, child)) {
                throw new ContentIOException("The given entry does not point to a sub-directory of this content-location");
            }
        }
        catch (IOException e) {
            throw new ContentIOException("IO Error.", e);
        }
        if (child.isDirectory()) {
            return new FileContentLocation(this, child);
        }
        if (child.isFile()) {
            return new FileContentItem(this, child);
        }
        throw new ContentIOException("Not File nor directory.");
    }

    public ContentItem createItem(String name) throws ContentCreationException {
        if (RepositoryUtilities.isInvalidPathName(name)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        File file = this.getBackend();
        File child = new File(file, name);
        if (child.exists()) {
            if (child.length() == 0L) {
                return new FileContentItem(this, child);
            }
            throw new ContentCreationException("File already exists: " + child);
        }
        try {
            if (!child.createNewFile()) {
                throw new ContentCreationException("Unable to create the file.");
            }
            return new FileContentItem(this, child);
        }
        catch (IOException e) {
            throw new ContentCreationException("IOError while create", e);
        }
    }

    public ContentLocation createLocation(String name) throws ContentCreationException {
        if (RepositoryUtilities.isInvalidPathName(name)) {
            throw new IllegalArgumentException("The name given is not valid.");
        }
        File file = this.getBackend();
        File child = new File(file, name);
        if (child.exists()) {
            throw new ContentCreationException("File already exists.");
        }
        if (!child.mkdir()) {
            throw new ContentCreationException("Unable to create the directory");
        }
        try {
            return new FileContentLocation(this, child);
        }
        catch (ContentIOException e) {
            throw new ContentCreationException("Failed to create the content-location", (Exception)((Object)e));
        }
    }

    public boolean exists(String name) {
        if (RepositoryUtilities.isInvalidPathName(name)) {
            return false;
        }
        File file = this.getBackend();
        File child = new File(file, name);
        return child.exists();
    }
}

