/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.encodings.Encoding;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.BlobParameterBuffer;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.IscBlobHandle;
import org.firebirdsql.gds.IscDbHandle;
import org.firebirdsql.gds.IscStmtHandle;
import org.firebirdsql.gds.IscTrHandle;
import org.firebirdsql.gds.XSQLDA;
import org.firebirdsql.gds.impl.AbstractIscDbHandle;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.AbstractIscTrHandle;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;

public class GDSHelper {
    public static final int DEFAULT_BLOB_BUFFER_SIZE = 16384;
    private static final Logger log = LoggerFactory.getLogger(GDSHelper.class, false);
    private GDS gds;
    private AbstractIscDbHandle currentDbHandle;
    private AbstractIscTrHandle currentTr;
    protected DatabaseParameterBuffer dpb;
    private boolean registerResultSets;
    private GDSHelperErrorListener listener;

    public GDSHelper(GDS gds, DatabaseParameterBuffer dpb, AbstractIscDbHandle dbHandle, GDSHelperErrorListener listener) {
        this.gds = gds;
        this.dpb = dpb;
        this.currentDbHandle = dbHandle;
        this.registerResultSets = !this.getDatabaseParameterBuffer().hasArgument(137);
        this.listener = listener;
    }

    private void notifyListeners(GDSException ex) {
        if (this.listener != null) {
            this.listener.errorOccured(ex);
        }
    }

    public AbstractIscTrHandle getCurrentTrHandle() {
        return this.currentTr;
    }

    public void setCurrentTrHandle(AbstractIscTrHandle currentTr) {
        this.currentTr = currentTr;
    }

    public IscDbHandle getCurrentDbHandle() {
        return this.currentDbHandle;
    }

    public DatabaseParameterBuffer getDatabaseParameterBuffer() {
        return this.dpb;
    }

    public AbstractIscStmtHandle allocateStatement() throws GDSException {
        try {
            AbstractIscStmtHandle stmt = (AbstractIscStmtHandle)this.gds.createIscStmtHandle();
            this.gds.iscDsqlAllocateStatement(this.getCurrentDbHandle(), stmt);
            return stmt;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.currentTr != null;
    }

    public int getTransactionId(IscTrHandle trHandle) throws GDSException {
        try {
            byte[] trInfo = this.gds.iscTransactionInformation(trHandle, new byte[]{4}, 32);
            if (trInfo.length < 3 || trInfo[0] != 4) {
                throw new GDSException("Unexpected response buffer");
            }
            int length = this.gds.iscVaxInteger(trInfo, 1, 2);
            return this.gds.iscVaxInteger(trInfo, 3, length);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void prepareStatement(AbstractIscStmtHandle stmt, String sql, boolean describeBind) throws GDSException, SQLException {
        try {
            if (log != null) {
                log.trace("preparing sql: " + sql);
            }
            String localEncoding = this.dpb.getArgumentAsString(135);
            String mappingPath = this.dpb.getArgumentAsString(136);
            Encoding encoding = EncodingFactory.getEncoding(localEncoding, mappingPath);
            int dialect = 3;
            if (this.dpb.hasArgument(63)) {
                dialect = this.dpb.getArgumentAsInt(63);
            }
            XSQLDA out = this.gds.iscDsqlPrepare((IscTrHandle)this.currentTr, (IscStmtHandle)stmt, encoding.encodeToCharset(sql), dialect);
            if (out.sqld != out.sqln) {
                throw new GDSException("Not all columns returned");
            }
            if (describeBind) {
                this.gds.iscDsqlDescribeBind(stmt, 1);
            }
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void executeStatement(AbstractIscStmtHandle stmt, boolean sendOutSqlda) throws GDSException {
        try {
            this.gds.iscDsqlExecute2(this.currentTr, stmt, 1, stmt.getInSqlda(), sendOutSqlda ? stmt.getOutSqlda() : null);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void executeImmediate(String statement) throws GDSException {
        try {
            this.gds.iscDsqlExecImmed2(this.getIscDBHandle(), (IscTrHandle)this.currentTr, statement, 3, null, null);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void fetch(AbstractIscStmtHandle stmt, int fetchSize) throws GDSException {
        try {
            this.gds.iscDsqlFetch(stmt, 1, stmt.getOutSqlda(), fetchSize);
            if (this.registerResultSets) {
                this.currentTr.registerStatementWithTransaction(stmt);
            }
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void setCursorName(AbstractIscStmtHandle stmt, String cursorName) throws GDSException {
        try {
            this.gds.iscDsqlSetCursorName(stmt, cursorName, 0);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void closeStatement(AbstractIscStmtHandle stmt, boolean deallocate) throws GDSException {
        try {
            if (!deallocate && !stmt.hasOpenResultSet()) {
                return;
            }
            try {
                this.gds.iscDsqlFreeStatement(stmt, deallocate ? 2 : 1);
            }
            catch (GDSException ex) {
                if (deallocate) {
                    throw ex;
                }
                boolean recloseClosedCursorError = false;
                GDSException tempEx = ex;
                do {
                    if (tempEx.getIntParam() != 0x14000101) continue;
                    recloseClosedCursorError = true;
                    break;
                } while ((tempEx = tempEx.getNext()) != null);
                if (!recloseClosedCursorError) {
                    throw ex;
                }
            }
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public IscBlobHandle openBlob(long blob_id, boolean segmented) throws GDSException {
        try {
            IscBlobHandle blob = this.gds.createIscBlobHandle();
            blob.setBlobId(blob_id);
            BlobParameterBuffer blobParameterBuffer = this.gds.createBlobParameterBuffer();
            blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
            this.gds.iscOpenBlob2(this.currentDbHandle, this.currentTr, blob, blobParameterBuffer);
            return blob;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public IscBlobHandle createBlob(boolean segmented) throws GDSException {
        try {
            IscBlobHandle blob = this.gds.createIscBlobHandle();
            BlobParameterBuffer blobParameterBuffer = this.gds.createBlobParameterBuffer();
            blobParameterBuffer.addArgument(3, segmented ? 0 : 1);
            this.gds.iscCreateBlob2(this.currentDbHandle, this.currentTr, blob, blobParameterBuffer);
            return blob;
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public byte[] getBlobSegment(IscBlobHandle blob, int len) throws GDSException {
        try {
            return this.gds.iscGetSegment(blob, len);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void closeBlob(IscBlobHandle blob) throws GDSException {
        try {
            this.gds.iscCloseBlob(blob);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void putBlobSegment(IscBlobHandle blob, byte[] buf) throws GDSException {
        try {
            this.gds.iscPutSegment(blob, buf);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public void getSqlCounts(AbstractIscStmtHandle stmt) throws GDSException {
        try {
            this.gds.getSqlCounts(stmt);
        }
        catch (GDSException ex) {
            this.notifyListeners(ex);
            throw ex;
        }
    }

    public String getDatabaseProductName() {
        return this.currentDbHandle.getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return this.currentDbHandle.getDatabaseProductVersion();
    }

    public int getDatabaseProductMajorVersion() {
        return this.currentDbHandle.getDatabaseProductMajorVersion();
    }

    public int getDatabaseProductMinorVersion() {
        return this.currentDbHandle.getDatabaseProductMinorVersion();
    }

    public String getUserName() {
        return this.dpb.getArgumentAsString(28);
    }

    public int getBlobBufferLength() {
        if (this.dpb.hasArgument(130)) {
            return this.dpb.getArgumentAsInt(130);
        }
        return 16384;
    }

    public String getIscEncoding() {
        try {
            String result = this.dpb.getArgumentAsString(48);
            if (result == null) {
                result = "NONE";
            }
            return result;
        }
        catch (NullPointerException ex) {
            return "NONE";
        }
    }

    public String getJavaEncoding() {
        return this.dpb.getArgumentAsString(135);
    }

    public String getMappingPath() {
        return this.dpb.getArgumentAsString(136);
    }

    public List getWarnings() {
        if (this.currentDbHandle == null) {
            return Collections.EMPTY_LIST;
        }
        return this.currentDbHandle.getWarnings();
    }

    public void clearWarnings() {
        if (this.currentDbHandle != null) {
            this.currentDbHandle.clearWarnings();
        }
    }

    public IscDbHandle getIscDBHandle() {
        return this.currentDbHandle;
    }

    public GDS getInternalAPIHandler() {
        return this.gds;
    }

    public static interface GDSHelperErrorListener {
        public void errorOccured(GDSException var1);
    }
}

