/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.firebirdsql.gds.DatabaseParameterBuffer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.AbstractIscStmtHandle;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBEscapedParser;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.FirebirdStatement;
import org.firebirdsql.jdbc.Synchronizable;

public abstract class AbstractStatement
implements FirebirdStatement,
Synchronizable {
    protected GDSHelper gdsHelper;
    protected FBObjectListener.StatementListener statementListener;
    protected AbstractIscStmtHandle fixedStmt;
    private FBResultSet currentRs;
    private boolean closed;
    protected boolean completed = true;
    private boolean escapedProcessing = true;
    protected SQLWarning firstWarning = null;
    protected boolean isResultSet;
    protected boolean hasMoreResults;
    protected int maxRows = 0;
    protected int fetchSize = 0;
    private int maxFieldSize = 0;
    private int queryTimeout = 0;
    private String cursorName;
    private int rsConcurrency;
    private int rsType;
    private int rsHoldability = 2;
    private FBObjectListener.ResultSetListener resultSetListener = new RSListener();
    private int statementType;
    private String executionPlan;
    private AbstractConnection connection;
    private static final int INSERTED_ROWS_COUNT = 1;
    private static final int UPDATED_ROWS_COUNT = 2;
    private static final int DELETED_ROWS_COUNT = 3;
    private LinkedList batchList = new LinkedList();

    protected AbstractStatement(GDSHelper c, int rsType, int rsConcurrency, int rsHoldability, FBObjectListener.StatementListener statementListener) throws SQLException {
        this.gdsHelper = c;
        this.rsConcurrency = rsConcurrency;
        this.rsType = rsType;
        this.rsHoldability = rsHoldability;
        this.statementListener = statementListener;
        this.connection = statementListener != null ? statementListener.getConnection() : null;
        this.closed = false;
    }

    String getCursorName() {
        return this.cursorName;
    }

    public boolean isValid() {
        return !this.closed && (this.fixedStmt == null || this.fixedStmt.isValid());
    }

    public Object getSynchronizationObject() throws SQLException {
        if (this.connection == null) {
            return this;
        }
        if (this.connection.getAutoCommit()) {
            return this.connection;
        }
        return this;
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            this.close(true);
        }
    }

    public void completeStatement() throws SQLException {
        this.closeResultSet(false);
        if (!this.completed) {
            this.notifyStatementCompleted();
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                if (!this.internalExecute(sql)) {
                    throw new FBSQLException("Query did not return a result set.", "07005");
                }
                return this.getResultSet();
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
        }
    }

    protected void notifyStatementStarted() throws SQLException {
        this.notifyStatementStarted(true);
    }

    protected void notifyStatementStarted(boolean closeResultSet) throws SQLException {
        if (closeResultSet) {
            this.closeResultSet(false);
        }
        this.statementListener.executionStarted(this);
        this.completed = false;
    }

    protected void notifyStatementCompleted() throws SQLException {
        this.notifyStatementCompleted(true);
    }

    protected void notifyStatementCompleted(boolean success) throws SQLException {
        this.completed = true;
        this.statementListener.statementCompleted(this, success);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String sql) throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            try {
                if (this.internalExecute(sql)) {
                    throw new FBSQLException("Update statement returned results.");
                }
                int n = this.getUpdateCount();
                return n;
            }
            catch (GDSException ge) {
                throw new FBSQLException(ge);
            }
            finally {
                this.notifyStatementCompleted();
            }
        }
    }

    public void close() throws SQLException {
        this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close(boolean ignoreAlreadyClosed) throws SQLException {
        block13: {
            Object syncObject;
            if (this.closed) {
                if (ignoreAlreadyClosed) {
                    return;
                }
                throw new FBSQLException("This statement is already closed.");
            }
            Object object = syncObject = this.getSynchronizationObject();
            synchronized (object) {
                if (this.fixedStmt != null) {
                    try {
                        try {
                            this.closeResultSet(false);
                            Object var5_4 = null;
                            if (!this.fixedStmt.isValid()) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var5_5 = null;
                            if (this.fixedStmt.isValid()) {
                                this.gdsHelper.closeStatement(this.fixedStmt, true);
                            }
                            throw throwable;
                        }
                        this.gdsHelper.closeStatement(this.fixedStmt, true);
                    }
                    catch (GDSException ge) {
                        throw new FBSQLException(ge);
                    }
                    finally {
                        this.fixedStmt = null;
                    }
                }
            }
        }
        this.closed = true;
        this.statementListener.statementClosed(this);
    }

    boolean isClosed() {
        return this.closed;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Can't set max field size negative", "HY009");
        }
        this.maxFieldSize = max;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new FBSQLException("Max rows can't be less than 0", "HY009");
        }
        this.maxRows = max;
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.escapedProcessing = enable;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw new FBSQLException("Can't set query timeout negative", "HY009");
        }
        this.queryTimeout = seconds;
    }

    public void cancel() throws SQLException {
        throw new FBDriverNotCapableException();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.firstWarning;
    }

    public void clearWarnings() throws SQLException {
        this.firstWarning = null;
    }

    public void setCursorName(String name) throws SQLException {
        this.cursorName = name;
    }

    boolean isUpdatableCursor() {
        return this.cursorName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        Object syncObject;
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        Object object = syncObject = this.getSynchronizationObject();
        synchronized (object) {
            this.notifyStatementStarted();
            boolean hasResultSet = false;
            try {
                try {
                    hasResultSet = this.internalExecute(sql);
                }
                catch (GDSException ge) {
                    throw new FBSQLException(ge);
                }
            }
            finally {
                if (!hasResultSet) {
                    this.notifyStatementCompleted();
                }
            }
            return hasResultSet;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(false);
    }

    public ResultSet getResultSet(boolean trimStrings) throws SQLException {
        try {
            if (this.cursorName != null) {
                this.gdsHelper.setCursorName(this.fixedStmt, this.cursorName);
            }
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
        if (this.currentRs != null) {
            throw new FBSQLException("Only one resultset at a time/statement.");
        }
        if (this.fixedStmt == null) {
            throw new FBSQLException("No statement was executed.");
        }
        if (this.isResultSet) {
            this.currentRs = new FBResultSet(this.gdsHelper, this, this.fixedStmt, this.resultSetListener, trimStrings, this.rsType, this.rsConcurrency, this.rsHoldability, false);
            return this.currentRs;
        }
        return null;
    }

    public boolean hasOpenResultSet() {
        return this.currentRs != null;
    }

    public int getUpdateCount() throws SQLException {
        if (this.isResultSet || !this.hasMoreResults) {
            return -1;
        }
        try {
            this.gdsHelper.getSqlCounts(this.fixedStmt);
            int insCount = this.fixedStmt.getInsertCount();
            int updCount = this.fixedStmt.getUpdateCount();
            int delCount = this.fixedStmt.getDeleteCount();
            int resCount = updCount > delCount ? updCount : delCount;
            int n = resCount = resCount > insCount ? resCount : insCount;
            return n;
        }
        catch (GDSException ge) {
            throw new FBSQLException(ge);
        }
        finally {
            this.hasMoreResults = false;
        }
    }

    private int getChangedRowsCount(int type) throws SQLException {
        if (this.isResultSet || !this.hasMoreResults) {
            return -1;
        }
        try {
            this.gdsHelper.getSqlCounts(this.fixedStmt);
            switch (type) {
                case 1: {
                    return this.fixedStmt.getInsertCount();
                }
                case 2: {
                    return this.fixedStmt.getUpdateCount();
                }
                case 3: {
                    return this.fixedStmt.getDeleteCount();
                }
            }
            throw new IllegalArgumentException("Specified type is unknown.");
        }
        catch (GDSException ex) {
            throw new FBSQLException(ex);
        }
    }

    public int getDeletedRowsCount() throws SQLException {
        return this.getChangedRowsCount(3);
    }

    public int getInsertedRowsCount() throws SQLException {
        return this.getChangedRowsCount(1);
    }

    public int getUpdatedRowsCount() throws SQLException {
        return this.getChangedRowsCount(2);
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int mode) throws SQLException {
        boolean closeResultSet;
        this.hasMoreResults = false;
        boolean bl = closeResultSet = mode == 3 || mode == 1;
        if (closeResultSet && this.currentRs != null) {
            try {
                this.currentRs.close();
            }
            finally {
                this.currentRs = null;
            }
        }
        return this.hasMoreResults;
    }

    public void setFetchDirection(int direction) throws SQLException {
        if (direction != 1000) {
            throw new FBDriverNotCapableException();
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public void setFetchSize(int rows) throws SQLException {
        if (rows < 0) {
            throw new FBSQLException("Can't set negative fetch size", "HY009");
        }
        if (this.maxRows > 0 && rows > this.maxRows) {
            throw new FBSQLException("Can't set fetch size > maxRows", "HY009");
        }
        this.fetchSize = rows;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getResultSetConcurrency() throws SQLException {
        return this.rsConcurrency;
    }

    public int getResultSetType() throws SQLException {
        return this.rsType;
    }

    public int getResultSetHoldability() throws SQLException {
        return this.rsHoldability;
    }

    public void addBatch(String sql) throws SQLException {
        this.batchList.add(sql);
    }

    public void clearBatch() throws SQLException {
        this.batchList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public int[] executeBatch() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Statement is closed");
        }
        if (this.statementListener.getConnection().getAutoCommit()) {
            this.addWarning(new SQLWarning("Batch updates should be run with auto-commit disabled.", "1000"));
        }
        Object syncObject = this.getSynchronizationObject();
        this.notifyStatementStarted();
        Object object = syncObject;
        synchronized (object) {
            boolean success = false;
            try {
                int[] nArray;
                LinkedList<Integer> responses = new LinkedList<Integer>();
                try {
                    Iterator iter = this.batchList.iterator();
                    while (iter.hasNext()) {
                        String sql = (String)iter.next();
                        try {
                            boolean hasResultSet = this.internalExecute(sql);
                            if (hasResultSet) {
                                throw new BatchUpdateException(this.toArray(responses));
                            }
                            responses.add(new Integer(this.getUpdateCount()));
                        }
                        catch (GDSException ge) {
                            throw new BatchUpdateException(ge.getMessage(), "HY000", ge.getFbErrorCode(), this.toArray(responses));
                        }
                    }
                    success = true;
                    nArray = this.toArray(responses);
                }
                catch (Throwable throwable) {
                    this.clearBatch();
                    throw throwable;
                }
                this.clearBatch();
                return nArray;
            }
            finally {
                this.notifyStatementCompleted(success);
            }
        }
    }

    protected int[] toArray(Collection list) {
        int[] result = new int[list.size()];
        int counter = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            result[counter++] = (Integer)iter.next();
        }
        return result;
    }

    public Connection getConnection() throws SQLException {
        return this.statementListener.getConnection();
    }

    void closeResultSet(boolean notifyListener) throws SQLException {
        boolean wasCompleted = this.completed;
        if (this.currentRs != null) {
            this.currentRs.close(notifyListener);
            this.currentRs = null;
        }
        if (notifyListener && !wasCompleted) {
            this.statementListener.statementCompleted(this);
        }
    }

    public void forgetResultSet() {
        this.currentRs = null;
        if (this.fixedStmt != null) {
            this.fixedStmt.clearRows();
        }
    }

    public ResultSet getCurrentResultSet() throws SQLException {
        return this.currentRs;
    }

    protected boolean isExecuteProcedureStatement(String sql) throws SQLException {
        String trimmedSql = this.nativeSQL(sql).trim();
        return trimmedSql.startsWith("EXECUTE");
    }

    protected boolean internalExecute(String sql) throws GDSException, SQLException {
        if (this.closed) {
            throw new FBSQLException("Statement is already closed.");
        }
        this.prepareFixedStatement(sql, false);
        this.gdsHelper.executeStatement(this.fixedStmt, this.isExecuteProcedureStatement(sql));
        this.hasMoreResults = true;
        this.isResultSet = this.fixedStmt.getOutSqlda().sqld > 0;
        return this.isResultSet;
    }

    protected void prepareFixedStatement(String sql, boolean describeBind) throws GDSException, SQLException {
        this.executionPlan = null;
        this.statementType = 0;
        if (this.fixedStmt == null) {
            this.fixedStmt = this.gdsHelper.allocateStatement();
        }
        if (!this.fixedStmt.isValid()) {
            throw new FBSQLException("Corresponding connection is not valid.", "08007");
        }
        this.gdsHelper.prepareStatement(this.fixedStmt, this.escapedProcessing ? this.nativeSQL(sql) : sql, describeBind);
    }

    protected void addWarning(SQLWarning warning) {
        if (this.firstWarning == null) {
            this.firstWarning = warning;
        } else {
            SQLWarning lastWarning = this.firstWarning;
            while (lastWarning.getNextWarning() != null) {
                lastWarning = lastWarning.getNextWarning();
            }
            lastWarning.setNextWarning(warning);
        }
    }

    protected String nativeSQL(String sql) throws SQLException {
        DatabaseParameterBuffer dpb = this.gdsHelper.getDatabaseParameterBuffer();
        int mode = 0;
        if (dpb.hasArgument(134)) {
            mode = 1;
        }
        return new FBEscapedParser(mode).parse(sql);
    }

    String getExecutionPlan() throws FBSQLException {
        this.populateStatementInfo();
        return this.executionPlan;
    }

    public String getLastExecutionPlan() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Statement is already closed.");
        }
        if (this.fixedStmt == null) {
            throw new FBSQLException("No statement was executed, plan cannot be obtained.");
        }
        return this.getExecutionPlan();
    }

    int getStatementType() throws FBSQLException {
        this.populateStatementInfo();
        return this.statementType;
    }

    private void populateStatementInfo() throws FBSQLException {
        if (this.executionPlan == null) {
            byte[] buffer;
            byte[] REQUEST = new byte[]{22, 21, 1};
            int bufferSize = 1024;
            GDS gds = this.gdsHelper.getInternalAPIHandler();
            while (true) {
                try {
                    buffer = gds.iscDsqlSqlInfo(this.fixedStmt, REQUEST, bufferSize);
                }
                catch (GDSException e) {
                    throw new FBSQLException(e);
                }
                if (buffer[0] != 2) break;
                bufferSize *= 2;
            }
            if (buffer[0] == 1) {
                throw new FBSQLException("Statement info could not be retrieved");
            }
            int dataLength = -1;
            block8: for (int i = 0; i < buffer.length; ++i) {
                switch (buffer[i]) {
                    case 22: {
                        dataLength = gds.iscVaxInteger(buffer, ++i, 2);
                        this.executionPlan = new String(buffer, (i += 2) + 1, dataLength);
                        i += dataLength - 1;
                        continue block8;
                    }
                    case 21: {
                        dataLength = gds.iscVaxInteger(buffer, ++i, 2);
                        this.statementType = gds.iscVaxInteger(buffer, i += 2, dataLength);
                        i += dataLength;
                    }
                    case 0: 
                    case 1: {
                        continue block8;
                    }
                    default: {
                        throw new FBSQLException("Unknown data block [" + buffer[i] + "]");
                    }
                }
            }
        }
    }

    private class RSListener
    implements FBObjectListener.ResultSetListener {
        private RSListener() {
        }

        public void resultSetClosed(ResultSet rs) throws SQLException {
            AbstractStatement.this.currentRs = null;
            AbstractStatement.this.notifyStatementCompleted();
        }

        public void allRowsFetched(ResultSet rs) throws SQLException {
            if (AbstractStatement.this.statementListener.getConnection().getAutoCommit()) {
                rs.close();
            }
        }

        public void executionCompleted(FirebirdRowUpdater updater, boolean success) throws SQLException {
            AbstractStatement.this.notifyStatementCompleted(success);
        }

        public void executionStarted(FirebirdRowUpdater updater) throws SQLException {
            AbstractStatement.this.notifyStatementStarted(false);
        }
    }
}

