/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.jdbc.FBConnectionHelper;
import org.firebirdsql.jdbc.FBSQLException;

public class FBDriverPropertyManager {
    private static final String RES = "driver_property_info";
    private static ResourceBundle info;
    private static HashMap aliases;
    private static HashMap dpbMap;
    private static HashMap reversedDpbMap;

    public static HashMap normalize(String url, Map props) throws SQLException {
        HashMap tempProps = new HashMap();
        tempProps.putAll(props);
        FBDriverPropertyManager.convertUrlParams(url, tempProps);
        HashMap result = new HashMap();
        Iterator iter = tempProps.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String propName = (String)entry.getKey();
            Object propValue = entry.getValue();
            PropertyInfo propInfo = (PropertyInfo)aliases.get(propName);
            if (propInfo != null) {
                String originalName = propInfo.dpbName;
                String shortName = propInfo.dpbName.substring("isc_dpb_".length());
                boolean hasDuplicate = tempProps.keySet().contains(originalName) || tempProps.keySet().contains(shortName);
                hasDuplicate &= !propName.equals(shortName);
                if (hasDuplicate &= !propName.equals(originalName)) {
                    throw new FBSQLException("Specified properties contain reference to a DPB parameter under original and alias names: original name " + propInfo.dpbName + ", alias : " + propInfo.alias);
                }
            }
            if (propInfo == null) {
                String tempKey = propName;
                if (!tempKey.startsWith("isc_dpb_")) {
                    tempKey = "isc_dpb_" + tempKey;
                }
                propInfo = (PropertyInfo)dpbMap.get(tempKey);
            }
            if (propInfo == null) continue;
            result.put(propInfo.dpbName, propValue);
        }
        FBDriverPropertyManager.handleEncodings(result);
        return result;
    }

    public static String getCanonicalName(String propertyName) {
        PropertyInfo propInfo = (PropertyInfo)aliases.get(propertyName);
        if (propInfo == null) {
            String tempKey = propertyName;
            if (!tempKey.startsWith("isc_dpb_")) {
                tempKey = "isc_dpb_" + tempKey;
            }
            propInfo = (PropertyInfo)dpbMap.get(tempKey);
        }
        if (propInfo == null) {
            return propertyName;
        }
        return propInfo.dpbName;
    }

    private static void convertUrlParams(String url, HashMap info) {
        if (url == null) {
            return;
        }
        int iQuestionMark = url.indexOf("?");
        if (iQuestionMark == -1) {
            return;
        }
        String propString = url.substring(iQuestionMark + 1);
        StringTokenizer st = new StringTokenizer(propString, "&;");
        while (st.hasMoreTokens()) {
            String propertyString = st.nextToken();
            int iIs = propertyString.indexOf("=");
            if (iIs > -1) {
                String property = propertyString.substring(0, iIs);
                String value = propertyString.substring(iIs + 1);
                info.put(property, value);
                continue;
            }
            info.put(propertyString, "");
        }
    }

    public static void handleEncodings(HashMap info) throws SQLException {
        String mappingPath;
        String javaEncoding;
        String iscEncoding = (String)info.get("isc_dpb_lc_ctype");
        String localEncoding = (String)info.get("isc_dpb_local_encoding");
        if (iscEncoding != null && localEncoding == null && (javaEncoding = EncodingFactory.getJavaEncoding(iscEncoding)) != null) {
            info.put("isc_dpb_local_encoding", javaEncoding);
        }
        if (iscEncoding == null && localEncoding != null) {
            iscEncoding = EncodingFactory.getIscEncoding(localEncoding);
            info.put("isc_dpb_lc_ctype", iscEncoding);
        }
        if ((mappingPath = (String)info.get("isc_dpb_mapping_path")) != null) {
            EncodingFactory.getEncoding(localEncoding, mappingPath);
        }
    }

    public static DriverPropertyInfo[] getDriverPropertyInfo(Properties props) {
        ArrayList<DriverPropertyInfo> result = new ArrayList<DriverPropertyInfo>();
        Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String propName = (String)entry.getKey();
            Object propValue = entry.getValue();
            PropertyInfo propInfo = (PropertyInfo)aliases.get(propName);
            if (propInfo == null) {
                String tempKey = propName;
                if (!tempKey.startsWith("isc_dpb_")) {
                    tempKey = "isc_dpb_" + tempKey;
                }
                propInfo = (PropertyInfo)dpbMap.get(tempKey);
            }
            DriverPropertyInfo driverPropInfo = new DriverPropertyInfo(propName, propValue != null ? propValue.toString() : "");
            if (propInfo != null) {
                driverPropInfo.description = propInfo.description;
            }
            result.add(driverPropInfo);
        }
        return result.toArray(new DriverPropertyInfo[result.size()]);
    }

    static {
        try {
            info = ResourceBundle.getBundle(RES);
        }
        catch (MissingResourceException ex) {
            info = null;
        }
        aliases = new HashMap();
        dpbMap = new HashMap();
        reversedDpbMap = new HashMap();
        if (info != null) {
            Enumeration<String> en = info.getKeys();
            while (en.hasMoreElements()) {
                Integer dpbKey;
                String dpbName;
                String key = en.nextElement();
                String value = info.getString(key);
                int hashIndex = value.indexOf(35);
                String description = "";
                if (hashIndex != -1) {
                    dpbName = value.substring(0, hashIndex).trim();
                    description = value.substring(hashIndex + 1).trim();
                } else {
                    dpbName = value.trim();
                }
                if (!dpbName.startsWith("isc_dpb_") || (dpbKey = FBConnectionHelper.getDpbKey(dpbName)) == null) continue;
                PropertyInfo propInfo = new PropertyInfo(key, dpbName, dpbKey, description);
                aliases.put(propInfo.alias, propInfo);
                dpbMap.put(propInfo.dpbName, propInfo);
                reversedDpbMap.put(dpbKey, propInfo);
            }
        }
        Map tempDpbMap = FBConnectionHelper.getDpbMap();
        Iterator iter = tempDpbMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String dpbName = (String)entry.getKey();
            Integer dpbKey = (Integer)entry.getValue();
            if (!dpbName.startsWith("isc_dpb_") || dpbMap.containsKey(dpbName)) continue;
            PropertyInfo propInfo = new PropertyInfo(null, dpbName, dpbKey, "");
            dpbMap.put(dpbName, propInfo);
            reversedDpbMap.put(dpbKey, propInfo);
        }
    }

    private static class PropertyInfo {
        private String alias;
        private String dpbName;
        private Integer dpbKey;
        private String description;
        private int hashCode;

        public PropertyInfo(String alias, String dpbName, Integer dpbKey, String description) {
            this.alias = alias;
            this.dpbName = dpbName;
            this.dpbKey = dpbKey;
            this.description = description;
            this.hashCode = 17;
            if (alias != null) {
                this.hashCode ^= alias.hashCode();
            }
            this.hashCode ^= dpbName.hashCode();
            this.hashCode ^= dpbKey.intValue();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PropertyInfo)) {
                return false;
            }
            PropertyInfo that = (PropertyInfo)obj;
            boolean result = true;
            result &= this.alias.equals(that.alias);
            result &= this.dpbName.equals(that.dpbName);
            return result &= this.dpbKey.equals(that.dpbKey);
        }
    }
}

