/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.firebirdsql.gds.GDS;
import org.firebirdsql.gds.TransactionParameterBuffer;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jdbc.FBConnectionHelper;

public class FBTpbMapper
implements Serializable {
    public static final String DEFAULT_MAPPING_RESOURCE = "isc_tpb_mapping";
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    private HashMap mapping = new HashMap();
    private int defaultIsolationLevel = 2;

    public static FBTpbMapper getDefaultMapper(GDS gds) {
        return new FBTpbMapper(gds);
    }

    public static String getTransactionIsolationName(int isolationLevel) {
        switch (isolationLevel) {
            case 0: {
                return TRANSACTION_NONE;
            }
            case 1: {
                return TRANSACTION_READ_UNCOMMITTED;
            }
            case 2: {
                return TRANSACTION_READ_COMMITTED;
            }
            case 4: {
                return TRANSACTION_REPEATABLE_READ;
            }
            case 8: {
                return TRANSACTION_SERIALIZABLE;
            }
        }
        throw new IllegalArgumentException("Incorrect transaction isolation level.");
    }

    public static int getTransactionIsolationLevel(String isolationName) {
        if (TRANSACTION_NONE.equals(isolationName)) {
            return 0;
        }
        if (TRANSACTION_READ_UNCOMMITTED.equals(isolationName)) {
            return 1;
        }
        if (TRANSACTION_READ_COMMITTED.equals(isolationName)) {
            return 2;
        }
        if (TRANSACTION_REPEATABLE_READ.equals(isolationName)) {
            return 4;
        }
        if (TRANSACTION_SERIALIZABLE.equals(isolationName)) {
            return 8;
        }
        throw new IllegalArgumentException("Invalid isolation name.");
    }

    public FBTpbMapper(GDS gds) {
        TransactionParameterBuffer serializableTpb = gds.newTransactionParameterBuffer();
        serializableTpb.addArgument(9);
        serializableTpb.addArgument(6);
        serializableTpb.addArgument(1);
        TransactionParameterBuffer repeatableReadTpb = gds.newTransactionParameterBuffer();
        repeatableReadTpb.addArgument(9);
        repeatableReadTpb.addArgument(6);
        repeatableReadTpb.addArgument(2);
        TransactionParameterBuffer readCommittedTpb = gds.newTransactionParameterBuffer();
        readCommittedTpb.addArgument(9);
        readCommittedTpb.addArgument(6);
        readCommittedTpb.addArgument(15);
        readCommittedTpb.addArgument(17);
        this.mapping.put(new Integer(8), serializableTpb);
        this.mapping.put(new Integer(4), repeatableReadTpb);
        this.mapping.put(new Integer(2), readCommittedTpb);
    }

    public FBTpbMapper(GDS gds, Map stringMapping) throws FBResourceException {
        this(gds);
        this.processMapping(gds, stringMapping);
    }

    private void processMapping(GDS gds, Map stringMapping) throws FBResourceException {
        Iterator iter = stringMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String jdbcTxIsolation = (String)entry.getKey();
            if (TRANSACTION_SERIALIZABLE.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(8), FBTpbMapper.processMapping(gds, (String)entry.getValue()));
                continue;
            }
            if (TRANSACTION_REPEATABLE_READ.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(4), FBTpbMapper.processMapping(gds, (String)entry.getValue()));
                continue;
            }
            if (TRANSACTION_READ_COMMITTED.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(2), FBTpbMapper.processMapping(gds, (String)entry.getValue()));
                continue;
            }
            if (TRANSACTION_READ_UNCOMMITTED.equalsIgnoreCase(jdbcTxIsolation)) {
                this.mapping.put(new Integer(1), FBTpbMapper.processMapping(gds, (String)entry.getValue()));
                continue;
            }
            throw new FBResourceException("Transaction isolation " + jdbcTxIsolation + " is not supported.");
        }
    }

    public FBTpbMapper(GDS gds, String mappingResource, ClassLoader cl) throws FBResourceException {
        this(gds);
        try {
            ResourceBundle res = ResourceBundle.getBundle(mappingResource, Locale.getDefault(), cl);
            HashMap<String, String> mapping = new HashMap<String, String>();
            Enumeration<String> en = res.getKeys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String value = res.getString(key);
                mapping.put(key, value);
            }
            this.processMapping(gds, mapping);
        }
        catch (MissingResourceException mrex) {
            throw new FBResourceException("Cannot load TPB mapping." + mrex.getMessage());
        }
    }

    public static TransactionParameterBuffer processMapping(GDS gds, String mapping) throws FBResourceException {
        TransactionParameterBuffer result = gds.newTransactionParameterBuffer();
        StringTokenizer st = new StringTokenizer(mapping, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Integer value = FBConnectionHelper.getTpbParam(token);
            if (value == null) {
                throw new FBResourceException("Keyword " + token + " unknown. Please check your mapping.");
            }
            result.addArgument(value);
        }
        return result;
    }

    public TransactionParameterBuffer getMapping(int transactionIsolation) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                return ((TransactionParameterBuffer)this.mapping.get(new Integer(transactionIsolation))).deepCopy();
            }
            case 1: {
                return ((TransactionParameterBuffer)this.mapping.get(new Integer(2))).deepCopy();
            }
        }
        throw new IllegalArgumentException("Transaction isolation level " + transactionIsolation + " is not supported.");
    }

    public void setMapping(int transactionIsolation, TransactionParameterBuffer tpb) {
        switch (transactionIsolation) {
            case 2: 
            case 4: 
            case 8: {
                this.mapping.put(new Integer(transactionIsolation), tpb);
                break;
            }
            default: {
                throw new IllegalArgumentException("Transaction isolation level " + transactionIsolation + " is not supported.");
            }
        }
    }

    public TransactionParameterBuffer getDefaultMapping() {
        return (TransactionParameterBuffer)this.mapping.get(new Integer(this.defaultIsolationLevel));
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultIsolationLevel;
    }

    public void setDefaultTransactionIsolation(int isolationLevel) {
        this.defaultIsolationLevel = isolationLevel;
    }
}

