/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.pool;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.pool.ObjectCloseTraceException;
import org.firebirdsql.pool.PoolDebugConfiguration;
import org.firebirdsql.pool.StatementHandler;
import org.firebirdsql.pool.XConnectionManager;

class PooledConnectionHandler
implements InvocationHandler {
    private static final boolean LOG_REENTRANT_ACCESS = PoolDebugConfiguration.DEBUG_REENTRANT;
    private static Logger logChannel = LoggerFactory.getLogger(PooledConnectionHandler.class, false);
    private static final Method CONNECTION_PREPARE_STATEMENT = PooledConnectionHandler.findMethod(Connection.class, "prepareStatement", new Class[]{String.class});
    private static final Method CONNECTION_PREPARE_STATEMENT2 = PooledConnectionHandler.findMethod(Connection.class, "prepareStatement", new Class[]{String.class, Integer.TYPE, Integer.TYPE});
    private static final Method CONNECTION_CREATE_STATEMENT = PooledConnectionHandler.findMethod(Connection.class, "createStatement", new Class[0]);
    private static final Method CONNECTION_CREATE_STATEMENT2 = PooledConnectionHandler.findMethod(Connection.class, "createStatement", new Class[]{Integer.TYPE, Integer.TYPE});
    private static final Method CONNECTION_CLOSE = PooledConnectionHandler.findMethod(Connection.class, "close", new Class[0]);
    private static final Method CONNECTION_COMMIT = PooledConnectionHandler.findMethod(Connection.class, "commit", new Class[0]);
    private static final Method CONNECTION_ROLLBACK = PooledConnectionHandler.findMethod(Connection.class, "rollback", new Class[0]);
    private Connection connection;
    private XConnectionManager owner;
    private Connection proxy;
    private boolean closed;
    private ObjectCloseTraceException closeStackTrace;
    private boolean invokeEntered;
    private HashSet openStatements = new HashSet();

    public static Method findMethod(Class clazz, String name, Class[] args) {
        try {
            return clazz.getMethod(name, args);
        }
        catch (NoSuchMethodException nmex) {
            throw new NullPointerException("No method for proxying found. Please check your classpath.");
        }
    }

    public static Class[] getAllInterfaces(Class clazz) {
        HashSet result = new HashSet();
        do {
            Class<?>[] interfaces = clazz.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                result.add(interfaces[i]);
            }
        } while ((clazz = clazz.getSuperclass()).getSuperclass() != null);
        return result.toArray(new Class[result.size()]);
    }

    public PooledConnectionHandler(Connection connection, XConnectionManager owner) throws SQLException {
        this.connection = connection;
        this.owner = owner;
        Class[] implementedInterfaces = PooledConnectionHandler.getAllInterfaces(connection.getClass());
        this.proxy = (Connection)Proxy.newProxyInstance(PooledConnectionHandler.class.getClassLoader(), implementedInterfaces, (InvocationHandler)this);
    }

    public Connection getProxy() {
        return this.proxy;
    }

    public XConnectionManager getManager() {
        return this.owner;
    }

    public void deallocate() throws SQLException {
        this.handleConnectionClose(false);
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (LOG_REENTRANT_ACCESS && this.invokeEntered && logChannel != null) {
                logChannel.warn("Re-entrant access detected.", new Exception());
            }
            this.invokeEntered = true;
            if (this.closed) {
                FBSQLException ex = new FBSQLException("Connection " + this + " was closed. " + "See the attached exception to find the place " + "where it was closed");
                ex.setNextException(this.closeStackTrace);
                throw ex;
            }
            if (this.owner != null && !this.owner.isValid(this)) {
                throw new SQLException("This connection owner is not valid anymore.");
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT)) {
                String statement = (String)args[0];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, 1003, 1007);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_PREPARE_STATEMENT2)) {
                String statement = (String)args[0];
                Integer resultSetType = (Integer)args[1];
                Integer resultSetConcurrency = (Integer)args[2];
                PreparedStatement preparedStatement = this.handlePrepareStatement(statement, resultSetType, resultSetConcurrency);
                return preparedStatement;
            }
            if (method.equals(CONNECTION_CREATE_STATEMENT)) {
                Statement statement = this.handleCreateStatement(1003, 1007);
                return statement;
            }
            if (method.equals(CONNECTION_CREATE_STATEMENT2)) {
                Integer resultSetType = (Integer)args[0];
                Integer resultSetConcurrency = (Integer)args[1];
                Statement statement = this.handleCreateStatement(resultSetType, resultSetConcurrency);
                return statement;
            }
            if (method.equals(CONNECTION_COMMIT)) {
                this.handleConnectionCommit();
                Class<Void> resultSetType = Void.TYPE;
                return resultSetType;
            }
            if (method.equals(CONNECTION_ROLLBACK)) {
                this.handleConnectionRollback();
                Class<Void> resultSetType = Void.TYPE;
                return resultSetType;
            }
            if (method.equals(CONNECTION_CLOSE)) {
                this.handleConnectionClose();
                Class<Void> resultSetType = Void.TYPE;
                return resultSetType;
            }
            Object resultSetType = method.invoke((Object)this.connection, args);
            return resultSetType;
        }
        catch (InvocationTargetException ex) {
            if (ex.getTargetException() instanceof SQLException && this.owner != null) {
                this.owner.connectionErrorOccured(this, (SQLException)ex.getTargetException());
            }
            throw ex.getTargetException();
        }
        catch (SQLException ex) {
            if (this.owner != null) {
                this.owner.connectionErrorOccured(this, ex);
            }
            throw ex;
        }
        finally {
            this.invokeEntered = false;
        }
    }

    synchronized PreparedStatement handlePrepareStatement(String statement, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.getManager().getPreparedStatement(statement, resultSetType, resultSetConcurrency);
    }

    synchronized Statement handleCreateStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement result = this.connection.createStatement(resultSetType, resultSetConcurrency);
        StatementHandler handler = new StatementHandler(this, result);
        this.openStatements.add(handler);
        return handler.getProxy();
    }

    public synchronized void forgetStatement(StatementHandler handler) {
        this.openStatements.remove(handler);
    }

    synchronized void closeOpenStatements() throws SQLException {
        SQLException error = null;
        Iterator iter = this.openStatements.iterator();
        while (iter.hasNext()) {
            StatementHandler handler = (StatementHandler)iter.next();
            try {
                handler.getWrappedObject().close();
            }
            catch (SQLException ex) {
                if (error == null) {
                    error = ex;
                    continue;
                }
                error.setNextException(ex);
            }
        }
        if (error != null) {
            throw error;
        }
    }

    synchronized void handleConnectionClose() throws SQLException {
        this.handleConnectionClose(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void handleConnectionClose(boolean notifyOwner) throws SQLException {
        block3: {
            try {
                this.closeOpenStatements();
                Object var3_2 = null;
                if (this.owner == null || !notifyOwner) break block3;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.owner != null && notifyOwner) {
                    this.owner.connectionClosed(this);
                }
                this.closed = true;
                this.closeStackTrace = new ObjectCloseTraceException();
                throw throwable;
            }
            this.owner.connectionClosed(this);
        }
        this.closed = true;
        this.closeStackTrace = new ObjectCloseTraceException();
    }

    synchronized void handleConnectionCommit() throws SQLException {
        this.connection.commit();
        this.getManager().connectionCommitted(this);
    }

    synchronized void handleConnectionRollback() throws SQLException {
        this.connection.rollback();
        this.getManager().connectionRolledBack(this);
    }
}

