/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.ArrayList;
import java.util.List;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.mdx.KeySegment;
import org.olap4j.mdx.NameSegment;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.Quoting;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierParser {
    private static final int START = 0;
    private static final int BEFORE_SEG = 1;
    private static final int IN_BRACKET_SEG = 2;
    private static final int AFTER_SEG = 3;
    private static final int IN_SEG = 4;

    private static char charAt(String s, int pos) {
        return pos < s.length() ? s.charAt(pos) : (char)'\u0000';
    }

    public static void parseTupleList(Builder builder, String string) {
        char c;
        int i = 0;
        while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
        }
        if (c != '{') {
            throw IdentifierParser.fail(string, i, "{");
        }
        do {
            i = IdentifierParser.parseTuple(builder, string, i);
            while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
            }
        } while (c == ',');
        if (c == '}') {
            return;
        }
        throw IdentifierParser.fail(string, i, ", or }");
    }

    public static int parseTuple(Builder builder, String string, int i) {
        char c;
        while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
        }
        if (c != '(') {
            throw IdentifierParser.fail(string, i, "(");
        }
        do {
            i = IdentifierParser.parseMember(builder, string, i);
            while ((c = IdentifierParser.charAt(string, i++)) == ' ') {
            }
        } while (c == ',' || c != ')');
        builder.tupleComplete();
        return i;
    }

    public static void parseMemberList(Builder builder, String string) {
        int i = 0;
        char c = IdentifierParser.charAt(string, i);
        while (c > '\u0000' && c <= ' ') {
            c = IdentifierParser.charAt(string, ++i);
        }
        boolean leadingBrace = false;
        boolean trailingBrace = false;
        if (c == '{') {
            leadingBrace = true;
            ++i;
        }
        block6: while (true) {
            i = IdentifierParser.parseMember(builder, string, i);
            c = IdentifierParser.charAt(string, i);
            while (c > '\u0000' && c <= ' ') {
                c = IdentifierParser.charAt(string, ++i);
            }
            switch (c) {
                case '\u0000': {
                    break block6;
                }
                case ',': {
                    ++i;
                    continue block6;
                }
                case '}': {
                    trailingBrace = true;
                    break block6;
                }
                default: {
                    throw IdentifierParser.fail(string, i, ", or }");
                }
            }
            break;
        }
        if (leadingBrace != trailingBrace) {
            throw new IllegalArgumentException("mismatched '{' and '}' in '" + string + "'");
        }
    }

    public static int parseMember(Builder builder, String string, int i) {
        int k = string.length();
        int state = 0;
        int start = 0;
        Builder.Syntax syntax = Builder.Syntax.NAME;
        block32: while (i < k + 1) {
            char c = IdentifierParser.charAt(string, i);
            switch (state) {
                case 0: 
                case 1: {
                    switch (c) {
                        case '[': {
                            start = ++i;
                            state = 2;
                            continue block32;
                        }
                        case ' ': {
                            ++i;
                            continue block32;
                        }
                        case '\u0000': 
                        case ',': 
                        case '}': {
                            break block32;
                        }
                        case '.': {
                            throw new IllegalArgumentException("unexpected: '.'");
                        }
                        case '&': {
                            ++i;
                            if (syntax != Builder.Syntax.NAME) {
                                throw new IllegalArgumentException("unexpected: '&'");
                            }
                            syntax = Builder.Syntax.FIRST_KEY;
                            continue block32;
                        }
                    }
                    state = 4;
                    start = i;
                    continue block32;
                }
                case 4: {
                    switch (c) {
                        case '\u0000': 
                        case ')': 
                        case ',': 
                        case '}': {
                            builder.segmentComplete(null, string.substring(start, i).trim(), Quoting.UNQUOTED, syntax);
                            state = 3;
                            break block32;
                        }
                        case '.': {
                            builder.segmentComplete(null, string.substring(start, i).trim(), Quoting.UNQUOTED, syntax);
                            syntax = Builder.Syntax.NAME;
                            state = 1;
                            ++i;
                            continue block32;
                        }
                        case '&': {
                            builder.segmentComplete(null, string.substring(start, i).trim(), Quoting.UNQUOTED, syntax);
                            syntax = Builder.Syntax.NEXT_KEY;
                            state = 1;
                            ++i;
                            continue block32;
                        }
                    }
                    ++i;
                    continue block32;
                }
                case 2: {
                    switch (c) {
                        case '\u0000': {
                            throw new IllegalArgumentException("Expected ']', in member identifier '" + string + "'");
                        }
                        case ']': {
                            if (IdentifierParser.charAt(string, i + 1) == ']') {
                                ++i;
                                break;
                            }
                            builder.segmentComplete(null, Olap4jUtil.replace(string.substring(start, i), "]]", "]"), Quoting.QUOTED, syntax);
                            ++i;
                            state = 3;
                            continue block32;
                        }
                    }
                    ++i;
                    continue block32;
                }
                case 3: {
                    switch (c) {
                        case ' ': {
                            ++i;
                            continue block32;
                        }
                        case '.': {
                            state = 1;
                            syntax = Builder.Syntax.NAME;
                            ++i;
                            continue block32;
                        }
                        case '&': {
                            state = 1;
                            syntax = syntax == Builder.Syntax.FIRST_KEY ? Builder.Syntax.NEXT_KEY : Builder.Syntax.FIRST_KEY;
                            ++i;
                            continue block32;
                        }
                    }
                    break block32;
                }
                default: {
                    throw new AssertionError((Object)("unexpected state: " + state));
                }
            }
        }
        switch (state) {
            case 0: {
                return i;
            }
            case 1: {
                throw new IllegalArgumentException("Expected identifier after '.', in member identifier '" + string + "'");
            }
            case 2: {
                throw new IllegalArgumentException("Expected ']', in member identifier '" + string + "'");
            }
        }
        builder.memberComplete();
        return i;
    }

    private static IllegalArgumentException fail(String string, int i, String expecting) {
        throw new IllegalArgumentException("expected '" + expecting + "' at position " + i + " in '" + string + "'");
    }

    public static List<IdentifierSegment> parseIdentifier(String s) {
        MemberBuilder builder = new MemberBuilder();
        int i = IdentifierParser.parseMember(builder, s, 0);
        if (i < s.length()) {
            throw new IllegalArgumentException("Invalid member identifier '" + s + "'");
        }
        return builder.segmentList;
    }

    public static List<List<IdentifierSegment>> parseIdentifierList(String s) {
        MemberListBuilder builder = new MemberListBuilder();
        IdentifierParser.parseMemberList(builder, s);
        return builder.list;
    }

    public static class MemberListBuilder
    extends MemberBuilder {
        final List<List<IdentifierSegment>> list = new ArrayList<List<IdentifierSegment>>();

        public void memberComplete() {
            super.memberComplete();
            this.list.add(new ArrayList(this.segmentList));
            this.segmentList.clear();
        }
    }

    public static class MemberBuilder
    implements Builder {
        protected final List<NameSegment> subSegments;
        protected final List<IdentifierSegment> segmentList = new ArrayList<IdentifierSegment>();

        public MemberBuilder() {
            this.subSegments = new ArrayList<NameSegment>();
        }

        public void tupleComplete() {
            throw new UnsupportedOperationException();
        }

        public void memberComplete() {
            this.flushSubSegments();
        }

        private void flushSubSegments() {
            if (!this.subSegments.isEmpty()) {
                this.segmentList.add(new KeySegment(this.subSegments));
                this.subSegments.clear();
            }
        }

        public void segmentComplete(ParseRegion region, String name, Quoting quoting, Builder.Syntax syntax) {
            NameSegment segment = new NameSegment(region, name, quoting);
            if (syntax != Builder.Syntax.NEXT_KEY) {
                this.flushSubSegments();
            }
            if (syntax == Builder.Syntax.NAME) {
                this.segmentList.add(segment);
            } else {
                this.subSegments.add(segment);
            }
        }
    }

    public static interface Builder {
        public void tupleComplete();

        public void memberComplete();

        public void segmentComplete(ParseRegion var1, String var2, Quoting var3, Syntax var4);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Syntax {
            NAME,
            FIRST_KEY,
            NEXT_KEY;

        }
    }
}

