/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.olap4j.impl.Olap4jUtil;

public class LcidLocale {
    final Map<Short, String> lcidLocaleMap = new HashMap<Short, String>();
    final Map<String, Short> localeToLcidMap = new HashMap<String, Short>();
    private static final Object[] LOCALE_DATA = new Object[]{"", (short)127, "invariant culture", "ar", (short)1, "Arabic", "bg", (short)2, "Bulgarian", "ca", (short)3, "Catalan", "zh_CHS", (short)4, "Chinese (Simplified)", "cs", (short)5, "Czech", "da", (short)6, "Danish", "de", (short)7, "German", "el", (short)8, "Greek", "en", (short)9, "English", "es", (short)10, "Spanish", "fi", (short)11, "Finnish", "fr", (short)12, "French", "he", (short)13, "Hebrew", "hu", (short)14, "Hungarian", "is", (short)15, "Icelandic", "it", (short)16, "Italian", "ja", (short)17, "Japanese", "ko", (short)18, "Korean", "nl", (short)19, "Dutch", "no", (short)20, "Norwegian", "pl", (short)21, "Polish", "pt", (short)22, "Portuguese", "ro", (short)24, "Romanian", "ru", (short)25, "Russian", "hr", (short)26, "Croatian", "sk", (short)27, "Slovak", "sq", (short)28, "Albanian", "sv", (short)29, "Swedish", "th", (short)30, "Thai", "tr", (short)31, "Turkish", "ur", (short)32, "Urdu", "id", (short)33, "Indonesian", "uk", (short)34, "Ukrainian", "be", (short)35, "Belarusian", "sl", (short)36, "Slovenian", "et", (short)37, "Estonian", "lv", (short)38, "Latvian", "lt", (short)39, "Lithuanian", "fa", (short)41, "Farsi", "vi", (short)42, "Vietnamese", "hy", (short)43, "Armenian", "az", (short)44, "Azeri", "eu", (short)45, "Basque", "mk", (short)47, "Macedonian", "af", (short)54, "Afrikaans", "ka", (short)55, "Georgian", "fo", (short)56, "Faroese", "hi", (short)57, "Hindi", "ms", (short)62, "Malay", "kk", (short)63, "Kazakh", "ky", (short)64, "Kyrgyz", "sw", (short)65, "Swahili", "uz", (short)67, "Uzbek", "tt", (short)68, "Tatar", "pa", (short)70, "Punjabi", "gu", (short)71, "Gujarati", "ta", (short)73, "Tamil", "te", (short)74, "Telugu", "kn", (short)75, "Kannada", "mr", (short)78, "Marathi", "sa", (short)79, "Sanskrit", "mn", (short)80, "Mongolian", "gl", (short)86, "Galician", "kok", (short)87, "Konkani", "syr", (short)90, "Syriac", "div", (short)101, "Dhivehi", "ar_SA", (short)1025, "Arabic - Saudi Arabia", "bg_BG", (short)1026, "Bulgarian - Bulgaria", "ca_ES", (short)1027, "Catalan - Catalan", "zh_TW", (short)1028, "Chinese - Taiwan", "cs_CZ", (short)1029, "Czech - Czech Republic", "da_DK", (short)1030, "Danish - Denmark", "de_DE", (short)1031, "German - Germany", "el_GR", (short)1032, "Greek - Greece", "en_US", (short)1033, "English - United States", "es_ES", (short)1034, "Spanish - Spain (Traditional Sort)", "fi_FI", (short)1035, "Finnish - Finland", "fr_FR", (short)1036, "French - France", "he_IL", (short)1037, "Hebrew - Israel", "hu_HU", (short)1038, "Hungarian - Hungary", "is_IS", (short)1039, "Icelandic - Iceland", "it_IT", (short)1040, "Italian - Italy", "ja_JP", (short)1041, "Japanese - Japan", "ko_KR", (short)1042, "Korean - Korea", "nl_NL", (short)1043, "Dutch - The Netherlands", "nb_NO", (short)1044, "Norwegian (Bokml) - Norway", "pl_PL", (short)1045, "Polish - Poland", "pt_BR", (short)1046, "Portuguese - Brazil", "rm", (short)1047, "Rhaeto-Romanic", "ro_RO", (short)1048, "Romanian - Romania", "ru_RU", (short)1049, "Russian - Russia", "hr_HR", (short)1050, "Croatian - Croatia", "sk_SK", (short)1051, "Slovak - Slovakia", "sq_AL", (short)1052, "Albanian - Albania", "sv_SE", (short)1053, "Swedish - Sweden", "th_TH", (short)1054, "Thai - Thailand", "tr_TR", (short)1055, "Turkish - Turkey", "ur_PK", (short)1056, "Urdu - Pakistan", "id_ID", (short)1057, "Indonesian - Indonesia", "uk_UA", (short)1058, "Ukrainian - Ukraine", "be_BY", (short)1059, "Belarusian - Belarus", "sl_SI", (short)1060, "Slovenian - Slovenia", "et_EE", (short)1061, "Estonian - Estonia", "lv_LV", (short)1062, "Latvian - Latvia", "lt_LT", (short)1063, "Lithuanian - Lithuania", "fa_IR", (short)1065, "Farsi - Iran", "vi_VN", (short)1066, "Vietnamese - Vietnam", "hy_AM", (short)1067, "Armenian - Armenia", "az_AZ_Latn", (short)1068, "Azeri (Latin) - Azerbaijan", "eu_ES", (short)1069, "Basque - Basque", "mk_MK", (short)1071, "Macedonian - FYROM", "tn", (short)1074, "Tswana", "xh", (short)1076, "Xhosa", "zu", (short)1077, "Zulu", "af_ZA", (short)1078, "Afrikaans - South Africa", "ka_GE", (short)1079, "Georgian - Georgia", "fo_FO", (short)1080, "Faroese - Faroe Islands", "hi_IN", (short)1081, "Hindi - India", "mt", (short)1082, "Maltese", "se_NO", (short)1083, "Sami (Northern) - Norway", "gd", (short)1084, "Gaelic", "ms_MY", (short)1086, "Malay - Malaysia", "kk_KZ", (short)1087, "Kazakh - Kazakhstan", "ky_KZ", (short)1088, "Kyrgyz - Kazakhstan", "sw_KE", (short)1089, "Swahili - Kenya", "uz_UZ_Latn", (short)1091, "Uzbek (Latin) - Uzbekistan", "tt_RU", (short)1092, "Tatar - Russia", "bn_IN", (short)1093, "Bengali - India", "pa_IN", (short)1094, "Punjabi - India", "gu_IN", (short)1095, "Gujarati - India", "ta_IN", (short)1097, "Tamil - India", "te_IN", (short)1098, "Telugu - India", "kn_IN", (short)1099, "Kannada - India", "ml_IN", (short)1100, "Mayalam - India", "mr_IN", (short)1102, "Marathi - India", "sa_IN", (short)1103, "Sanskrit - India", "mn_MN", (short)1104, "Mongolian - Mongolia", "cy_GB", (short)1106, "Welsh - United Kingdom", "gl_ES", (short)1110, "Galician - Galician", "kok_IN", (short)1111, "Konkani - India", "syr_SY", (short)1114, "Syriac - Syria", "div_MV", (short)1125, "Dhivehi - Maldives", "quz_BO", (short)1131, "Quecha - Bolivia", "mi_NZ", (short)1153, "Maori - New Zealand", "ar_IQ", (short)2049, "Arabic - Iraq", "zh_CN", (short)2052, "Chinese - China", "de_CH", (short)2055, "German - Switzerland", "en_GB", (short)2057, "English - United Kingdom", "es_MX", (short)2058, "Spanish - Mexico", "fr_BE", (short)2060, "French - Belgium", "it_CH", (short)2064, "Italian - Switzerland", "nl_BE", (short)2067, "Dutch - Belgium", "nn_NO", (short)2068, "Norwegian (Nynorsk) - Norway", "pt_PT", (short)2070, "Portuguese - Portugal", "ro_MD", (short)2072, "Romanian - Moldova", "ru_MD", (short)2073, "Russian - Moldova", "sr_SP_Latn", (short)2074, "Serbian (Latin) - Serbia", "sv_FI", (short)2077, "Swedish - Finland", "az_AZ_Cyrl", (short)2092, "Azeri (Cyrillic) - Azerbaijan", "se_SE", (short)2107, "Sami (Northern) - Sweden", "ga", (short)2108, "Irish", "ms_BN", (short)2110, "Malay - Brunei", "uz_UZ_Cyrl", (short)2115, "Uzbek (Cyrillic) - Uzbekistan", "bn_BD", (short)2117, "Bengali - Bangladesh", "quz_EC", (short)2155, "Quecha - Ecuador", "ar_EG", (short)3073, "Arabic - Egypt", "zh_HK", (short)3076, "Chinese - Hong Kong SAR", "de_AT", (short)3079, "German - Austria", "en_AU", (short)3081, "English - Australia", "es_ES", (short)3082, "Spanish - Spain", "fr_CA", (short)3084, "French - Canada", "sr_SP_Cyrl", (short)3098, "Serbian (Cyrillic) - Serbia", "se_FI", (short)3131, "Sami (Northern) - Finland", "quz_PE", (short)3179, "Quecha - Peru", "ar_LY", (short)4097, "Arabic - Libya", "zh_SG", (short)4100, "Chinese - Singapore", "de_LU", (short)4103, "German - Luxembourg", "en_CA", (short)4105, "English - Canada", "es_GT", (short)4106, "Spanish - Guatemala", "fr_CH", (short)4108, "French - Switzerland", "hr_BA", (short)4122, "Croatian - Bosnia and Herzegovina", "ar_DZ", (short)5121, "Arabic - Algeria", "zh_MO", (short)5124, "Chinese - Macau SAR", "de_LI", (short)5127, "German - Liechtenstein", "en_NZ", (short)5129, "English - New Zealand", "es_CR", (short)5130, "Spanish - Costa Rica", "fr_LU", (short)5132, "French - Luxembourg", "bs_Latn_BA", (short)5146, "Bosnian (Latin) - Bosnia/Herzegovina", "ar_MA", (short)6145, "Arabic - Morocco", "en_IE", (short)6153, "English - Ireland", "es_PA", (short)6154, "Spanish - Panama", "fr_MC", (short)6156, "French - Monaco", "sr_Latn_BA", (short)6170, "Serbian (Latin) - Bosnia/Herzegovina", "ar_TN", (short)7169, "Arabic - Tunisia", "en_ZA", (short)7177, "English - South Africa", "es_DO", (short)7178, "Spanish - Dominican Republic", "sr_Cyrl_BA", (short)7194, "Serbian (Cyrillic) - Bosnia/Herzegovina", "ar_OM", (short)8193, "Arabic - Oman", "en_JM", (short)8201, "English - Jamaica", "es_VE", (short)8202, "Spanish - Venezuela", "ar_YE", (short)9217, "Arabic - Yemen", "en_CB", (short)9225, "English - Caribbean", "es_CO", (short)9226, "Spanish - Colombia", "ar_SY", (short)10241, "Arabic - Syria", "en_BZ", (short)10249, "English - Belize", "es_PE", (short)10250, "Spanish - Peru", "ar_JO", (short)11265, "Arabic - Jordan", "en_TT", (short)11273, "English - Trinidad and Tobago", "es_AR", (short)11274, "Spanish - Argentina", "ar_LB", (short)12289, "Arabic - Lebanon", "en_ZW", (short)12297, "English - Zimbabwe", "es_EC", (short)12298, "Spanish - Ecuador", "ar_KW", (short)13313, "Arabic - Kuwait", "en_PH", (short)13321, "English - Philippines", "es_CL", (short)13322, "Spanish - Chile", "ar_AE", (short)14337, "Arabic - United Arab Emirates", "es_UY", (short)14346, "Spanish - Uruguay", "ar_BH", (short)15361, "Arabic - Bahrain", "es_PY", (short)15370, "Spanish - Paraguay", "ar_QA", (short)16385, "Arabic - Qatar", "es_BO", (short)16394, "Spanish - Bolivia", "es_SV", (short)17418, "Spanish - El Salvador", "es_HN", (short)18442, "Spanish - Honduras", "es_NI", (short)19466, "Spanish - Nicaragua", "es_PR", (short)20490, "Spanish - Puerto Rico", "zh_CHT", (short)31748, "Chinese (Traditional)"};
    private static LcidLocale INSTANCE;

    private LcidLocale() {
        int i = 0;
        while (i < LOCALE_DATA.length) {
            String localeName = (String)LOCALE_DATA[i++];
            Short lcid = (Short)LOCALE_DATA[i++];
            Olap4jUtil.discard((String)LOCALE_DATA[i++]);
            this.lcidLocaleMap.put(lcid, localeName);
            this.localeToLcidMap.put(localeName, lcid);
        }
        assert (LOCALE_DATA.length % 3 == 0);
        assert (this.lcidLocaleMap.size() == LOCALE_DATA.length / 3);
        assert (this.localeToLcidMap.size() == LOCALE_DATA.length / 3 - 1);
    }

    static LcidLocale instance() {
        if (INSTANCE == null) {
            INSTANCE = new LcidLocale();
        }
        return INSTANCE;
    }

    private Locale toLocale(short lcid) {
        String s = this.lcidLocaleMap.get(lcid);
        if (s == null) {
            throw new RuntimeException("Unknown LCID " + lcid);
        }
        return LcidLocale.parseLocale(s);
    }

    public static Locale lcidToLocale(short lcid) {
        if (lcid == 1033) {
            return Locale.US;
        }
        return LcidLocale.instance().toLocale(lcid);
    }

    public static short localeToLcid(Locale locale) {
        if (locale.equals(Locale.US)) {
            return 1033;
        }
        return LcidLocale.instance().toLcid(locale.toString());
    }

    private short toLcid(String localeName) {
        String localeName0 = localeName;
        Short lcid;
        while ((lcid = this.localeToLcidMap.get(localeName)) == null) {
            int underscore = localeName.lastIndexOf(95);
            if (underscore < 0) {
                throw new RuntimeException("Unknown locale " + localeName0);
            }
            localeName = localeName.substring(0, underscore);
        }
        return lcid;
    }

    public static Locale parseLocale(String localeString) {
        String[] strings = localeString.split("_");
        switch (strings.length) {
            case 1: {
                return new Locale(strings[0]);
            }
            case 2: {
                return new Locale(strings[0], strings[1]);
            }
            case 3: {
                return new Locale(strings[0], strings[1], strings[2]);
            }
        }
        throw new RuntimeException("bad locale string '" + localeString + "'");
    }
}

