/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import org.olap4j.mdx.ParseTreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseRegion {
    private final int startLine;
    private final int startColumn;
    private final int endLine;
    private final int endColumn;

    public ParseRegion(int startLine, int startColumn, int endLine, int endColumn) {
        assert (endLine >= startLine);
        assert (endLine > startLine || endColumn >= startColumn);
        this.startLine = startLine;
        this.startColumn = startColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public ParseRegion(int line, int column) {
        this(line, column, line, column);
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public String toString() {
        return "[" + this.startLine + ":" + this.startColumn + (this.isPoint() ? "" : ", " + this.endLine + ":" + this.endColumn) + "]";
    }

    public boolean isPoint() {
        return this.endLine == this.startLine && this.endColumn == this.startColumn;
    }

    public int hashCode() {
        return this.startLine ^ this.startColumn << 2 ^ this.endLine << 4 ^ this.endColumn << 8;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParseRegion) {
            ParseRegion that = (ParseRegion)obj;
            return this.startLine == that.startLine && this.startColumn == that.startColumn && this.endLine == that.endLine && this.endColumn == that.endColumn;
        }
        return false;
    }

    public ParseRegion plus(final ParseTreeNode ... nodes) {
        return this.plusAll((Iterable<ParseRegion>)new AbstractList<ParseRegion>(){

            @Override
            public ParseRegion get(int index) {
                ParseTreeNode node = nodes[index];
                if (node == null) {
                    return null;
                }
                return node.getRegion();
            }

            @Override
            public int size() {
                return nodes.length;
            }
        });
    }

    public ParseRegion plus(final List<? extends ParseTreeNode> nodes) {
        if (nodes == null) {
            return this;
        }
        return this.plusAll((Iterable<ParseRegion>)new AbstractList<ParseRegion>(){

            @Override
            public ParseRegion get(int index) {
                ParseTreeNode node = (ParseTreeNode)nodes.get(index);
                if (node == null) {
                    return null;
                }
                return node.getRegion();
            }

            @Override
            public int size() {
                return nodes.size();
            }
        });
    }

    public ParseRegion plus(ParseRegion ... regions) {
        return this.plusAll(Arrays.asList(regions));
    }

    public ParseRegion plusAll(Iterable<ParseRegion> regions) {
        return ParseRegion.sum(regions, this.getStartLine(), this.getStartColumn(), this.getEndLine(), this.getEndColumn());
    }

    public static ParseRegion sum(Iterable<ParseRegion> nodes) {
        return ParseRegion.sum(nodes, Integer.MAX_VALUE, Integer.MAX_VALUE, -1, -1);
    }

    private static ParseRegion sum(Iterable<ParseRegion> regions, int startLine, int startColumn, int endLine, int endColumn) {
        for (ParseRegion region : regions) {
            if (region == null) continue;
            int testLine = region.getStartLine();
            int testColumn = region.getStartColumn();
            if (testLine < startLine || testLine == startLine && testColumn < startColumn) {
                startLine = testLine;
                startColumn = testColumn;
            }
            testLine = region.getEndLine();
            testColumn = region.getEndColumn();
            if (testLine <= endLine && (testLine != endLine || testColumn <= endColumn)) continue;
            endLine = testLine;
            endColumn = testColumn;
        }
        return new ParseRegion(startLine, startColumn, endLine, endColumn);
    }

    public static RegionAndSource findPos(String code) {
        int firstCaret = code.indexOf(94);
        if (firstCaret < 0) {
            return new RegionAndSource(code, null);
        }
        int secondCaret = code.indexOf(94, firstCaret + 1);
        if (secondCaret < 0) {
            String codeSansCaret = code.substring(0, firstCaret) + code.substring(firstCaret + 1);
            int[] start = ParseRegion.indexToLineCol(code, firstCaret);
            return new RegionAndSource(codeSansCaret, new ParseRegion(start[0], start[1]));
        }
        String codeSansCaret = code.substring(0, firstCaret) + code.substring(firstCaret + 1, secondCaret) + code.substring(secondCaret + 1);
        int[] start = ParseRegion.indexToLineCol(code, firstCaret);
        --secondCaret;
        int[] end = ParseRegion.indexToLineCol(code, --secondCaret);
        return new RegionAndSource(codeSansCaret, new ParseRegion(start[0], start[1], end[0], end[1]));
    }

    private static int[] indexToLineCol(String code, int i) {
        int line = 0;
        int j = 0;
        while (true) {
            String s;
            int rn = code.indexOf("\r\n", j);
            int r = code.indexOf("\r", j);
            int n = code.indexOf("\n", j);
            int prevj = j;
            if (r < 0 && n < 0) {
                assert (rn < 0);
                s = null;
                j = -1;
            } else if (rn >= 0 && rn < n && rn <= r) {
                s = "\r\n";
                j = rn;
            } else if (r >= 0 && r < n) {
                s = "\r";
                j = r;
            } else {
                s = "\n";
                j = n;
            }
            if (j < 0 || j > i) {
                return new int[]{line + 1, i - prevj + 1};
            }
            assert (s != null);
            j += s.length();
            ++line;
        }
    }

    private static int lineColToIndex(String code, int line, int column) {
        --line;
        --column;
        int i = 0;
        while (line-- > 0) {
            i = code.indexOf("\n", i) + "\n".length();
        }
        return i + column;
    }

    public String annotate(String source) {
        return ParseRegion.addCarets(source, this.startLine, this.startColumn, this.endLine, this.endColumn);
    }

    private static String addCarets(String sql, int line, int col, int endLine, int endCol) {
        int cut = ParseRegion.lineColToIndex(sql, line, col);
        String sqlWithCarets = sql.substring(0, cut) + "^" + sql.substring(cut);
        if (col != endCol || line != endLine) {
            cut = ParseRegion.lineColToIndex(sqlWithCarets, endLine, endCol + 1);
            sqlWithCarets = ++cut < sqlWithCarets.length() ? sqlWithCarets.substring(0, cut) + "^" + sqlWithCarets.substring(cut) : sqlWithCarets + "^";
        }
        return sqlWithCarets;
    }

    public static class RegionAndSource {
        public final String source;
        public final ParseRegion region;

        public RegionAndSource(String source, ParseRegion region) {
            this.source = source;
            this.region = region;
        }
    }
}

