/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms;

import java.sql.Connection;
import java.sql.SQLException;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.exceptions.NucleusDataStoreException;
import org.datanucleus.store.connection.ManagedConnection;
import org.datanucleus.store.rdbms.RDBMSStoreManager;

public abstract class AbstractSchemaTransaction {
    protected RDBMSStoreManager rdbmsMgr;
    protected final int isolationLevel;
    protected final int maxRetries;
    protected ManagedConnection mconn;
    private Connection conn;

    public AbstractSchemaTransaction(RDBMSStoreManager rdbmsMgr, int isolationLevel) {
        this.rdbmsMgr = rdbmsMgr;
        this.isolationLevel = isolationLevel;
        this.maxRetries = rdbmsMgr.getOMFContext().getPersistenceConfiguration().getIntProperty("datanucleus.rdbms.classAdditionMaxRetries");
    }

    public abstract String toString();

    protected abstract void run(ClassLoaderResolver var1) throws SQLException;

    protected Connection getCurrentConnection() throws SQLException {
        if (this.conn == null) {
            this.mconn = this.rdbmsMgr.getConnection(this.isolationLevel);
            this.conn = (Connection)this.mconn.getConnection();
        }
        return this.conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ClassLoaderResolver clr) {
        int attempts = 0;
        while (true) {
            try {
                try {
                    boolean succeeded = false;
                    try {
                        this.run(clr);
                        succeeded = true;
                    }
                    finally {
                        if (this.conn != null && this.isolationLevel != 0 && !this.conn.getAutoCommit()) {
                            if (succeeded) {
                                this.conn.commit();
                            } else {
                                this.conn.rollback();
                            }
                        }
                    }
                }
                finally {
                    if (this.conn != null) {
                        this.mconn.close();
                        this.conn = null;
                    }
                }
            }
            catch (SQLException e) {
                if (++attempts < this.maxRetries) continue;
                throw new NucleusDataStoreException("Exception thrown performing schema operation : " + this, (Throwable)e);
            }
            break;
        }
    }
}

