/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.store.query.ResultObjectFactory;
import org.datanucleus.util.NucleusLogger;
import org.datanucleus.util.StringUtils;

public abstract class AbstractRDBMSQueryResult
extends AbstractQueryResult {
    protected ResultSet rs;
    protected ResultObjectFactory rof;

    public AbstractRDBMSQueryResult(Query query, ResultObjectFactory rof, ResultSet rs) {
        super(query);
        this.rof = rof;
        this.rs = rs;
    }

    public void disconnect() {
        if (this.query == null) {
            return;
        }
        super.disconnect();
        this.rof = null;
        this.rs = null;
    }

    public synchronized void close() {
        super.close();
        this.rof = null;
        this.rs = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResults() {
        if (this.rs != null) {
            try {
                Statement stmt = null;
                try {
                    stmt = this.rs.getStatement();
                    this.rs.close();
                }
                catch (SQLException e) {
                    NucleusLogger.DATASTORE.error((Object)LOCALISER.msg("052605", (Object)e));
                }
                finally {
                    try {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                    catch (SQLException sQLException) {}
                }
            }
            finally {
                this.rs = null;
            }
        }
    }

    public int hashCode() {
        if (this.rs != null) {
            return this.rs.hashCode();
        }
        if (this.query != null) {
            return this.query.hashCode();
        }
        return StringUtils.toJVMIDString((Object)((Object)this)).hashCode();
    }
}

