/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.pentaho.platform.api.engine.IActionSequence;
import org.pentaho.platform.api.engine.IFileFilter;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPermissionMask;
import org.pentaho.platform.api.engine.IPermissionRecipient;
import org.pentaho.platform.api.engine.ISolutionFile;
import org.pentaho.platform.api.engine.ISolutionFilter;
import org.pentaho.platform.api.engine.PentahoAccessControlException;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository.solution.SolutionRepositoryBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgileBISolutionRepository
extends SolutionRepositoryBase {
    private static final long serialVersionUID = -1174699308144524442L;

    public int publish(String baseUrl, String path, String fileName, byte[] data, boolean overwrite) throws PentahoAccessControlException {
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        if (path.startsWith("/") && path.contains(":")) {
            path = path.substring(1);
        }
        File f = new File(path, fileName);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(f);
            fos.write(data);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 2;
        }
        return 3;
    }

    private File getFile(String solutionPath) {
        if (solutionPath.startsWith("system/")) {
            String filePath = PentahoSystem.getApplicationContext().getSolutionPath(solutionPath);
            File file = new File(filePath);
            return file;
        }
        File file = new File(solutionPath);
        return file;
    }

    public boolean resourceExists(String solutionPath, int actionOperation) {
        return this.getFile(solutionPath).exists();
    }

    public InputStream getResourceInputStream(String solutionPath, boolean getLocalizedResource, int actionOperation) throws FileNotFoundException {
        return new FileInputStream(this.getFile(solutionPath));
    }

    protected ISolutionFile getLocalizedFile(ISolutionFile resourceFile, int actionOperation) {
        return resourceFile;
    }

    protected ISolutionFile getFileByPath(String path, int actionOperation) {
        File file = this.getFile(path);
        if (file.exists()) {
            return new AgileBISolutionFile(file);
        }
        return null;
    }

    public void addPermission(ISolutionFile file, IPermissionRecipient recipient, IPermissionMask permission) {
        throw new UnsupportedOperationException();
    }

    public IActionSequence getActionSequence(String solutionName, String actionPath, String actionName, int loggingLevel, int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public String[] getAllActionSequences(int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public ClassLoader getClassLoader(String path) {
        throw new UnsupportedOperationException();
    }

    public Map<IPermissionRecipient, IPermissionMask> getEffectivePermissions(ISolutionFile file) {
        throw new UnsupportedOperationException();
    }

    public Map<IPermissionRecipient, IPermissionMask> getPermissions(ISolutionFile file) {
        throw new UnsupportedOperationException();
    }

    public String getRepositoryName() {
        throw new UnsupportedOperationException();
    }

    public long getSolutionFileLastModified(String path, int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public Document getSolutionStructure(int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public Document getSolutionTree(int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public Document getSolutionTree(int actionOperation, ISolutionFilter filter) {
        throw new UnsupportedOperationException();
    }

    public Document getSolutions(String solutionName, String pathName, int actionOperation, boolean visibleOnly) {
        throw new UnsupportedOperationException();
    }

    public boolean hasAccess(ISolutionFile file, int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public int publish(String baseUrl, String path, String fileName, File f, boolean overwrite) throws PentahoAccessControlException {
        throw new UnsupportedOperationException();
    }

    public void reloadSolutionRepository(IPentahoSession session, int loggingLevel) {
        throw new UnsupportedOperationException();
    }

    public long resourceSize(String solutionPath, int actionOperation) {
        throw new UnsupportedOperationException();
    }

    public void setPermissions(ISolutionFile file, Map<IPermissionRecipient, IPermissionMask> acl) throws PentahoAccessControlException {
        throw new UnsupportedOperationException();
    }

    public void share(ISolutionFile file, List<IPermissionRecipient> shareRecipients) {
        throw new UnsupportedOperationException();
    }

    public boolean solutionSynchronizationSupported() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsAccessControls() {
        throw new UnsupportedOperationException();
    }

    public boolean synchronizeSolutionWithSolutionSource(IPentahoSession session) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    static class AgileBISolutionFile
    implements ISolutionFile {
        File file = null;

        public AgileBISolutionFile(File file) {
            this.file = file;
        }

        public boolean exists() {
            return this.file.exists();
        }

        public byte[] getData() {
            try {
                return IOUtils.toByteArray((InputStream)new FileInputStream(this.file));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public String getExtension() {
            throw new UnsupportedOperationException();
        }

        public String getFileName() {
            throw new UnsupportedOperationException();
        }

        public String getFullPath() {
            throw new UnsupportedOperationException();
        }

        public long getLastModified() {
            throw new UnsupportedOperationException();
        }

        public String getSolution() {
            throw new UnsupportedOperationException();
        }

        public String getSolutionPath() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public boolean isRoot() {
            throw new UnsupportedOperationException();
        }

        public ISolutionFile[] listFiles() {
            throw new UnsupportedOperationException();
        }

        public ISolutionFile[] listFiles(IFileFilter filter) {
            throw new UnsupportedOperationException();
        }

        public ISolutionFile retrieveParent() {
            throw new UnsupportedOperationException();
        }
    }
}

