/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.pentaho.agilebi.platform.IInstaviewHelper;
import org.pentaho.agilebi.platform.InstaviewHelper;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.util.ThinModelConverter;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.data.DatasourceServiceException;
import org.pentaho.platform.api.data.IDatasourceService;

public class InstaviewDatasourceService
implements IDatasourceService {
    private GenericObjectPool gPool = new GenericObjectPool();
    private KeyedObjectPoolFactory kopf = new GenericKeyedObjectPoolFactory(null, 8);
    private Set<String> knownPools = new HashSet<String>();
    private int connectionCount = 0;
    private Map<String, DatabaseMeta> databaseMetaMap = new HashMap<String, DatabaseMeta>();

    public void clearCache() {
    }

    public void clearDataSource(String dsName) {
    }

    public String getDSBoundName(String dsName) throws DatasourceServiceException {
        return dsName;
    }

    public String getDSUnboundName(String dsName) {
        return dsName;
    }

    public DataSource getDataSource(String dsName) throws DatasourceServiceException {
        DatabaseMeta databaseMeta = this.databaseMetaMap.get(dsName);
        if (this.knownPools.contains(dsName)) {
            try {
                DatabaseMetaDataSource dataSource = new DatabaseMetaDataSource(dsName);
                return dataSource;
            }
            catch (Exception e) {
                throw new DatasourceServiceException((Throwable)e);
            }
        }
        Domain domain = null;
        try {
            XmiParser parser = new XmiParser();
            FileInputStream fis = new FileInputStream(new File(dsName));
            domain = parser.parseXmi((InputStream)fis);
        }
        catch (Exception e) {
            throw new DatasourceServiceException((Throwable)e);
        }
        if (domain.getPhysicalModels().size() == 0 || !(domain.getPhysicalModels().get(0) instanceof SqlPhysicalModel)) {
            throw new DatasourceServiceException("No SQL Physical Model Available");
        }
        SqlPhysicalModel model = (SqlPhysicalModel)domain.getPhysicalModels().get(0);
        databaseMeta = ThinModelConverter.convertToLegacy((String)model.getId(), (SqlDataSource)model.getDatasource());
        DatabaseMetaConnectionFactory cf = new DatabaseMetaConnectionFactory(databaseMeta);
        GenericObjectPool.Config config = new GenericObjectPool.Config();
        config.testOnBorrow = true;
        this.gPool.setConfig(config);
        PoolableConnectionFactory pcf = new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)this.gPool, this.kopf, "select 1", false, true);
        try {
            PoolingDriver pd = new PoolingDriver();
            pd.registerPool(dsName, (ObjectPool)this.gPool);
            for (int i = 0; i < 5; ++i) {
                this.gPool.addObject();
            }
        }
        catch (Exception e) {
            throw new DatasourceServiceException((Throwable)e);
        }
        Database database = new Database(databaseMeta);
        try {
            database.connect();
        }
        catch (Exception e) {
            throw new DatasourceServiceException((Throwable)e);
        }
        Connection connection = database.getConnection();
        this.knownPools.add(dsName);
        this.databaseMetaMap.put(dsName, databaseMeta);
        return new DatabaseMetaDataSource(dsName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DatabaseMetaDataSource
    implements DataSource {
        DatabaseMeta databaseMeta;
        Connection connection;
        String dsName;

        public DatabaseMetaDataSource(String dsName) {
            this.dsName = dsName;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection connection = DriverManager.getConnection("jdbc:apache:commons:dbcp:" + this.dsName);
            return connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return null;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }
    }

    class DatabaseMetaConnectionFactory
    implements ConnectionFactory {
        DatabaseMeta databaseMeta;

        public DatabaseMetaConnectionFactory(DatabaseMeta databaseMeta) {
            this.databaseMeta = databaseMeta;
        }

        public Connection createConnection() throws SQLException {
            Database database = new Database(this.databaseMeta);
            try {
                database.connect();
                InstaviewDatasourceService.this.connectionCount++;
                IInstaviewHelper instaviewHelper = InstaviewHelper.getInstaviewHelper();
                if (instaviewHelper != null) {
                    instaviewHelper.connectionMade();
                }
                Connection connection = database.getConnection();
                return connection;
            }
            catch (KettleException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
        }
    }
}

