/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.platform;

import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.webapp.WebAppContext;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;

public class JettyServer {
    private static Class<?> PKG = JettyServer.class;
    private static LogChannelInterface log = new LogChannel((Object)JettyServer.class.toString());
    public static final int PORT = 80;
    private Server server;
    private String hostname;
    private int port;
    private String webappsFolder = "plugins/spoon/agile-bi/platform/webapps";

    public JettyServer(String hostname, int port) throws Exception {
        this.hostname = hostname;
        this.port = port;
    }

    public void setWebappsFolder(String webappsFolder) {
        this.webappsFolder = webappsFolder;
    }

    public Server getServer() {
        return this.server;
    }

    public void startServer() throws Exception {
        this.server = new Server();
        WebAppContext pentahoContext = new WebAppContext();
        pentahoContext.setClassLoader(this.getClass().getClassLoader());
        pentahoContext.setContextPath("/pentaho");
        pentahoContext.setWar(this.webappsFolder + "/pentaho");
        pentahoContext.setParentLoaderPriority(true);
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{pentahoContext, new DefaultHandler()});
        this.server.setHandler((Handler)handlers);
        this.createListeners();
        this.server.start();
    }

    protected void setupListeners() {
    }

    public void stopServer() {
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        catch (Exception e) {
            log.logError("WebServer.Error.FailedToStop.Title", (Throwable)e);
        }
    }

    private void createListeners() {
        SocketConnector connector = new SocketConnector();
        connector.setPort(this.port);
        connector.setHost(this.hostname);
        connector.setName(this.hostname);
        log.logBasic("WebServer.Log.CreateListener " + this.hostname + ":" + this.port);
        this.server.setConnectors(new Connector[]{connector});
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }
}

