/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.util.AbstractXulDialogController;
import org.slf4j.Logger;

public abstract class AbstractSwtXulDialogController
extends AbstractXulDialogController {
    private XulRunner runner;
    private XulDomContainer container;
    private XulDialog xulDialog;
    private Composite swtDialog;
    private Shell shell;

    protected AbstractSwtXulDialogController(Shell shell) {
        this.shell = shell;
    }

    public void initDialogController(String xulPath, String dialogId, XulEventHandler eventHandler, String perspective) throws XulException {
        SwtXulLoader loader = new SwtXulLoader();
        loader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
        loader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
        loader.setOuterContext((Object)this.shell);
        this.container = loader.loadXul(xulPath);
        if (eventHandler != null) {
            this.container.addEventHandler(eventHandler);
        } else {
            this.container.addEventHandler((XulEventHandler)this);
        }
        this.runner = new SwtXulRunner();
        this.runner.addContainer(this.container);
        this.xulDialog = (XulDialog)this.container.getDocumentRoot().getRootElement().getElementById(dialogId);
        this.swtDialog = (Composite)this.container.getDocumentRoot().getRootElement().getElementById(dialogId).getManagedObject();
        this.runner.initialize();
        if (perspective != null) {
            this.container.loadPerspective(perspective);
        }
    }

    public XulDialog getDialog() {
        return this.xulDialog;
    }

    public Composite getComposite() {
        return this.swtDialog;
    }

    public abstract Logger getLogger();

    public XulDomContainer getContainer() {
        return this.container;
    }

    protected abstract void init();

    public Shell getShell() {
        return this.shell;
    }

    public void setShell(Shell shell) {
        this.shell = shell;
    }
}

