/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon;

import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceUtil;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.agilebi.spoon.ModelerHelper;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.VisualizationManager;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.ui.core.database.dialog.XulDatabaseExplorerController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.xul.swt.tab.TabItem;

public class AgileBiDatabaseController
extends AbstractXulEventHandler {
    private static final String MODELER_NAME = "Modeler";
    private XulDatabaseExplorerController dbExplorerController;

    private String getUniqueUntitledTabName(Spoon spoon, String title) {
        int num = 1;
        String tabName = title + " " + num;
        TabItem tabItem = spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.BROWSER).getTabItem();
        while (tabItem != null) {
            tabName = title + " " + ++num;
            tabItem = spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.BROWSER).getTabItem();
        }
        return tabName;
    }

    public void openModeler() {
        this.getDbController();
        this.dbExplorerController.close();
        TableModelerSource source = new TableModelerSource(this.dbExplorerController.getDatabaseMeta(), this.dbExplorerController.getSelectedTable(), this.dbExplorerController.getSelectedSchema());
        try {
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            ModelerWorkspaceUtil.populateModelFromSource((ModelerWorkspace)model, (IModelerSource)source);
            AgileBiModelerPerspective.getInstance().createTabForModel(model, MODELER_NAME);
        }
        catch (Exception e) {
            e.printStackTrace();
            SpoonFactory.getInstance().messageBox("Could not create a modeler: " + e.getLocalizedMessage(), "Modeler Error", false, 2);
        }
    }

    public void quickVisualize() {
        this.getDbController();
        this.dbExplorerController.close();
        TableModelerSource source = new TableModelerSource(this.dbExplorerController.getDatabaseMeta(), this.dbExplorerController.getSelectedTable(), this.dbExplorerController.getSelectedSchema() == null ? "" : this.dbExplorerController.getSelectedSchema());
        if (source.getSchemaName() == null) {
            source.setSchemaName("");
        }
        try {
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            ModelerWorkspaceUtil.populateModelFromSource((ModelerWorkspace)model, (IModelerSource)source);
            this.quickVisualize(model, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            SpoonFactory.getInstance().messageBox("Could not create a modeler: " + e.getLocalizedMessage(), "Modeler Error", false, 2);
        }
    }

    public void quickVisualize(ModelerWorkspace model, boolean autoModel) throws ModelerException {
        ModelerHelper theHelper = ModelerHelper.getInstance();
        theHelper.createTemporaryModel(model, true, autoModel);
        VisualizationManager theManager = VisualizationManager.getInstance();
        IVisualization theVisualization = theManager.getVisualization(theManager.getVisualizationNames().get(0));
        if (theVisualization != null) {
            if (model.getFileName() != null) {
                theVisualization.createVisualizationFromModel(model, true);
            } else {
                throw new UnsupportedOperationException("TODO: prompt to save model before visualization");
            }
        }
    }

    public String getName() {
        return "agilebi_database";
    }

    private XulDatabaseExplorerController getDbController() {
        if (this.dbExplorerController == null) {
            try {
                this.dbExplorerController = (XulDatabaseExplorerController)this.getXulDomContainer().getEventHandler("dbexplorer");
            }
            catch (XulException e) {
                e.printStackTrace();
            }
        }
        return this.dbExplorerController;
    }

    public void setData(Object aDatabaseDialog) {
        this.dbExplorerController = (XulDatabaseExplorerController)aDatabaseDialog;
    }
}

