/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon;

import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.util.ModelerSourceUtil;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.Type;
import org.pentaho.metadata.registry.Verb;
import org.pentaho.metadata.registry.util.RegistryUtil;

public class KettleModelerSource
extends TableModelerSource {
    public static final String SOURCE_TYPE = KettleModelerSource.class.getSimpleName();
    public static final String EMPTY_STRING = "";
    private static RegistryUtil UTIL = new RegistryUtil();
    private String metaName;
    private Type metaType;
    private String filename;
    private String repositoryName;
    private String metaId;

    public KettleModelerSource() {
    }

    public KettleModelerSource(DatabaseMeta databaseMeta, String tableName, String schemaName, Type metaType, String metaName, String filename, String repositoryName, String metaId) {
        super(databaseMeta, tableName, schemaName);
        if (metaName == null) {
            throw new NullPointerException("metaName is required");
        }
        if (metaId == null) {
            throw new NullPointerException("metaId is required");
        }
        this.setMetaType(metaType);
        this.metaName = metaName;
        this.filename = filename;
        this.repositoryName = repositoryName;
        this.metaId = metaId;
    }

    protected String getFilenamePropertyName() {
        return "enginemeta_filename";
    }

    protected String getRepositoryNamePropertyName() {
        return "enginemeta_repositoryName";
    }

    protected String getMetaIdPropertyName() {
        return "enginemeta_id";
    }

    public String getSourceTypePropertyName() {
        return "source_type";
    }

    public String getSourceType() {
        return SOURCE_TYPE;
    }

    public Domain generateDomain() throws ModelerException {
        Domain d = ModelerSourceUtil.generateDomain((DatabaseMeta)this.getDatabaseMeta(), (String)this.getSchemaName(), (String)this.getTableName());
        for (LogicalModel lModel : d.getLogicalModels()) {
            lModel.setProperty("SUPPORTS_OLAP", (Object)Boolean.TRUE.toString());
        }
        return d;
    }

    public void initialize(Domain domain) throws ModelerException {
        super.initialize(domain);
        LogicalModel lm = (LogicalModel)domain.getLogicalModels().get(0);
        if (lm.getProperty(this.getFilenamePropertyName()) != null) {
            this.setFilename(lm.getProperty(this.getFilenamePropertyName()).toString());
        }
        if (lm.getProperty(this.getRepositoryNamePropertyName()) != null) {
            this.setRepositoryName(lm.getProperty(this.getRepositoryNamePropertyName()).toString());
        }
        if (lm.getProperty(this.getMetaIdPropertyName()) != null) {
            this.setMetaId(lm.getProperty(this.getMetaIdPropertyName()).toString());
        }
    }

    public void serializeIntoDomain(Domain d) {
        LogicalModel lm = (LogicalModel)d.getLogicalModels().get(0);
        lm.setProperty(this.getSourceTypePropertyName(), (Object)this.getSourceType());
        lm.setProperty(this.getFilenamePropertyName(), (Object)Const.NVL((String)this.getFilename(), (String)EMPTY_STRING));
        lm.setProperty(this.getRepositoryNamePropertyName(), (Object)Const.NVL((String)this.getRepositoryName(), (String)EMPTY_STRING));
        lm.setProperty(this.getMetaIdPropertyName(), (Object)Const.NVL((String)this.getMetaId(), (String)EMPTY_STRING));
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        if (repositoryName != null && repositoryName.equals(EMPTY_STRING)) {
            repositoryName = null;
        }
        this.repositoryName = repositoryName;
    }

    public String getMetaId() {
        return this.metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public String getMetaName() {
        return this.metaName;
    }

    public void setMetaName(String metaName) {
        this.metaName = metaName;
    }

    public Type getMetaType() {
        return this.metaType;
    }

    public void setMetaType(Type metaType) {
        if (metaType != Type.TYPE_TRANSFORMATION && metaType != Type.TYPE_JOB) {
            throw new IllegalArgumentException("unsupported type");
        }
        this.metaType = metaType;
    }

    public void registerLineageMetadata(IMetadataRegistry registry) {
        Entity meta = new Entity(UTIL.generateCompositeId(new String[]{this.getRepositoryName(), this.getFilename()}), this.getMetaName(), this.getMetaType().getId());
        Entity table = new Entity(UTIL.generateCompositeId(new String[]{this.getDatabaseName(), this.getSchemaName(), this.getTableName()}), this.getTableName(), Type.TYPE_PHYSICAL_TABLE.getId());
        Link link = new Link(meta, Verb.VERB_POPULATES, table);
        registry.addEntity(table);
        registry.addEntity(meta);
        registry.addLink(link);
    }
}

