/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.widgets.Display;
import org.pentaho.agilebi.modeler.IModelerMessages;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceUtil;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.agilebi.spoon.KettleModelerSource;
import org.pentaho.agilebi.spoon.OutputStepModelerSource;
import org.pentaho.agilebi.spoon.SpoonModelerMessages;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.VisualizationManager;
import org.pentaho.agilebi.spoon.wizard.EmbeddedWizard;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.ISpoonMenuController;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.OrderedFileRegistry;
import org.pentaho.metadata.registry.RegistryFactory;
import org.pentaho.metadata.registry.Type;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.components.WaitBoxRunnable;
import org.pentaho.ui.xul.components.XulWaitBox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.xul.swt.tab.TabItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelerHelper
extends AbstractXulEventHandler
implements ISpoonMenuController {
    private static final String MODELER_NAME = "Modeler";
    private static final String TEMP_MODELS_FOLDER = "models";
    private static ModelerHelper instance = null;
    private static Logger logger = LoggerFactory.getLogger(ModelerHelper.class);

    private ModelerHelper() {
        File modelsDir = new File(TEMP_MODELS_FOLDER);
        if (modelsDir.exists()) {
            for (File file : modelsDir.listFiles()) {
                file.delete();
            }
            modelsDir.delete();
        }
    }

    public static ModelerHelper getInstance() {
        if (instance == null) {
            instance = new ModelerHelper();
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            spoon.addSpoonMenuController((ISpoonMenuController)instance);
        }
        return instance;
    }

    public static boolean isValidEntrySelected() {
        return ModelerHelper.getDatabaseConnectionInformationForCurrentActiveEntry() != null;
    }

    public static boolean isValidConnectionInformation(DatabaseMeta meta, String tableName) {
        return meta != null && !Const.isEmpty((String)tableName);
    }

    private static boolean isValidEntrySelectedWithLogging() {
        if (!ModelerHelper.isValidEntrySelected()) {
            ModelerHelper.showFriendlyModelerException(new ModelerException(BaseMessages.getString(ModelerHelper.class, (String)"InvalidEntrySelected", (String[])new String[0])));
            return false;
        }
        return true;
    }

    private static ProvidesDatabaseConnectionInformation getDatabaseConnectionInformationForCurrentActiveEntry() {
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        EngineMetaInterface metaInterface = spoon.getActiveMeta();
        ProvidesDatabaseConnectionInformation connectionInfo = null;
        if (metaInterface != null) {
            if (metaInterface instanceof TransMeta) {
                connectionInfo = ModelerHelper.getDatabaseConnectionInformationForCurrentTransStep(spoon);
            } else if (metaInterface instanceof JobMeta) {
                connectionInfo = ModelerHelper.getDatabaseConnectionInformationForJobEntry(spoon);
            }
        }
        return connectionInfo;
    }

    protected static StepMeta getCurrentStepMeta(Spoon spoon) {
        if (spoon.getActiveTransGraph() == null) {
            return null;
        }
        return spoon.getActiveTransGraph().getCurrentStep();
    }

    protected static JobEntryCopy getCurrentJobEntry(Spoon spoon) {
        if (spoon.getActiveJobGraph() == null) {
            return null;
        }
        return spoon.getActiveJobGraph().getJobEntry();
    }

    protected static ProvidesDatabaseConnectionInformation getDatabaseConnectionInformationForCurrentTransStep(Spoon spoon) {
        StepMeta stepMeta = ModelerHelper.getCurrentStepMeta(spoon);
        return stepMeta == null ? null : ModelerHelper.getDatabaseConnectionInformation(stepMeta.getStepMetaInterface());
    }

    protected static ProvidesDatabaseConnectionInformation getDatabaseConnectionInformationForJobEntry(Spoon spoon) {
        JobEntryCopy entry = ModelerHelper.getCurrentJobEntry(spoon);
        return entry == null ? null : ModelerHelper.getDatabaseConnectionInformation(entry.getEntry());
    }

    protected static KettleModelerSource createSourceForActiveSelection(ProvidesDatabaseConnectionInformation connectionInfo, Spoon spoon) {
        EngineMetaInterface metaInterface = spoon.getActiveMeta();
        KettleModelerSource source = null;
        if (metaInterface != null) {
            if (metaInterface instanceof TransMeta) {
                source = ModelerHelper.getModelerSourceForCurrentTransStep(connectionInfo, spoon);
            } else if (metaInterface instanceof JobMeta) {
                source = ModelerHelper.getModelerSourceForCurrentJobEntry(connectionInfo, spoon);
            }
        }
        return source;
    }

    protected static KettleModelerSource getModelerSourceForCurrentTransStep(ProvidesDatabaseConnectionInformation connectionInfo, Spoon spoon) {
        StepMeta stepMeta = ModelerHelper.getCurrentStepMeta(spoon);
        if (stepMeta == null) {
            return null;
        }
        return ModelerHelper.getModelerSourceForStepMeta(connectionInfo, spoon.getActiveTransformation(), stepMeta);
    }

    protected static KettleModelerSource getModelerSourceForStepMeta(ProvidesDatabaseConnectionInformation connectionInfo, TransMeta transMeta, StepMeta stepMeta) {
        Repository repository = transMeta.getRepository();
        String repositoryName = repository == null ? null : repository.getName();
        return new OutputStepModelerSource(connectionInfo.getDatabaseMeta(), connectionInfo.getTableName(), connectionInfo.getSchemaName(), transMeta.getName(), transMeta.getFilename(), repositoryName, stepMeta.getStepID());
    }

    protected static KettleModelerSource getModelerSourceForCurrentJobEntry(ProvidesDatabaseConnectionInformation connectionInfo, Spoon spoon) {
        JobEntryCopy entry = ModelerHelper.getCurrentJobEntry(spoon);
        if (entry == null) {
            return null;
        }
        return ModelerHelper.getModelerSourceForJobEntry(connectionInfo, spoon.getActiveJob(), entry);
    }

    protected static KettleModelerSource getModelerSourceForJobEntry(ProvidesDatabaseConnectionInformation connectionInfo, JobMeta jobMeta, JobEntryCopy entry) {
        Repository repository = jobMeta.getRepository();
        String repositoryName = repository == null ? null : repository.getName();
        return new KettleModelerSource(connectionInfo.getDatabaseMeta(), connectionInfo.getTableName(), connectionInfo.getSchemaName(), Type.TYPE_JOB, jobMeta.getName(), jobMeta.getFilename(), repositoryName, entry.getEntry().getPluginId());
    }

    protected static ProvidesDatabaseConnectionInformation getDatabaseConnectionInformation(Object o) {
        if (o != null && ProvidesDatabaseConnectionInformation.class.isAssignableFrom(o.getClass())) {
            return (ProvidesDatabaseConnectionInformation)ProvidesDatabaseConnectionInformation.class.cast(o);
        }
        return null;
    }

    public static ModelerWorkspace populateModel(ModelerWorkspace model) throws ModelerException {
        if (!ModelerHelper.isValidEntrySelected()) {
            throw new ModelerException(BaseMessages.getString(ModelerHelper.class, (String)"InvalidEntrySelected", (String[])new String[0]));
        }
        ProvidesDatabaseConnectionInformation connectionInfo = ModelerHelper.getDatabaseConnectionInformationForCurrentActiveEntry();
        if (!ModelerHelper.isValidConnectionInformation(connectionInfo.getDatabaseMeta(), connectionInfo.getTableName())) {
            String errorMsg = Const.NVL((String)connectionInfo.getMissingDatabaseConnectionInformationMessage(), (String)BaseMessages.getString(ModelerHelper.class, (String)"DatabaseConnectionInformationRequired", (String[])new String[0]));
            throw new ModelerException(errorMsg);
        }
        KettleModelerSource source = ModelerHelper.createSourceForActiveSelection(connectionInfo, (Spoon)SpoonFactory.getInstance());
        if (source == null) {
            throw new ModelerException(BaseMessages.getString(ModelerHelper.class, (String)"Error.NoModelerSource", (String[])new String[]{connectionInfo.getDatabaseMeta().getName(), connectionInfo.getTableName()}));
        }
        Domain d = source.generateDomain();
        model.setModelSource((IModelerSource)source);
        model.setModelName(connectionInfo.getTableName());
        model.setDomain(d);
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        source.registerLineageMetadata(registry);
        try {
            registry.commit();
        }
        catch (Exception e) {
            logger.error("Could not commit metadata registry", (Throwable)e);
        }
        return model;
    }

    public void createModelerTab() throws ModelerException {
        ModelerWorkspace model = this.createModelerWorkspace();
        ModelerHelper.populateModel(model);
        AgileBiModelerPerspective.getInstance().createTabForModel(model, MODELER_NAME);
    }

    public void createModelerTabFromSource(IModelerSource source) throws ModelerException {
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        ModelerWorkspace model = this.createModelerWorkspace();
        model.setModelSource(source);
        ModelerWorkspaceUtil.populateModelFromSource((ModelerWorkspace)model, (IModelerSource)source);
        AgileBiModelerPerspective.getInstance().createTabForModel(model, this.getUniqueUntitledTabName(spoon, MODELER_NAME));
    }

    public Domain loadDomain(String fname) {
        try {
            ModelerWorkspace model = this.createModelerWorkspace();
            String xml = new String(IOUtils.toByteArray((InputStream)new FileInputStream(new File(fname))), "UTF-8");
            ModelerWorkspaceUtil.loadWorkspace((String)fname, (String)xml, (ModelerWorkspace)model);
            return model.getDomain();
        }
        catch (ModelerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getUniqueUntitledTabName(Spoon spoon, String title) {
        int num = 1;
        String tabName = title + " " + num;
        TabItem tabItem = spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.BROWSER).getTabItem();
        while (tabItem != null) {
            tabName = title + " " + ++num;
            tabItem = spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.BROWSER).getTabItem();
        }
        return tabName;
    }

    public String getName() {
        return "agileBi";
    }

    public void openModeler() {
        if (!ModelerHelper.isValidEntrySelectedWithLogging()) {
            return;
        }
        try {
            ModelerHelper.getInstance().createModelerTab();
            SpoonPerspectiveManager.getInstance().activatePerspective(AgileBiModelerPerspective.class);
        }
        catch (ModelerException e) {
            ModelerHelper.showFriendlyModelerException(e);
        }
        catch (Exception e) {
            logger.error("Error opening modeler", (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating modeler", e);
        }
    }

    public void quickVisualizeTable() {
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        if (spoon.getSelectionObject() instanceof DatabaseMeta) {
            DatabaseMeta databaseMeta = (DatabaseMeta)spoon.getSelectionObject();
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(spoon.getShell(), 0, databaseMeta, new ArrayList());
            if (std.open()) {
                TableModelerSource source = new TableModelerSource(databaseMeta, std.getTableName(), std.getSchemaName() == null ? "" : std.getSchemaName());
                if (source.getSchemaName() == null) {
                    source.setSchemaName("");
                }
                try {
                    ModelerWorkspace model = this.createModelerWorkspace();
                    ModelerWorkspaceUtil.populateModelFromSource((ModelerWorkspace)model, (IModelerSource)source);
                    this.quickVisualize(model);
                }
                catch (Exception e) {
                    logger.error("Error opening visualization", (Throwable)e);
                    new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error executing Quick Visualize", e);
                }
            }
        }
    }

    public void quickVisualizeTableOutputStep() {
        if (!ModelerHelper.isValidEntrySelectedWithLogging()) {
            return;
        }
        try {
            ModelerWorkspace model = this.createModelerWorkspace();
            ModelerHelper.populateModel(model);
            this.quickVisualize(model);
        }
        catch (ModelerException e) {
            ModelerHelper.showFriendlyModelerException(e);
        }
        catch (Exception e) {
            logger.error("Error visualizing", (Throwable)e);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", e);
        }
    }

    private static void showFriendlyModelerException(ModelerException e) {
        logger.error(e.getMessage());
        SpoonFactory.getInstance().messageBox(e.getMessage(), MODELER_NAME, false, 2);
    }

    public void reportWizard() {
        if (!ModelerHelper.isValidEntrySelectedWithLogging()) {
            return;
        }
        try {
            XulWaitBox box = (XulWaitBox)this.document.createElement("waitbox");
            box.setIndeterminate(true);
            box.setCanCancel(false);
            box.setTitle(BaseMessages.getString(ModelerWorkspace.class, (String)"wait_dialog_title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(ModelerWorkspace.class, (String)"wait_dialog_message", (String[])new String[0]));
            box.setCancelLabel(BaseMessages.getString(ModelerWorkspace.class, (String)"wait_dialog_btn", (String[])new String[0]));
            box.setDialogParent((Object)((Spoon)SpoonFactory.getInstance()).getShell());
            box.setRunnable(new WaitBoxRunnable(box){
                boolean canceled;
                {
                    this.canceled = false;
                }

                public void run() {
                    try {
                        ModelerWorkspace model = ModelerHelper.this.createModelerWorkspace();
                        ModelerHelper.populateModel(model);
                        ObjectUtilities.setClassLoader((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        ObjectUtilities.setClassLoaderSource((String)"ClassContext");
                        if (!ClassicEngineBoot.getInstance().isBootDone()) {
                            ClassicEngineBoot engineBoot = ClassicEngineBoot.getInstance();
                            engineBoot.start();
                        }
                        ModelerHelper.this.createTemporaryModel(model, true, true);
                        EmbeddedWizard wizard = new EmbeddedWizard(model, true);
                        this.waitBox.stop();
                        wizard.run(null);
                    }
                    catch (ModelerException e) {
                        logger.error("Error booting reporting engine", (Throwable)e);
                        ModelerHelper.showFriendlyModelerException(e);
                    }
                    catch (Exception e) {
                        logger.error("Error booting reporting engine", (Throwable)e);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", e);
                            }
                        });
                    }
                    this.waitBox.stop();
                }

                public void cancel() {
                    this.canceled = true;
                }
            });
            box.start();
        }
        catch (XulException e1) {
            logger.error("error creating PRPT", (Throwable)e1);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", (Exception)((Object)e1));
        }
    }

    public void quickVisualize(ModelerWorkspace model, String name, String fileName) throws ModelerException {
        this.createTemporaryModel(model, true, true);
        VisualizationManager theManager = VisualizationManager.getInstance();
        IVisualization theVisualization = theManager.getVisualization(theManager.getVisualizationNames().get(0));
        if (theVisualization != null) {
            if (model.getFileName() != null) {
                theVisualization.createVisualizationFromModel(model, true);
                Spoon.getInstance().enableMenus();
            } else {
                throw new UnsupportedOperationException("TODO: prompt to save model before visualization");
            }
        }
    }

    public void quickVisualize(ModelerWorkspace model) throws ModelerException {
        this.createTemporaryModel(model, true, true);
        VisualizationManager theManager = VisualizationManager.getInstance();
        IVisualization theVisualization = theManager.getVisualization(theManager.getVisualizationNames().get(0));
        if (theVisualization != null) {
            if (model.getFileName() != null) {
                theVisualization.createVisualizationFromModel(model, true);
                Spoon.getInstance().enableMenus();
            } else {
                throw new UnsupportedOperationException("TODO: prompt to save model before visualization");
            }
        }
    }

    public String createTemporaryModel(ModelerWorkspace model, boolean saveName, boolean autoModel) throws ModelerException {
        File modelsDir = new File(TEMP_MODELS_FOLDER);
        modelsDir.mkdirs();
        int idx = 1;
        boolean looking = true;
        String fileName = "";
        String modelName = "";
        while (looking) {
            modelName = "Model " + idx;
            fileName = "models/" + modelName + ".xmi";
            File modelFile = new File(fileName);
            if (!modelFile.exists()) {
                looking = false;
            }
            ++idx;
        }
        if (saveName) {
            model.setFileName(fileName);
        }
        model.setModelName(modelName);
        if (autoModel) {
            model.getWorkspaceHelper().autoModelFlat(model);
        }
        model.getWorkspaceHelper().populateDomain(model);
        ModelerWorkspaceUtil.saveWorkspace((ModelerWorkspace)model, (String)fileName);
        return fileName;
    }

    public ModelerWorkspace clone(ModelerWorkspace model) throws ModelerException {
        String fileName = this.createTemporaryModel(model, false, false);
        ModelerWorkspace newModel = this.createModelerWorkspace();
        newModel.setTemporary(true);
        newModel.setDirty(false);
        try {
            String xml = new String(IOUtils.toByteArray((InputStream)new FileInputStream(new File(fileName))), "UTF-8");
            ModelerWorkspaceUtil.loadWorkspace((String)fileName, (String)xml, (ModelerWorkspace)newModel);
        }
        catch (Exception e) {
            throw new ModelerException((Throwable)e);
        }
        return newModel;
    }

    public void databaseModelItem() {
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        if (spoon.getSelectionObject() instanceof DatabaseMeta) {
            DatabaseMeta databaseMeta = (DatabaseMeta)spoon.getSelectionObject();
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(spoon.getShell(), 0, databaseMeta, new ArrayList());
            if (std.open()) {
                TableModelerSource source = new TableModelerSource(databaseMeta, std.getTableName(), std.getSchemaName());
                try {
                    ModelerWorkspace model = this.createModelerWorkspace();
                    ModelerWorkspaceUtil.populateModelFromSource((ModelerWorkspace)model, (IModelerSource)source);
                    AgileBiModelerPerspective.getInstance().createTabForModel(model, this.getUniqueUntitledTabName(spoon, MODELER_NAME));
                }
                catch (Exception e) {
                    logger.error("Error creating model", (Throwable)e);
                    new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating Modeler", e);
                }
            }
        }
    }

    public void createEmptyModel() {
        try {
            ModelerWorkspace model = this.createModelerWorkspace();
            AgileBiModelerPerspective.getInstance().createTabForModel(model, MODELER_NAME);
            SpoonPerspectiveManager.getInstance().activatePerspective(AgileBiModelerPerspective.class);
        }
        catch (Exception e) {
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", e);
        }
    }

    private ModelerWorkspace createModelerWorkspace() {
        return new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
    }

    public void updateMenu(Document doc) {
    }

    static {
        try {
            ModelerMessagesHolder.setMessages((IModelerMessages)new SpoonModelerMessages());
            RegistryFactory factory = RegistryFactory.getInstance();
            IMetadataRegistry registry = factory.getMetadataRegistry();
            if (registry == null) {
                try {
                    registry = new OrderedFileRegistry();
                    ((OrderedFileRegistry)registry).setFilePath(Const.getKettleDirectory() + File.separator + "registry.xml");
                    factory.setMetadataRegistry(registry);
                    registry.init();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }
}

