/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.modeler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerController;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerMode;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceUtil;
import org.pentaho.agilebi.modeler.util.TableModelerSource;
import org.pentaho.agilebi.spoon.OutputStepModelerSource;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.modeler.ModelerControllerDBRegistry;
import org.pentaho.agilebi.spoon.publish.PublisherHelper;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.VisualizationManager;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.MainSpoonPerspective;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDBDelegate;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.containers.XulEditpanel;
import org.pentaho.ui.xul.containers.XulVbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoonModelerController
extends ModelerController {
    private ModelerControllerDBRegistry databaseInterface = new ModelerControllerDBRegistry();
    private static Logger logger = LoggerFactory.getLogger(SpoonModelerController.class);
    private XulMenuList visualizationList;
    private List<String> visualizationNames;
    private Binding visualizationsBinding;
    private Binding datasourceButtonBinding;
    private XulEditpanel propPanel;

    public SpoonModelerController() {
        this(new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext()));
    }

    public SpoonModelerController(ModelerWorkspace work) {
        super(work);
        work.setGeoContext(SpoonModelerWorkspaceHelper.initGeoContext());
    }

    public void init() throws ModelerException {
        this.propPanel = (XulEditpanel)this.document.getElementById("propertiesPanel");
        this.visualizationList = (XulMenuList)this.document.getElementById("visualizationlist");
        this.bf.createBinding((Object)this.workspace, "selectedVisualization", (Object)this.visualizationList, "selectedItem", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.visualizationsBinding = this.bf.createBinding((Object)this, "visualizationNames", (Object)this.visualizationList, "elements", new BindingConvertor[0]);
        XulLabel sourceLabel = (XulLabel)this.document.getElementById("source_name");
        XulLabel relational_sourceLabel = (XulLabel)this.document.getElementById("relational_source_name");
        String tableName = "";
        this.bf.createBinding((Object)this.workspace, "sourceName", (Object)sourceLabel, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.workspace, "sourceName", (Object)relational_sourceLabel, "value", new BindingConvertor[0]);
        if (this.workspace.getModelSource() != null && this.workspace.getModelSource() instanceof OutputStepModelerSource) {
            List tables;
            DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.workspace.getModelSource()).getDatabaseMeta();
            List physicalModels = this.workspace.getDomain().getPhysicalModels();
            if (physicalModels != null && physicalModels.size() > 0 && (tables = ((IPhysicalModel)physicalModels.get(0)).getPhysicalTables()) != null && tables.size() > 0) {
                tableName = ((IPhysicalTable)tables.get(0)).getName("en_US");
            }
        } else if (this.workspace.getModelSource() != null && this.workspace.getModelSource() instanceof TableModelerSource) {
            tableName = this.workspace.getModelSource().getTableName();
        }
        if (StringUtils.isEmpty((String)tableName)) {
            tableName = ModelerMessagesHolder.getMessages().getString("ModelerController.Datasource", new String[0]);
        }
        this.datasourceButtonBinding = this.bf.createBinding((Object)this.workspace, "sourceName", (Object)this, "sourceNameForCheck", new BindingConvertor[0]);
        this.workspace.setSourceName(tableName);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.propPanel, "visible", (Object)this, "propVisible", new BindingConvertor[0]);
        try {
            this.datasourceButtonBinding.fireSourceChanged();
            this.visualizationsBinding.fireSourceChanged();
        }
        catch (Exception e) {
            throw new ModelerException((Throwable)e);
        }
        super.init();
        this.setModellingMode(ModelerMode.ANALYSIS_AND_REPORTING);
    }

    public void editDataSource() {
        try {
            Spoon theSpoon = Spoon.getInstance();
            Repository theRepository = theSpoon.getRepository();
            ArrayList theDatabases = new ArrayList();
            EngineMetaInterface theMeta = null;
            Object theDatabasesInterface = null;
            List thePerspectives = SpoonPerspectiveManager.getInstance().getPerspectives();
            for (SpoonPerspective thePerspective : thePerspectives) {
                if (!(thePerspective instanceof MainSpoonPerspective)) continue;
                theMeta = thePerspective.getActiveMeta();
                break;
            }
            theDatabasesInterface = theMeta != null ? (HasDatabasesInterface)theMeta : this.databaseInterface;
            if (theRepository != null) {
                TransMeta theTransMeta = new TransMeta();
                theRepository.readTransSharedObjects(theTransMeta);
                theDatabases.addAll(theTransMeta.getDatabases());
                theDatabasesInterface.setDatabases(theDatabases);
            } else {
                theDatabases.addAll(theDatabasesInterface.getDatabases());
            }
            String theSelectedTable = null;
            IModelerSource theModelerSource = this.workspace.getModelSource();
            if (theModelerSource != null) {
                theSelectedTable = theModelerSource.getDatabaseName();
            }
            int[] theSelectedIndexes = new int[1];
            String[] theNames = new String[theDatabases.size()];
            for (int i = 0; i < theDatabases.size(); ++i) {
                theNames[i] = ((DatabaseMeta)theDatabases.get(i)).getName();
                if (theSelectedTable == null || !theNames[i].equals(theSelectedTable)) continue;
                theSelectedIndexes[0] = i;
            }
            EnterSelectionDialog theDialog = new EnterSelectionDialog(theSpoon.getShell(), theNames, BaseMessages.getString(Spoon.class, (String)"Spoon.ExploreDB.SelectDB.Title", (String[])new String[0]), BaseMessages.getString(Spoon.class, (String)"Spoon.ExploreDB.SelectDB.Message", (String[])new String[0]), theDatabasesInterface);
            theDialog.setSelectedNrs(theSelectedIndexes);
            String theDBName = theDialog.open();
            if (theDBName != null) {
                SpoonDBDelegate theDelegate = new SpoonDBDelegate(theSpoon);
                DatabaseMeta theDBMeta = DatabaseMeta.findDatabase((List)theDatabasesInterface.getDatabases(), (String)theDBName);
                String[] theTableAndSchema = theDelegate.exploreDB(theDBMeta, false);
                if (StringUtils.isEmpty((String)theTableAndSchema[1])) {
                    MessageBox theMessageBox = new MessageBox(theSpoon.getShell(), 33);
                    theMessageBox.setText(BaseMessages.getString(Spoon.class, (String)"Spoon.Message.Warning.Warning", (String[])new String[0]));
                    theMessageBox.setMessage(BaseMessages.getString(ModelerWorkspace.class, (String)"Spoon.Message.Model.EmptyTable", (String[])new String[0]));
                    theMessageBox.open();
                    return;
                }
                boolean refresh = this.workspace.getAvailableTables().isEmpty();
                if (!StringUtils.isEmpty((String)theTableAndSchema[1]) && !this.workspace.getAvailableTables().isEmpty()) {
                    MessageBox theMessageBox = new MessageBox(theSpoon.getShell(), 296);
                    theMessageBox.setText(BaseMessages.getString(Spoon.class, (String)"Spoon.Message.Warning.Warning", (String[])new String[0]));
                    theMessageBox.setMessage(BaseMessages.getString(ModelerWorkspace.class, (String)"Spoon.Message.Model.Warning", (String[])new String[0]));
                    int theVal = theMessageBox.open();
                    refresh = theVal == 32;
                }
                if (refresh) {
                    TableModelerSource theSource = new TableModelerSource(theDBMeta, theTableAndSchema[1], theTableAndSchema[0]);
                    ModelerWorkspaceUtil.populateModelFromSource((ModelerWorkspace)this.workspace, (IModelerSource)theSource);
                    this.workspace.setSourceName(theTableAndSchema[1]);
                    this.datasourceButtonBinding.fireSourceChanged();
                    this.fireBindings();
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", e);
        }
    }

    public void visualize() throws ModelerException {
        try {
            this.openVisualizer();
        }
        catch (Exception e) {
            logger.info("Error visualizing", (Throwable)e);
            throw new ModelerException((Throwable)e);
        }
    }

    public void publish() throws ModelerException {
        String publishingFile = this.workspace.getFileName();
        int treeDepth = 0;
        DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.workspace.getModelSource()).getDatabaseMeta();
        boolean checkDatasources = true;
        boolean showServerSelection = true;
        boolean showFolders = true;
        boolean showCurrentFolder = false;
        String serverPathTemplate = "{path}/resources/metadata";
        String databaseName = PublisherHelper.getBiServerCompatibleDatabaseName(this.workspace.getDatabaseName());
        String extension = ".xmi";
        String filename = this.workspace.getModelName();
        this.workspace.getWorkspaceHelper().populateDomain(this.workspace);
        String fileName = PublisherHelper.publish(this.workspace, publishingFile, treeDepth, databaseMeta, filename, checkDatasources, false, showFolders, showCurrentFolder, serverPathTemplate, extension, databaseName);
        this.workspace.getModel().setName(fileName);
        this.workspace.setDirty(true);
    }

    public void setSourceNameForCheck(String name) {
        boolean isVisible = name == null || "".equals(name.toString()) || name.equals(ModelerMessagesHolder.getMessages().getString("ModelerController.Datasource", new String[0]));
        XulVbox messageBox = (XulVbox)this.document.getElementById("main_message");
        messageBox.setVisible(isVisible);
        XulComponent addFieldButton = this.document.getElementById("addField");
        addFieldButton.setDisabled(isVisible);
        this.document.getElementById("datasource_button").setVisible(isVisible);
        this.document.getElementById("relational_datasource_button").setVisible(isVisible);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void openVisualizer() {
        this.workspace.getModel().validateTree();
        if (!this.workspace.isValid()) {
            this.showValidationMessages();
            return;
        }
        try {
            VisualizationManager theManager = VisualizationManager.getInstance();
            IVisualization theVisualization = theManager.getVisualization(this.visualizationList.getSelectedItem());
            if (this.workspace.getFileName() == null) {
                theVisualization.createVisualizationFromModel(this.workspace, true);
            } else {
                theVisualization.createVisualizationFromModel(this.workspace, false);
            }
            Spoon.getInstance().enableMenus();
            if (theVisualization == null) return;
        }
        catch (Exception e) {
            logger.error("Error visualizing", (Throwable)e);
        }
    }

    public List<String> getVisualizationNames() {
        if (this.visualizationNames == null) {
            VisualizationManager theManager = VisualizationManager.getInstance();
            this.visualizationNames = theManager.getVisualizationNames();
        }
        return this.visualizationNames;
    }

    public boolean saveWorkspace(String fileName) throws ModelerException {
        this.workspace.getModel().validateTree();
        if (!this.workspace.isValid()) {
            this.showValidationMessages();
            return false;
        }
        ModelerWorkspaceUtil.saveWorkspace((ModelerWorkspace)this.workspace, (String)fileName);
        this.workspace.setFileName(fileName);
        this.workspace.setDirty(false);
        this.workspace.setTemporary(false);
        return true;
    }
}

