/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.perspective;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.spoon.PDIMessages;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPerspectiveListener;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulTab;
import org.pentaho.ui.xul.components.XulTabpanel;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.containers.XulTabpanels;
import org.pentaho.ui.xul.containers.XulTabs;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.pentaho.ui.xul.swt.tags.SwtTab;
import org.pentaho.ui.xul.util.XulDialogCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPerspective
extends AbstractXulEventHandler
implements SpoonPerspective,
FileListener {
    protected XulDomContainer container;
    protected XulRunner runner;
    private Logger logger = LoggerFactory.getLogger(AgileBiModelerPerspective.class);
    protected Document document;
    protected XulTabs tabs;
    protected XulTabpanels panels;
    protected XulTabbox tabbox;
    protected List<SpoonPerspectiveListener> listeners = new ArrayList<SpoonPerspectiveListener>();
    private String defaultExtension = "";
    protected ModelerWorkspace model;
    protected EngineMetaInterface selectedMeta;
    protected Map<XulTab, EngineMetaInterface> metas = new WeakHashMap<XulTab, EngineMetaInterface>();

    protected AbstractPerspective(String perspectiveSrc) {
        try {
            SwtXulLoader loader = new SwtXulLoader();
            loader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
            this.container = loader.loadXul(perspectiveSrc, (Object)new PDIMessages(((Object)((Object)this)).getClass()));
            this.runner = new SwtXulRunner();
            this.runner.addContainer(this.container);
            this.runner.initialize();
            this.document = this.container.getDocumentRoot();
            this.container.addEventHandler((XulEventHandler)this);
            this.tabs = (XulTabs)this.document.getElementById("tabs");
            this.panels = (XulTabpanels)this.document.getElementById("tabpanels");
            if (this.tabs != null) {
                this.tabbox = (XulTabbox)this.tabs.getParent();
            }
            DefaultBindingFactory bf = new DefaultBindingFactory();
            bf.setDocument(this.document);
            if (this.tabs != null) {
                bf.createBinding((Object)this.tabbox, "selectedIndex", (Object)this, "selectedMeta", new BindingConvertor[]{new BindingConvertor<Integer, EngineMetaInterface>(){

                    public EngineMetaInterface sourceToTarget(Integer value) {
                        return AbstractPerspective.this.metas.get(AbstractPerspective.this.tabs.getTabByIndex(value.intValue()));
                    }

                    public Integer targetToSource(EngineMetaInterface value) {
                        for (XulTab tab : AbstractPerspective.this.metas.keySet()) {
                            if (AbstractPerspective.this.metas.get(tab) != value) continue;
                            return tab.getParent().getChildNodes().indexOf(tab);
                        }
                        return -1;
                    }
                }});
            }
        }
        catch (Exception e) {
            this.logger.error("Error initializing perspective", (Throwable)e);
        }
    }

    public void switchToCaller(String content) {
    }

    public abstract String getDisplayName(Locale var1);

    public abstract InputStream getPerspectiveIcon();

    public void setActive(boolean active) {
        for (SpoonPerspectiveListener l : this.listeners) {
            if (active) {
                l.onActivation();
                continue;
            }
            l.onDeactication();
        }
    }

    public abstract String getId();

    public final Composite getUI() {
        return (Composite)this.container.getDocumentRoot().getRootElement().getFirstChild().getManagedObject();
    }

    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals(this.defaultExtension);
    }

    public boolean acceptsXml(String nodeName) {
        return false;
    }

    public abstract String[] getFileTypeDisplayNames(Locale var1);

    public String getRootNodeName() {
        return null;
    }

    public abstract String[] getSupportedExtensions();

    public abstract boolean save(EngineMetaInterface var1, String var2, boolean var3);

    public void syncMetaName(EngineMetaInterface meta, String name) {
    }

    public static String createShortName(String filename) {
        int sepPos;
        if (filename == null) {
            return null;
        }
        int extensionPos = filename.lastIndexOf(46);
        if (extensionPos == -1) {
            extensionPos = filename.length();
        }
        sepPos = (sepPos = filename.replace('\\', '/').lastIndexOf(47)) == -1 ? 0 : ++sepPos;
        return filename.substring(sepPos, extensionPos);
    }

    public abstract List<XulEventHandler> getEventHandlers();

    public abstract List<XulOverlay> getOverlays();

    public void addPerspectiveListener(SpoonPerspectiveListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public abstract String getName();

    public abstract boolean onTabClose(int var1) throws XulException;

    protected String getDefaultExtension() {
        return this.defaultExtension;
    }

    protected void setDefaultExtension(String defaultExtension) {
        this.defaultExtension = defaultExtension;
    }

    public XulTabAndPanel createTab() {
        try {
            XulTab tab = (XulTab)this.document.createElement("tab");
            if (this.name != null) {
                tab.setLabel(this.name);
            }
            XulTabpanel panel = (XulTabpanel)this.document.createElement("tabpanel");
            panel.setSpacing(0);
            panel.setPadding(0);
            this.tabs.addChild((Element)tab);
            this.panels.addChild((Element)panel);
            return new XulTabAndPanel(tab, panel);
        }
        catch (XulException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setNameForTab(XulTab tab, String name) {
        String tabName = name;
        ArrayList<String> usedNames = new ArrayList<String>();
        for (XulComponent c : this.tabs.getChildNodes()) {
            if (c == tab) continue;
            usedNames.add(((SwtTab)c).getLabel());
        }
        if (usedNames.contains(name)) {
            int num = 2;
            while (usedNames.contains(tabName = name + " (" + num + ")")) {
                ++num;
            }
        }
        tab.setLabel(tabName);
    }

    public void setMetaForTab(XulTab tab, EngineMetaInterface meta) {
        this.metas.put(tab, meta);
    }

    public EngineMetaInterface getActiveMeta() {
        if (this.tabbox == null) {
            return null;
        }
        int idx = this.tabbox.getSelectedIndex();
        if (idx == -1 || idx >= this.tabbox.getTabs().getChildNodes().size()) {
            return null;
        }
        return this.metas.get(this.tabbox.getTabs().getChildNodes().get(idx));
    }

    public void setSelectedMeta(EngineMetaInterface meta) {
        EngineMetaInterface prevVal = this.selectedMeta;
        this.selectedMeta = meta;
        Spoon.getInstance().enableMenus();
        this.firePropertyChange("selectedMeta", prevVal, meta);
    }

    public EngineMetaInterface getSelectedMeta() {
        return this.selectedMeta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class NameBindingConvertor
    extends BindingConvertor<String, String> {
        AbstractPerspective per;
        XulTab tab;

        public NameBindingConvertor(AbstractPerspective per, XulTab tab) {
            this.per = per;
            this.tab = tab;
        }

        public String sourceToTarget(String value) {
            String tabName = value;
            ArrayList<String> usedNames = new ArrayList<String>();
            for (XulComponent c : this.per.tabs.getChildNodes()) {
                if (c == this.tab) continue;
                usedNames.add(((SwtTab)c).getLabel());
            }
            if (usedNames.contains(value)) {
                int num = 2;
                while (usedNames.contains(tabName = value + " (" + num + ")")) {
                    ++num;
                }
            }
            return tabName;
        }

        public String targetToSource(String value) {
            return value;
        }
    }

    public class XulTabAndPanel {
        public XulTab tab;
        public XulTabpanel panel;

        public XulTabAndPanel(XulTab tab, XulTabpanel panel) {
            this.tab = tab;
            this.panel = panel;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class CloseConfirmXulDialogCallback
    implements XulDialogCallback<Object> {
        public boolean closeIt = false;

        protected CloseConfirmXulDialogCallback() {
        }

        public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
            if (returnCode == XulDialogCallback.Status.ACCEPT) {
                this.closeIt = true;
            }
        }

        public void onError(XulComponent sender, Throwable t) {
        }
    }
}

