/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.perspective;

import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.spoon.perspective.AbstractPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiInstaPerspectiveController;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.lifecycle.pdi.AgileBILifecycleListener;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.ShowMessageDialog;
import org.pentaho.di.ui.spoon.BreadcrumbManager;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPerspectiveListener;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.components.XulBrowser;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgileBiInstaPerspective
extends AbstractPerspective
implements SpoonPerspectiveListener,
SpoonPerspective {
    private static final Class<?> PKG = AgileBiInstaPerspective.class;
    public static final String PERSPECTIVE_ID = "030-agilebiInsta";
    private Logger logger = LoggerFactory.getLogger(AgileBiInstaPerspective.class);
    private static final AgileBiInstaPerspective INSTANCE = new AgileBiInstaPerspective();
    private AgileBiInstaPerspectiveController perspectiveController = new AgileBiInstaPerspectiveController();
    private XulBrowser browser;
    private boolean showTips;
    private boolean showRepositoryDailog;
    private SpoonPerspective lastPerspective;

    public void onStart() {
        int port;
        String location = "http://localhost:${port}/pentaho/content/instaview/resources/web/main.html?theme=onyx&embedded=true";
        Spoon spoon = Spoon.getInstance();
        if (spoon.getStartupPerspective() != null && spoon.getStartupPerspective().equals(PERSPECTIVE_ID)) {
            PropsUI props = spoon.getProperties();
            this.showTips = props.showTips();
            this.showRepositoryDailog = props.showRepositoriesDialogAtStartup();
            props.setShowTips(false);
            props.setRepositoriesDialogAtStartupShown(false);
        }
        if ((port = AgileBILifecycleListener.consolePort) == 0) {
            port = 10000;
        }
        location = this.replaceField(location, "port", "" + port, false);
        this.browser.setSrc(location);
        this.perspectiveController.setBrowser(this.browser);
    }

    public AgileBiInstaPerspective() {
        super("org/pentaho/agilebi/spoon/perspective/insta_browser.xul");
        this.addPerspectiveListener(this);
        SpoonPerspectiveManager.getInstance().addPerspective((SpoonPerspective)this);
        final AgileBiInstaPerspective thisPerspective = this;
        this.lastPerspective = this;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                for (final SpoonPerspective sp : SpoonPerspectiveManager.getInstance().getPerspectives()) {
                    sp.addPerspectiveListener(new SpoonPerspectiveListener(){

                        public void onActivation() {
                            if (sp != thisPerspective) {
                                AgileBiInstaPerspective.this.lastPerspective = sp;
                            }
                        }

                        public void onDeactication() {
                        }
                    });
                }
            }
        });
        try {
            this.browser = (XulBrowser)this.container.getDocumentRoot().getElementById("web_browser");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String replaceField(String str, String fieldName, String value, boolean urlEncode) {
        if (urlEncode) {
            value = URLEncoder.encode(value);
        }
        return str.replaceAll("\\$\\{" + fieldName + "\\}", value);
    }

    public static AgileBiInstaPerspective getInstance() {
        return INSTANCE;
    }

    public void setModel(ModelerWorkspace aModel) {
        this.model = aModel;
    }

    @Override
    public String getDisplayName(Locale l) {
        return BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Insta.Perspective.perspectiveName", (String[])new String[0]);
    }

    @Override
    public InputStream getPerspectiveIcon() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        return loader.getResourceAsStream("org/pentaho/agilebi/spoon/perspective/insta.png");
    }

    @Override
    public String getId() {
        return PERSPECTIVE_ID;
    }

    @Override
    public boolean acceptsXml(String nodeName) {
        return false;
    }

    @Override
    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[0];
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[0];
    }

    public boolean open(Node transNode, String fname, boolean importfile) {
        return true;
    }

    @Override
    public boolean save(EngineMetaInterface meta, String fname, boolean isExport) {
        return false;
    }

    @Override
    public void syncMetaName(EngineMetaInterface meta, String name) {
    }

    @Override
    public List<XulEventHandler> getEventHandlers() {
        return Collections.singletonList(this.perspectiveController);
    }

    @Override
    public List<XulOverlay> getOverlays() {
        XulOverlay overlay = new XulOverlay(){

            public String getId() {
                return "agileBi";
            }

            public String getOverlayUri() {
                return "org/pentaho/agilebi/spoon/perspective/insta_perspective_overlay.xul";
            }

            public String getOverlayXml() {
                return null;
            }

            public String getResourceBundleUri() {
                return null;
            }

            public String getSource() {
                return null;
            }
        };
        return Collections.singletonList(overlay);
    }

    @Override
    public String getName() {
        return "instaPerspective";
    }

    @Override
    public boolean onTabClose(int pos) throws XulException {
        return true;
    }

    @Override
    public void setSelectedMeta(EngineMetaInterface meta) {
        super.setSelectedMeta(meta);
    }

    public void onActivation() {
        Spoon spoonInstance = Spoon.getInstance();
        Shell shell = spoonInstance.getShell();
        boolean savePendingChanges = false;
        if (this.hasUnsavedChanges()) {
            ShowMessageDialog msgDialog = new ShowMessageDialog(shell, 456, BaseMessages.getString(PKG, (String)"Insta.UnsavedChanges.Warning.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Insta.UnsavedChanges.Warning.Message", (String[])new String[0]), false);
            int result = msgDialog.open();
            switch (result) {
                case 64: 
                case 128: {
                    savePendingChanges = result == 64;
                    break;
                }
                default: {
                    this.reactivateLastPerspective();
                    return;
                }
            }
        }
        boolean reactivateLast = false;
        try {
            reactivateLast = !this.closeETLTabs(savePendingChanges);
        }
        catch (Exception ex) {
            new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"Insta.Saving.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Insta.SavingETL.Error.Message", (String[])new String[0]), ex);
            reactivateLast = true;
        }
        if (!reactivateLast) {
            try {
                reactivateLast = !this.closeModelerTabs(savePendingChanges);
            }
            catch (Exception ex) {
                new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"Insta.Saving.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Insta.SavingModel.Error.Message", (String[])new String[0]), ex);
                reactivateLast = true;
            }
        }
        if (reactivateLast) {
            this.reactivateLastPerspective();
            return;
        }
        shell.setText("");
        spoonInstance.setMainToolbarVisible(false);
    }

    private void reactivateLastPerspective() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    SpoonPerspectiveManager.getInstance().activatePerspective(AgileBiInstaPerspective.this.lastPerspective.getClass());
                }
                catch (Exception ex) {
                    AgileBiInstaPerspective.this.logger.error("Error reactivating last perspective: " + AgileBiInstaPerspective.this.lastPerspective, (Throwable)ex);
                }
            }
        });
    }

    private boolean closeModelerTabs(boolean save) {
        AgileBiModelerPerspective modelerPerspective = AgileBiModelerPerspective.getInstance();
        for (int i = 0; i < modelerPerspective.models.size(); ++i) {
            EngineMetaInterface meta;
            if (!this.openedFromInstaview(modelerPerspective.models.get(i))) continue;
            if (save && !modelerPerspective.save(meta = (EngineMetaInterface)modelerPerspective.metas.get(modelerPerspective.tabbox.getTabs().getChildNodes().get(i)), meta.getFilename(), false)) {
                return false;
            }
            modelerPerspective.removeTab(i);
        }
        return true;
    }

    private boolean closeETLTabs(boolean save) throws KettleException {
        Spoon spoonInstance = Spoon.getInstance();
        int numTabs = spoonInstance.delegates.tabs.getTabs().size();
        for (int i = numTabs - 1; i >= 0; --i) {
            TabItemInterface tabItem;
            TransMeta transMeta;
            spoonInstance.tabfolder.setSelected(i);
            Object control = spoonInstance.tabfolder.getSelected().getControl();
            if (!(control instanceof TransGraph) || !this.openedFromInstaview(transMeta = ((TransGraph)control).getManagedObject())) continue;
            if (save && !(tabItem = (TabItemInterface)control).applyChanges()) {
                return false;
            }
            spoonInstance.delegates.trans.closeTransformation(transMeta);
            spoonInstance.refreshTree();
        }
        return true;
    }

    private boolean openedFromInstaview(TransMeta transMeta) {
        String caller = BreadcrumbManager.getInstance().getCaller("001-spoon-jobs\t" + transMeta.getFilename());
        return PERSPECTIVE_ID.equals(caller);
    }

    private boolean openedFromInstaview(ModelerWorkspace model) {
        String caller = BreadcrumbManager.getInstance().getCaller("010-agilebi\t" + model.getFileName());
        return PERSPECTIVE_ID.equals(caller);
    }

    public void onDeactication() {
        Spoon.getInstance().setMainToolbarVisible(true);
    }

    protected boolean hasUnsavedChanges() {
        Spoon spoonInstance = Spoon.getInstance();
        boolean changed = this.hasUnsavedETLChanges(spoonInstance.delegates.tabs.getTabs());
        return changed || this.hasUnsavedModelChanges(AgileBiModelerPerspective.getInstance().models);
    }

    protected boolean hasUnsavedETLChanges(List<TabMapEntry> tabs) {
        for (TabMapEntry tme : tabs) {
            TransMeta tm;
            if (!tme.getObjectType().equals((Object)TabMapEntry.ObjectType.TRANSFORMATION_GRAPH) || !(tme.getObject().getMeta() instanceof TransMeta) || !(tm = (TransMeta)tme.getObject().getMeta()).hasChanged() || !this.openedFromInstaview(tm)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasUnsavedModelChanges(List<ModelerWorkspace> models) {
        for (ModelerWorkspace model : models) {
            if (!model.isDirty() || !this.openedFromInstaview(model)) continue;
            return true;
        }
        return false;
    }

    public void shutdown() {
        Spoon spoon = Spoon.getInstance();
        if (spoon.getStartupPerspective() != null && spoon.getStartupPerspective().equals(PERSPECTIVE_ID)) {
            PropsUI props = spoon.getProperties();
            props.setShowTips(this.showTips);
            props.setRepositoriesDialogAtStartupShown(this.showRepositoryDailog);
            spoon.saveSettings();
        }
    }
}

