/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.perspective;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.IModelerMessages;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.IncompatibleModelerException;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerMessagesHolder;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceUtil;
import org.pentaho.agilebi.spoon.ModelerEngineMeta;
import org.pentaho.agilebi.spoon.SpoonModelerMessages;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.XulUI;
import org.pentaho.agilebi.spoon.perspective.AbstractPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspectiveController;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTab;
import org.pentaho.ui.xul.components.XulTabpanel;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.util.XulDialogCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgileBiModelerPerspective
extends AbstractPerspective
implements SpoonPerspective,
FileListener {
    public static final String PERSPECTIVE_ID = "010-agilebi";
    private Logger logger = LoggerFactory.getLogger(AgileBiModelerPerspective.class);
    private static final AgileBiModelerPerspective INSTANCE = new AgileBiModelerPerspective();
    protected List<ModelerWorkspace> models = new ArrayList<ModelerWorkspace>();
    private XulMenuitem modelPropItem;
    private AgileBiModelerPerspectiveController perspectiveController = new AgileBiModelerPerspectiveController();
    BindingFactory bf = new DefaultBindingFactory();

    private AgileBiModelerPerspective() {
        super("org/pentaho/agilebi/spoon/perspective/perspective.xul");
        this.setDefaultExtension("xmi");
        this.bf.setDocument(this.document);
        try {
            ModelerMessagesHolder.setMessages((IModelerMessages)new SpoonModelerMessages());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static AgileBiModelerPerspective getInstance() {
        return INSTANCE;
    }

    @Override
    public String getDisplayName(Locale l) {
        return BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Modeler.Perspective.perspectiveName", (String[])new String[0]);
    }

    @Override
    public InputStream getPerspectiveIcon() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        return loader.getResourceAsStream("org/pentaho/agilebi/spoon/perspective/blueprint.png");
    }

    @Override
    public String getId() {
        return PERSPECTIVE_ID;
    }

    @Override
    public boolean acceptsXml(String nodeName) {
        return false;
    }

    @Override
    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Models"};
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"xmi"};
    }

    public void createTabForModel(ModelerWorkspace aModel, String name) throws ModelerException {
        try {
            SpoonPerspectiveManager.getInstance().activatePerspective(((Object)((Object)this)).getClass());
            AbstractPerspective.XulTabAndPanel tabAndPanel = this.createTab();
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            XulUI xul = new XulUI(spoon.getShell(), aModel);
            this.metas.put(tabAndPanel.tab, xul.getMeta());
            if (this.selectedMeta != xul.getMeta()) {
                this.setSelectedMeta(xul.getMeta());
            }
            Composite parentComposite = (Composite)tabAndPanel.panel.getManagedObject();
            xul.getMainPanel().setParent(parentComposite);
            parentComposite.layout(true);
            this.setNameForTab(tabAndPanel.tab, name);
            DefaultBinding bind = new DefaultBinding((Object)aModel, "shortFileName", (Object)tabAndPanel.tab, "label");
            bind.setConversion((BindingConvertor)new AbstractPerspective.NameBindingConvertor(this, tabAndPanel.tab));
            bind.setBindingType(Binding.Type.ONE_WAY);
            this.document.addBinding((Binding)bind);
            this.models.add(aModel);
            this.model = aModel;
            this.setSelectedMeta(xul.getMeta());
            Spoon.getInstance().enableMenus();
        }
        catch (KettleException e) {
            throw new ModelerException((Throwable)e);
        }
    }

    public boolean open(Node transNode, String fname, boolean importfile) {
        try {
            File incomingFile = new File(fname);
            for (Map.Entry m : this.metas.entrySet()) {
                int idx;
                String fileName;
                if (m == null || (fileName = ((ModelerEngineMeta)m.getValue()).getController().getModel().getFileName()) == null || !new File(fileName).getAbsoluteFile().equals(incomingFile.getAbsoluteFile()) || (idx = this.tabbox.getTabs().getChildNodes().indexOf(m.getKey())) <= -1) continue;
                SpoonPerspectiveManager.getInstance().activatePerspective(((Object)((Object)this)).getClass());
                this.tabbox.setSelectedIndex(idx);
                return true;
            }
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            ModelerWorkspace theModel = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            theModel.setTemporary(false);
            theModel.setDirty(false);
            String xml = new String(IOUtils.toByteArray((InputStream)new FileInputStream(new File(fname))), "UTF-8");
            ModelerWorkspaceUtil.loadWorkspace((String)fname, (String)xml, (ModelerWorkspace)theModel);
            this.createTabForModel(theModel, AgileBiModelerPerspective.createShortName(fname));
            File f = new File(fname);
            String fullPath = f.getAbsolutePath();
            spoon.getProperties().addLastFile("Model", fullPath, null, false, null);
            spoon.addMenuLast();
            return true;
        }
        catch (IncompatibleModelerException e) {
            try {
                XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
                box.setTitle(BaseMessages.getString(AgileBiModelerPerspective.class, (String)"incompatible_model_title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(AgileBiModelerPerspective.class, (String)"incompatible_model_msg", (String[])new String[0]));
                box.setModalParent((Object)((Spoon)SpoonFactory.getInstance()).getShell());
                box.open();
            }
            catch (XulException e1) {
                e1.printStackTrace();
            }
        }
        catch (ModelerException e) {
            this.logger.error("Error opening file", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error("Error opening file", (Throwable)e);
        }
        catch (KettleException e) {
            this.logger.error("Error opening file", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean save(EngineMetaInterface meta, String fname, boolean isExport) {
        try {
            return ((ModelerEngineMeta)meta).getController().saveWorkspace(fname);
        }
        catch (ModelerException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void syncMetaName(EngineMetaInterface meta, String name) {
    }

    @Override
    public List<XulEventHandler> getEventHandlers() {
        return Collections.singletonList(this.perspectiveController);
    }

    @Override
    public List<XulOverlay> getOverlays() {
        XulOverlay overlay = new XulOverlay(){

            public String getId() {
                return "agileBi";
            }

            public String getOverlayUri() {
                return "org/pentaho/agilebi/spoon/perspective/modeler_perspective_overlay.xul";
            }

            public String getOverlayXml() {
                return null;
            }

            public String getResourceBundleUri() {
                return null;
            }

            public String getSource() {
                return null;
            }
        };
        return Collections.singletonList(overlay);
    }

    @Override
    public String getName() {
        return "agileBiPerspective";
    }

    @Override
    public boolean onTabClose(int pos) throws XulException {
        String contentId = "010-agilebi\t" + this.models.get(pos).getFileName();
        if (this.models.get(pos).isDirty()) {
            XulConfirmBox confirm = (XulConfirmBox)this.document.createElement("confirmbox");
            confirm.setTitle(BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Modeler.Perspective.unsavedChanges", (String[])new String[0]));
            confirm.setMessage(BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Modeler.Perspective.unsavedChangesMessage", (String[])new String[0]));
            AbstractPerspective.CloseConfirmXulDialogCallback callback = new AbstractPerspective.CloseConfirmXulDialogCallback();
            confirm.addDialogCallback((XulDialogCallback)callback);
            confirm.open();
            if (!callback.closeIt) {
                return false;
            }
        }
        this.tabClosed(pos);
        this.switchToCaller(contentId);
        return true;
    }

    private void tabClosed(int pos) {
        this.models.remove(pos);
        this.metas.remove(this.tabbox.getTabs().getChildNodes().get(pos));
    }

    public void removeTab(int pos) {
        if (pos < 0 || pos >= this.tabbox.getTabs().getChildNodes().size()) {
            throw new IllegalArgumentException("invalid position: " + pos);
        }
        this.tabClosed(pos);
        XulTab tab = (XulTab)this.tabs.getChildNodes().get(pos);
        XulTabpanel panel = (XulTabpanel)this.panels.getChildNodes().get(pos);
        this.tabs.removeChild((Element)tab);
        this.panels.removeChild((Element)panel);
    }

    public void exportSchema() {
        try {
            if (this.model.isValid()) {
                this.model.getWorkspaceHelper().populateDomain(this.model);
                LogicalModel lModel = this.model.getLogicalModel(ModelerPerspective.ANALYSIS);
                FileDialog fileDialog = new FileDialog(Spoon.getInstance().getShell(), 8192);
                String[] theExtensions = new String[]{"*.xml"};
                fileDialog.setFilterExtensions(theExtensions);
                String theFile = fileDialog.open();
                if (theFile != null) {
                    MondrianModelExporter exporter = new MondrianModelExporter(lModel, "en_US");
                    String mondrianSchema = exporter.createMondrianModelXML();
                    this.logger.info(mondrianSchema);
                    Document schemaDoc = DocumentHelper.parseText((String)mondrianSchema);
                    byte[] schemaBytes = schemaDoc.asXML().getBytes();
                    File modelFile = new File(theFile);
                    FileOutputStream out = new FileOutputStream(modelFile);
                    ((OutputStream)out).write(schemaBytes);
                    out.flush();
                    ((OutputStream)out).close();
                }
            } else {
                StringBuffer validationErrors = new StringBuffer();
                for (String msg : this.model.getValidationMessages()) {
                    validationErrors.append(msg);
                    validationErrors.append("\n");
                    this.logger.info(msg);
                }
                MessageDialog.openError((Shell)Spoon.getInstance().getShell(), (String)"", (String)validationErrors.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("Error exporting Schema", (Throwable)e);
            MessageDialog.openError((Shell)Spoon.getInstance().getShell(), (String)"", (String)e.getMessage());
        }
    }

    @Override
    public void setSelectedMeta(EngineMetaInterface meta) {
        super.setSelectedMeta(meta);
        this.perspectiveController.setSelectedModelerMeta((ModelerEngineMeta)meta);
    }
}

