/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.perspective;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.spoon.ModelerEngineMeta;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMenuitem;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgileBiModelerPerspectiveController
extends AbstractXulEventHandler {
    private Logger logger = LoggerFactory.getLogger(AgileBiModelerPerspective.class);
    private XulMenuitem modelPropItem;
    BindingFactory bf = new DefaultBindingFactory();
    private Binding itemBinding;
    private ModelerEngineMeta meta;

    public String getName() {
        return "agileBiPerspective";
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
        super.setXulDomContainer(xulDomContainer);
        this.modelPropItem = (XulMenuitem)this.document.getElementById("view-modeler-props");
        this.bf.setDocument(this.document);
    }

    public void setPropVisible(boolean vis) {
        this.modelPropItem.setSelected(vis);
    }

    public void setSelectedModelerMeta(ModelerEngineMeta meta) {
        this.meta = meta;
        if (this.itemBinding != null) {
            this.itemBinding.destroyBindings();
        }
        if (meta != null) {
            this.bf.setBindingType(Binding.Type.ONE_WAY);
            this.itemBinding = this.bf.createBinding((Object)meta.getController(), "propVisible", (Object)this, "propVisible", new BindingConvertor[0]);
            try {
                this.itemBinding.fireSourceChanged();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void toggleProperties() {
        if (this.meta == null) {
            return;
        }
        this.meta.getController().togglePropertiesPanel();
    }

    public void exportSchema() {
        try {
            ModelerWorkspace model = this.meta.getController().getModel();
            if (model.isValid()) {
                model.getWorkspaceHelper().populateDomain(model);
                LogicalModel lModel = model.getLogicalModel(ModelerPerspective.ANALYSIS);
                FileDialog fileDialog = new FileDialog(Spoon.getInstance().getShell(), 8192);
                String[] theExtensions = new String[]{"*.xml"};
                fileDialog.setFilterExtensions(theExtensions);
                String theFile = fileDialog.open();
                if (theFile != null) {
                    MondrianModelExporter exporter = new MondrianModelExporter(lModel, "en_US");
                    String mondrianSchema = exporter.createMondrianModelXML();
                    this.logger.info(mondrianSchema);
                    Document schemaDoc = DocumentHelper.parseText((String)mondrianSchema);
                    byte[] schemaBytes = schemaDoc.asXML().getBytes();
                    File modelFile = new File(theFile);
                    FileOutputStream out = new FileOutputStream(modelFile);
                    ((OutputStream)out).write(schemaBytes);
                    out.flush();
                    ((OutputStream)out).close();
                }
            } else {
                StringBuffer validationErrors = new StringBuffer();
                for (String msg : model.getValidationMessages()) {
                    validationErrors.append(msg);
                    validationErrors.append("\n");
                    this.logger.info(msg);
                }
                MessageDialog.openError((Shell)Spoon.getInstance().getShell(), (String)"", (String)validationErrors.toString());
            }
        }
        catch (Exception e) {
            this.logger.error("Error exporting schema", (Throwable)e);
            MessageDialog.openError((Shell)Spoon.getInstance().getShell(), (String)"", (String)e.getMessage());
        }
    }
}

