/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.perspective;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelerWorkspaceUtil;
import org.pentaho.agilebi.spoon.ModelerEngineMeta;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.XulUI;
import org.pentaho.agilebi.spoon.perspective.AbstractPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiVisualizationPerspectiveController;
import org.pentaho.agilebi.spoon.visualizations.SaveAwareMeta;
import org.pentaho.agilebi.spoon.visualizations.analyzer.AnalyzerVisualizationController;
import org.pentaho.agilebi.spoon.visualizations.analyzer.AnalyzerVisualizationMeta;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.DefaultBinding;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.util.XulDialogCallback;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgileBiVisualizationPerspective
extends AbstractPerspective {
    public static final String PERSPECTIVE_ID = "020-agilebiVisualization";
    private static final AgileBiVisualizationPerspective INSTANCE = new AgileBiVisualizationPerspective();
    protected List<ModelerWorkspace> models = new ArrayList<ModelerWorkspace>();
    private Map<ModelerWorkspace, EngineMetaInterface> metas = new HashMap<ModelerWorkspace, EngineMetaInterface>();
    private AgileBiVisualizationPerspectiveController controller = new AgileBiVisualizationPerspectiveController();

    private AgileBiVisualizationPerspective() {
        super("org/pentaho/agilebi/spoon/perspective/vizperspective.xul");
    }

    public static AgileBiVisualizationPerspective getInstance() {
        return INSTANCE;
    }

    public void setModel(ModelerWorkspace aModel) {
        this.model = aModel;
    }

    @Override
    public String getDisplayName(Locale l) {
        return BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Visualization.Perspective.perspectiveName", (String[])new String[0]);
    }

    @Override
    public InputStream getPerspectiveIcon() {
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        return loader.getResourceAsStream("org/pentaho/agilebi/spoon/perspective/analyzer.png");
    }

    @Override
    public String getId() {
        return PERSPECTIVE_ID;
    }

    @Override
    public boolean acceptsXml(String nodeName) {
        return false;
    }

    @Override
    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Visualizations"};
    }

    @Override
    public String[] getSupportedExtensions() {
        return new String[]{"xanalyzer"};
    }

    public void createTabForModel(ModelerWorkspace model, String name) {
        try {
            SpoonPerspectiveManager.getInstance().activatePerspective(((Object)((Object)this)).getClass());
            AbstractPerspective.XulTabAndPanel tabAndPanel = this.createTab();
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            XulUI xul = new XulUI(spoon.getShell(), model);
            this.metas.put(model, xul.getMeta());
            Composite parentComposite = (Composite)tabAndPanel.panel.getManagedObject();
            xul.getMainPanel().setParent(parentComposite);
            parentComposite.layout(true);
            if (this.selectedMeta != xul.getMeta()) {
                this.setSelectedMeta(xul.getMeta());
            }
            DefaultBinding bind = new DefaultBinding((Object)model, "shortFileName", (Object)tabAndPanel.tab, "label");
            bind.setConversion((BindingConvertor)new AbstractPerspective.NameBindingConvertor(this, tabAndPanel.tab));
            bind.setBindingType(Binding.Type.ONE_WAY);
            this.document.addBinding((Binding)bind);
            this.models.add(model);
            this.setSelectedMeta(xul.getMeta());
        }
        catch (KettleException e) {
            e.printStackTrace();
        }
        catch (ModelerException e) {
            e.printStackTrace();
        }
    }

    public boolean open(Node transNode, String fname, boolean importfile) {
        try {
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            this.createTabForModel(model, AgileBiVisualizationPerspective.createShortName(fname));
            String xml = new String(IOUtils.toByteArray((InputStream)new FileInputStream(new File(fname))), "UTF-8");
            ModelerWorkspaceUtil.loadWorkspace((String)fname, (String)xml, (ModelerWorkspace)model);
            File f = new File(fname);
            String fullPath = f.getAbsolutePath();
            spoon.getProperties().addLastFile("Visualization", fullPath, null, false, null);
            spoon.addMenuLast();
        }
        catch (ModelerException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean save(EngineMetaInterface meta, String fname, boolean isExport) {
        try {
            ((ModelerEngineMeta)meta).getController().saveWorkspace(fname);
            return true;
        }
        catch (ModelerException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void syncMetaName(EngineMetaInterface meta, String name) {
    }

    @Override
    public List<XulEventHandler> getEventHandlers() {
        return Collections.singletonList(this.controller);
    }

    @Override
    public List<XulOverlay> getOverlays() {
        XulOverlay overlay = new XulOverlay(){

            public String getId() {
                return "agileBi";
            }

            public String getOverlayUri() {
                return "org/pentaho/agilebi/spoon/perspective/visualization_perspective_overlay.xul";
            }

            public String getOverlayXml() {
                return null;
            }

            public String getResourceBundleUri() {
                return null;
            }

            public String getSource() {
                return null;
            }
        };
        return Collections.singletonList(overlay);
    }

    @Override
    public String getName() {
        return "agileBiVizPerspective";
    }

    @Override
    public boolean onTabClose(int pos) throws XulException {
        AnalyzerVisualizationController controller = (AnalyzerVisualizationController)((AnalyzerVisualizationMeta)this.selectedMeta).getController();
        String contentId = "020-agilebiVisualization\t" + controller.getVisFileLocation();
        if (((SaveAwareMeta)this.getActiveMeta()).isDirty()) {
            XulConfirmBox confirm = (XulConfirmBox)this.document.createElement("confirmbox");
            confirm.setTitle(BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Modeler.Perspective.unsavedChanges", (String[])new String[0]));
            confirm.setMessage(BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Visualization.Perspective.unsavedChangesMessage", (String[])new String[0]));
            AbstractPerspective.CloseConfirmXulDialogCallback callback = new AbstractPerspective.CloseConfirmXulDialogCallback();
            confirm.addDialogCallback((XulDialogCallback)callback);
            confirm.open();
            if (callback.closeIt) {
                this.switchToCaller(contentId);
                return true;
            }
            return false;
        }
        this.switchToCaller(contentId);
        return true;
    }

    @Override
    public void setSelectedMeta(EngineMetaInterface meta) {
        super.setSelectedMeta(meta);
        this.controller.setSelectedModelerMeta(meta);
    }
}

