/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.publish;

import java.io.File;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.pentaho.agilebi.spoon.publish.BiServerConnection;
import org.pentaho.agilebi.spoon.publish.BiServerConnectionCollection;
import org.pentaho.di.core.encryption.Encr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BiServerConfig {
    private static BiServerConfig instance = null;
    private static final String CONFIG_FILE_LOCATION = "plugins/spoon/agile-bi/biservers.properties";
    private BiServerConnectionCollection servers = new BiServerConnectionCollection();

    public static BiServerConfig getInstance() {
        if (instance == null) {
            instance = new BiServerConfig();
        }
        return instance;
    }

    protected BiServerConfig() {
        this.refreshServerList();
    }

    public void refreshServerList() {
        try {
            this.servers.clear();
            File file = new File(CONFIG_FILE_LOCATION);
            if (!file.exists()) {
                return;
            }
            FileInputStream in = new FileInputStream(file);
            Properties props = new Properties();
            props.load(in);
            int idx = 1;
            boolean running = true;
            this.servers.clear();
            while (running) {
                String serverId = "biserver" + Integer.toString(idx);
                String serverName = props.getProperty(serverId + "/name");
                String url = props.getProperty(serverId + "/url");
                String userId = props.getProperty(serverId + "/user");
                String password = Encr.decryptPassword((String)props.getProperty(serverId + "/password"));
                String publishPassword = Encr.decryptPassword((String)props.getProperty(serverId + "/publishpassword"));
                String defaultFolder = props.getProperty(serverId + "/defaultfolder");
                boolean defaultDatasourcePublish = "true".equalsIgnoreCase(props.getProperty(serverId + "/defaultdatasourcepublish"));
                if (serverName != null) {
                    BiServerConnection server = new BiServerConnection();
                    server.setName(serverName);
                    server.setPassword(password);
                    server.setPublishPassword(publishPassword);
                    server.setUrl(url);
                    server.setUserId(userId);
                    server.setDefaultDatasourcePublish(defaultDatasourcePublish);
                    server.setDefaultFolder(defaultFolder);
                    this.servers.add(server);
                    ++idx;
                    continue;
                }
                running = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getServerNames() {
        ArrayList<String> serverNames = new ArrayList<String>();
        Iterator i$ = this.servers.iterator();
        while (i$.hasNext()) {
            BiServerConnection server = (BiServerConnection)i$.next();
            serverNames.add(server.getName());
        }
        return serverNames;
    }

    public BiServerConnectionCollection getServerConnections() {
        return this.servers;
    }

    public boolean deleteServerByName(String serverName) {
        Iterator i$ = this.servers.iterator();
        while (i$.hasNext()) {
            BiServerConnection server = (BiServerConnection)i$.next();
            if (!server.getName().equals(serverName)) continue;
            this.servers.remove(server);
            return true;
        }
        return false;
    }

    public void addServer(BiServerConnection server) {
        this.servers.add(server);
    }

    public BiServerConnection getServerByName(String serverName) {
        Iterator i$ = this.servers.iterator();
        while (i$.hasNext()) {
            BiServerConnection server = (BiServerConnection)i$.next();
            if (!server.getName().equals(serverName)) continue;
            return server;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        PrintWriter writer = null;
        try {
            File file = new File(CONFIG_FILE_LOCATION);
            Properties props = new Properties();
            int idx = 1;
            Iterator i$ = this.servers.iterator();
            while (i$.hasNext()) {
                BiServerConnection server = (BiServerConnection)i$.next();
                String serverId = "biserver" + Integer.toString(idx);
                if (server.getName() != null) {
                    props.put(serverId + "/name", server.getName());
                }
                if (server.getUrl() != null) {
                    props.put(serverId + "/url", server.getUrl());
                }
                if (server.getUserId() != null) {
                    props.put(serverId + "/user", server.getUserId());
                }
                if (server.getPassword() != null) {
                    props.put(serverId + "/password", Encr.encryptPassword((String)server.getPassword()));
                }
                if (server.getPublishPassword() != null) {
                    props.put(serverId + "/publishpassword", Encr.encryptPassword((String)server.getPublishPassword()));
                }
                if (server.getDefaultFolder() != null) {
                    props.put(serverId + "/defaultfolder", server.getDefaultFolder());
                }
                props.put(serverId + "/defaultdatasourcepublish", server.getDefaultDatasourcePublish() ? "true" : "false");
                ++idx;
            }
            writer = new PrintWriter(file);
            props.list(writer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

