/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.publish;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.spoon.publish.BiServerConnection;
import org.pentaho.agilebi.spoon.publish.PublishOverwriteDelegate;
import org.pentaho.agilebi.spoon.publish.PublisherHelper;
import org.pentaho.commons.util.repository.type.CmisObject;
import org.pentaho.commons.util.repository.type.TypesOfFileableObjects;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.util.MondrianModelExporter;
import org.pentaho.platform.dataaccess.client.ConnectionServiceClient;
import org.pentaho.platform.dataaccess.datasource.IConnection;
import org.pentaho.platform.dataaccess.datasource.beans.Connection;
import org.pentaho.platform.dataaccess.datasource.wizard.service.ConnectionServiceException;
import org.pentaho.platform.util.client.BiPlatformRepositoryClient;
import org.pentaho.platform.util.client.BiPlatformRepositoryClientNavigationService;
import org.pentaho.platform.util.client.PublisherUtil;
import org.pentaho.platform.util.client.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelServerPublish {
    public static final int PUBLISH_UNKNOWN_PROBLEM = -1;
    public static final int PUBLISH_FILE_EXISTS = 1;
    public static final int PUBLISH_FAILED = 2;
    public static final int PUBLISH_SUCCESS = 3;
    public static final int PUBLISH_INVALID_PASSWORD = 4;
    public static final int PUBLISH_INVALID_USER_OR_PASSWORD = 5;
    public static final int PUBLISH_DATASOURCE_PROBLEM = 6;
    public static final int PUBLISH_CATALOG_EXISTS = 7;
    public static final int REMOTE_CONNECTION_MISSING = 1;
    public static final int REMOTE_CONNECTION_DIFFERENT = 2;
    public static final int REMOTE_CONNECTION_SAME = 4;
    public static final int REMOTE_CONNECTION_MUST_BE_JNDI = 8;
    private static final int DATASOURCE_DRIVER_MISSING = 9;
    private BiServerConnection biServerConnection;
    private IConnection remoteConnection;
    private ModelerWorkspace model;
    private int serviceClientStatus = 0;
    private BiPlatformRepositoryClientNavigationService navigationService;
    public static PublishOverwriteDelegate overwriteDelegate;

    public List<IConnection> listRemoteConnections() throws ConnectionServiceException {
        ConnectionServiceClient serviceClient = new ConnectionServiceClient();
        serviceClient.setHost(this.biServerConnection.getUrl());
        serviceClient.setUserId(this.biServerConnection.getUserId());
        serviceClient.setPassword(this.biServerConnection.getPassword());
        List connections = serviceClient.getConnections();
        return connections;
    }

    public IConnection getRemoteConnection(String connectionName, boolean force) {
        if (this.remoteConnection == null || force) {
            ConnectionServiceClient serviceClient = new ConnectionServiceClient();
            serviceClient.setHost(this.biServerConnection.getUrl());
            serviceClient.setUserId(this.biServerConnection.getUserId());
            serviceClient.setPassword(this.biServerConnection.getPassword());
            try {
                this.remoteConnection = serviceClient.getConnectionByName(connectionName);
            }
            catch (ConnectionServiceException e) {
                this.remoteConnection = null;
            }
        }
        return this.remoteConnection;
    }

    public int compareDataSourceWithRemoteConnection(DatabaseMeta databaseMeta) throws ConnectionServiceException, KettleDatabaseException {
        boolean driverMatch;
        int result = 0;
        if (databaseMeta.getAccessType() != 0) {
            return result += 8;
        }
        String connectionName = PublisherHelper.getBiServerCompatibleDatabaseName(databaseMeta.getName());
        IConnection connection = this.getRemoteConnection(connectionName, false);
        if (connection == null) {
            return ++result;
        }
        String url = databaseMeta.getURL();
        String userName = databaseMeta.getUsername();
        String driverClass = databaseMeta.getDriverClass();
        boolean urlMatch = url.equals(connection.getUrl());
        boolean userMatch = userName == null && connection.getUsername() == null || userName.equals(connection.getUsername());
        boolean bl = driverMatch = driverClass == null && connection.getDriverClass() == null || driverClass.equals(connection.getDriverClass());
        result = urlMatch && userMatch && driverMatch ? (result += 4) : (result += 2);
        return result;
    }

    public List<CmisObject> getRepositoryFiles(CmisObject folder, int depth, boolean foldersOnly) throws Exception {
        this.getNavigationService();
        TypesOfFileableObjects folderTypes = foldersOnly ? new TypesOfFileableObjects("folders") : new TypesOfFileableObjects("any");
        String startLocation = "";
        if (folder != null) {
            startLocation = folder.findIdProperty("ObjectId", null);
        }
        List objects = this.getNavigationService().getDescendants("PLATFORMORIG", startLocation, folderTypes, depth, null, false, false);
        return objects;
    }

    public int publishFile(String repositoryPath, File[] files, boolean showFeedback) {
        for (int i = 0; i < files.length; ++i) {
            boolean overwrite;
            if (!this.checkForExistingFile(repositoryPath, files[i].getName()) || (overwrite = overwriteDelegate.handleOverwriteNotification(files[i].getName()))) continue;
            return 1;
        }
        String DEFAULT_PUBLISH_URL = this.biServerConnection.getUrl() + "RepositoryFilePublisher";
        int result = PublisherUtil.publish((String)DEFAULT_PUBLISH_URL, (String)repositoryPath, (File[])files, (String)this.biServerConnection.getPublishPassword(), (String)this.biServerConnection.getUserId(), (String)this.biServerConnection.getPassword(), (boolean)true, (boolean)true);
        if (showFeedback) {
            this.showFeedback(result);
        }
        return result;
    }

    private boolean publishDataSource(DatabaseMeta databaseMeta, boolean update) throws KettleDatabaseException, ConnectionServiceException {
        ConnectionServiceClient serviceClient = new ConnectionServiceClient();
        serviceClient.setHost(this.biServerConnection.getUrl());
        serviceClient.setUserId(this.biServerConnection.getUserId());
        serviceClient.setPassword(this.biServerConnection.getPassword());
        Connection connection = new Connection();
        connection.setDriverClass(databaseMeta.getDriverClass());
        connection.setName(PublisherHelper.getBiServerCompatibleDatabaseName(databaseMeta.getName()));
        connection.setPassword(databaseMeta.getPassword());
        connection.setUrl(databaseMeta.getURL());
        connection.setUsername(databaseMeta.getUsername());
        boolean result = false;
        result = update ? serviceClient.updateConnection((IConnection)connection) : serviceClient.addConnection((IConnection)connection);
        return result;
    }

    public int publish(String publishPath, File publishFile, String jndiName, String modelId, boolean enableXmla) throws Exception, UnsupportedEncodingException {
        String url = this.biServerConnection.getUrl();
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if (url.charAt(url.length() - 1) != '/') {
            sb.append('/');
        }
        sb.append("MondrianCatalogPublisher?publishPath=").append(URLEncoder.encode(publishPath, "UTF-8")).append("&publishKey=").append(this.getPasswordKey(new String(this.biServerConnection.getPublishPassword()))).append("&overwrite=true&mkdirs=true").append("&jndiName=").append(jndiName).append("&enableXmla=").append(enableXmla).append("&userid=").append(this.biServerConnection.getUserId()).append("&password=").append(this.biServerConnection.getPassword());
        String fullUrl = sb.toString();
        PostMethod filePost = new PostMethod(fullUrl);
        ArrayList<FilePart> parts = new ArrayList<FilePart>();
        try {
            parts.add(new FilePart(publishFile.getName(), publishFile));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        filePost.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), filePost.getParams()));
        HttpClient client = this.getClient(this.biServerConnection.getUserId(), this.biServerConnection.getPassword());
        try {
            this.serviceClientStatus = client.executeMethod((HttpMethod)filePost);
        }
        catch (IOException e) {
            throw new Exception(e.getMessage(), e);
        }
        try {
            String postResult = filePost.getResponseBodyAsString();
            int publishResult = Integer.parseInt(postResult.trim());
            return publishResult;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1;
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return -1;
        }
    }

    private HttpClient getClient(String serverUserId, String serverPassword) {
        HttpClient client = new HttpClient();
        if (serverUserId.length() > 0 && serverPassword.length() > 0) {
            UsernamePasswordCredentials creds = new UsernamePasswordCredentials(serverUserId, serverPassword);
            client.getState().setCredentials(AuthScope.ANY, (Credentials)creds);
            client.getParams().setAuthenticationPreemptive(true);
        }
        return client;
    }

    private String getPasswordKey(String passWord) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(passWord.getBytes("UTF-8"));
            byte[] digest = md.digest("P3ntah0Publ1shPa55w0rd".getBytes("UTF-8"));
            StringBuilder buf = new StringBuilder(digest.length + 1);
            for (byte aDigest : digest) {
                String s = Integer.toHexString(0xFF & aDigest);
                buf.append(s.length() == 1 ? "0" : "").append(s);
            }
            return buf.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public void publishToServer(String schemaName, String jndiName, String modelName, String repositoryPath, String selectedPath, boolean publishDatasource, boolean showFeedback, boolean isExistentDatasource, String fileName) throws Exception {
        File[] files = new File[]{new File(fileName)};
        this.publishFile(selectedPath, files, false);
        if (publishDatasource) {
            DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.model.getModelSource()).getDatabaseMeta();
            this.publishDataSource(databaseMeta, isExistentDatasource);
        }
        this.publishOlapSchemaToServer(schemaName, jndiName, modelName, repositoryPath, true);
    }

    public void publishPrptToServer(String theXmiPublishingPath, String thePrptPublishingPath, boolean publishDatasource, boolean isExistentDatasource, boolean publishXmi, String xmi, String prpt) throws Exception {
        File[] thePrpt = new File[]{new File(prpt)};
        int result = this.publishFile(thePrptPublishingPath, thePrpt, !publishXmi);
        if (result != 3) {
            return;
        }
        if (publishXmi) {
            File[] theXmi = new File[]{new File(xmi)};
            this.publishFile(theXmiPublishingPath, theXmi, true);
        }
        if (publishDatasource) {
            DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.model.getModelSource()).getDatabaseMeta();
            this.publishDataSource(databaseMeta, isExistentDatasource);
        }
    }

    public boolean checkForExistingFile(String path, String name) {
        try {
            if (path == null || name == null) {
                return false;
            }
            ArrayList<String> folders = new ArrayList<String>(Arrays.asList(path.split("/")));
            int idx = 0;
            CmisObject folder = null;
            while (folders.size() > 0) {
                folder = this.findFolder((String)folders.get(idx), folder);
                if (folder == null) {
                    return false;
                }
                folders.remove(idx);
            }
            List files = this.getNavigationService().getDescendants("PLATFORMORIG", folder.findIdProperty("ObjectId", null), new TypesOfFileableObjects("any"), 1, null, false, false);
            for (CmisObject f : files) {
                if (!f.findStringProperty("Name", null).equals(name)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private CmisObject findFolder(String folder, CmisObject parent) throws Exception {
        List solutions = this.getNavigationService().getDescendants("PLATFORMORIG", parent != null ? parent.findIdProperty("ObjectId", null) : "", new TypesOfFileableObjects("folders"), 1, null, false, false);
        for (CmisObject obj : solutions) {
            if (!obj.findStringProperty("Name", null).equals(folder)) continue;
            return obj;
        }
        return null;
    }

    public boolean checkDataSource(boolean autoMode) throws KettleDatabaseException, ConnectionServiceException {
        boolean different;
        DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.model.getModelSource()).getDatabaseMeta();
        int compare = this.compareDataSourceWithRemoteConnection(databaseMeta);
        String serverName = this.biServerConnection.getName();
        boolean nonJndi = (compare & 8) > 0;
        boolean missing = (compare & 1) > 0;
        boolean bl = different = (compare & 2) > 0;
        if (missing && !nonJndi) {
            if (!autoMode && !SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.OkToPublish", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), true, 3)) {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.PublishCancelled", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                return false;
            }
            boolean ok = this.publishDataSource(databaseMeta, false);
            if (!autoMode && ok) {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.Added", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 3);
            }
            return ok;
        }
        if (missing && nonJndi) {
            if (!autoMode) {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.NonJNDI", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
            }
            return false;
        }
        if (different && !nonJndi) {
            if (!autoMode && !SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.IsDifferent", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), true, 3)) {
                return false;
            }
            boolean ok = this.publishDataSource(databaseMeta, true);
            if (!autoMode && ok) {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.Updated", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
            }
            return ok;
        }
        if (different && nonJndi) {
            if (!autoMode) {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Datasource.CannotUpdate", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
            }
            return false;
        }
        return false;
    }

    protected void showFeedback(int result) {
        String serverName = this.biServerConnection.getName();
        switch (result) {
            case 7: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.CatalogExists", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 6: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.DataSourceProblem", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 9: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.DriverMissing", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 2: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.Failed", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 1: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.FileExists", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 4: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.BadPassword", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 5: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Errors.InvalidUser", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
                break;
            }
            case 3: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.Success", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 3);
                break;
            }
            case -1: {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.Publish.UnknownProblem", (String[])new String[0]), BaseMessages.getString(this.getClass(), (String)"ModelServerPublish.MessageBox.Title", (String[])new String[]{serverName}), false, 2);
            }
        }
    }

    private void publishOlapSchemaToServer(String schemaFilePath, String jndiName, String modelName, String repositoryPath, boolean showFeedback) throws Exception {
        File modelsDir = new File("models");
        if (!modelsDir.exists()) {
            modelsDir.mkdir();
        }
        File publishFile = new File(modelsDir, schemaFilePath);
        publishFile.createNewFile();
        LogicalModel lModel = this.model.getLogicalModel(ModelerPerspective.ANALYSIS);
        MondrianModelExporter exporter = new MondrianModelExporter(lModel, "en_US");
        String mondrianSchema = exporter.createMondrianModelXML();
        Document schemaDoc = DocumentHelper.parseText((String)mondrianSchema);
        byte[] schemaBytes = schemaDoc.asXML().getBytes();
        if (!publishFile.exists()) {
            throw new ModelerException("Schema file does not exist");
        }
        FileOutputStream out = new FileOutputStream(publishFile);
        ((OutputStream)out).write(schemaBytes);
        out.flush();
        ((OutputStream)out).close();
        int result = this.publish(repositoryPath, publishFile, jndiName, modelName, false);
        if (showFeedback) {
            this.showFeedback(result);
        }
    }

    public void setBiServerConnection(BiServerConnection biServerConnection) {
        this.biServerConnection = biServerConnection;
    }

    public void setModel(ModelerWorkspace model) {
        this.model = model;
    }

    public int getServerConnectionStatus() {
        return this.serviceClientStatus;
    }

    public BiPlatformRepositoryClientNavigationService getNavigationService() {
        if (this.navigationService == null) {
            BiPlatformRepositoryClient client = new BiPlatformRepositoryClient();
            client.setServerUri(this.biServerConnection.getUrl());
            client.setUserId(this.biServerConnection.getUserId());
            client.setPassword(this.biServerConnection.getPassword());
            try {
                client.connect();
            }
            catch (ServiceException e) {
                e.printStackTrace();
                return null;
            }
            this.navigationService = client.getNavigationService();
        }
        return this.navigationService;
    }
}

