/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.publish;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.spoon.publish.BiServerConnection;
import org.pentaho.agilebi.spoon.publish.ModelServerPublish;
import org.pentaho.agilebi.spoon.publish.XulDialogPublish;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriter;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.ui.xul.XulException;

public class PublisherHelper {
    private static String cachedPath;
    private static BiServerConnection cachedServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String publishAnalysis(ModelerWorkspace workspace, String publishingFile, int treeDepth, DatabaseMeta databaseMeta, String fullPathtoFile, boolean checkDatasources, boolean setShowModel, boolean showFolders, boolean showCurrentFolder, String serverPathTemplate, String extension, String databaseName) throws ModelerException {
        block13: {
            try {
                if (StringUtils.isEmpty((String)publishingFile)) {
                    SpoonFactory.getInstance().messageBox(BaseMessages.getString(ModelerWorkspace.class, (String)"ModelServerPublish.Publish.UnsavedModel", (String[])new String[0]), "Dialog Error", false, 2);
                    throw new ModelerException(BaseMessages.getString(ModelerWorkspace.class, (String)"ModelServerPublish.Publish.UnsavedModel", (String[])new String[0]));
                }
                ModelServerPublish publisher = new ModelServerPublish();
                publisher.setModel(workspace);
                Spoon spoon = (Spoon)SpoonFactory.getInstance();
                try {
                    File tempF;
                    String selectedPath;
                    XulDialogPublish publishDialog = new XulDialogPublish(spoon.getShell());
                    publishDialog.setFolderTreeDepth(treeDepth);
                    publishDialog.setDatabaseMeta(databaseMeta);
                    publishDialog.setFilename(publishingFile);
                    publishDialog.setCheckDatasources(checkDatasources);
                    publishDialog.setFileMode(setShowModel);
                    publishDialog.setPathTemplate(serverPathTemplate);
                    publishDialog.setPath(cachedPath);
                    publishDialog.setSelectedServer(cachedServer);
                    publishDialog.setModelName(workspace.getModelName());
                    try {
                        publishDialog.showDialog();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (!publishDialog.isAccepted()) break block13;
                    cachedPath = selectedPath = publishDialog.getPath();
                    BiServerConnection biServerConnection = publishDialog.getBiServerConnection();
                    publisher.setBiServerConnection(biServerConnection);
                    cachedServer = biServerConnection;
                    boolean publishDatasource = publishDialog.isPublishDataSource();
                    String repositoryPath = null;
                    if (serverPathTemplate != null) {
                        String selectedSolution = null;
                        selectedSolution = selectedPath.indexOf("/") != -1 ? selectedPath.substring(0, selectedPath.indexOf("/")) : selectedPath;
                        repositoryPath = serverPathTemplate.replace("{path}", selectedSolution);
                    }
                    if (publishingFile.endsWith(".xmi")) {
                        selectedPath = repositoryPath;
                    }
                    File tempDir = new File("tmp");
                    if (!tempDir.exists()) {
                        tempDir.mkdir();
                    }
                    if (!(tempF = new File(tempDir, publishDialog.getFilename())).exists()) {
                        tempF.createNewFile();
                    }
                    tempF.deleteOnExit();
                    IOUtils.copy((InputStream)new FileInputStream(new File(fullPathtoFile)), (OutputStream)new FileOutputStream(tempF));
                    PublisherHelper.replaceAttributeValue("report", "catalog", workspace.getModelName(), tempF.getAbsolutePath());
                    publisher.publishToServer(workspace.getModelName() + ".mondrian.xml", databaseName, workspace.getModelName(), repositoryPath, selectedPath, publishDatasource, true, publishDialog.isExistentDatasource(), tempF.getAbsolutePath());
                }
                catch (XulException e) {
                    e.printStackTrace();
                    SpoonFactory.getInstance().messageBox("Could not create dialog: " + e.getLocalizedMessage(), "Dialog Error", false, 2);
                }
            }
            catch (Exception e) {
                throw new ModelerException((Throwable)e);
            }
        }
        return fullPathtoFile;
    }

    private static String replaceAttributeValue(String aElement, String anAttribute, String aValue, String aFile) throws Exception {
        String originalValue = null;
        if (aFile != null) {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(new File(aFile));
            Element root = doc.getRootElement();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                if (!element.getName().equals(aElement)) continue;
                Attribute attr = element.attribute(anAttribute);
                originalValue = attr.getValue();
                attr.setValue(aValue);
            }
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(aFile));
            writer.write(doc);
            writer.close();
        }
        return originalValue;
    }

    public static String publish(ModelerWorkspace workspace, String publishingFile, int treeDepth, DatabaseMeta databaseMeta, String filename, boolean checkDatasources, boolean setShowModel, boolean showFolders, boolean showCurrentFolder, String serverPathTemplate, String extension, String databaseName) throws ModelerException {
        try {
            if (StringUtils.isEmpty((String)publishingFile)) {
                SpoonFactory.getInstance().messageBox(BaseMessages.getString(ModelerWorkspace.class, (String)"ModelServerPublish.Publish.UnsavedModel", (String[])new String[0]), "Dialog Error", false, 2);
                throw new ModelerException(BaseMessages.getString(ModelerWorkspace.class, (String)"ModelServerPublish.Publish.UnsavedModel", (String[])new String[0]));
            }
            ModelServerPublish publisher = new ModelServerPublish();
            publisher.setModel(workspace);
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            try {
                XulDialogPublish publishDialog = new XulDialogPublish(spoon.getShell());
                publishDialog.setFolderTreeDepth(treeDepth);
                publishDialog.setDatabaseMeta(databaseMeta);
                publishDialog.setFilename(filename);
                publishDialog.setCheckDatasources(checkDatasources);
                publishDialog.setFileMode(setShowModel);
                publishDialog.setPathTemplate(serverPathTemplate);
                publishDialog.setPath(cachedPath);
                publishDialog.setSelectedServer(cachedServer);
                try {
                    publishDialog.showDialog();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (publishDialog.isAccepted()) {
                    File tempF;
                    BiServerConnection biServerConnection;
                    String selectedPath;
                    cachedPath = selectedPath = publishDialog.getPath();
                    cachedServer = biServerConnection = publishDialog.getBiServerConnection();
                    publisher.setBiServerConnection(biServerConnection);
                    boolean publishDatasource = publishDialog.isPublishDataSource();
                    String repositoryPath = null;
                    if (serverPathTemplate != null) {
                        String selectedSolution = null;
                        selectedSolution = selectedPath.indexOf("/") != -1 ? selectedPath.substring(0, selectedPath.indexOf("/")) : selectedPath;
                        repositoryPath = serverPathTemplate.replace("{path}", selectedSolution);
                    }
                    if (publishingFile.endsWith(".xmi")) {
                        selectedPath = repositoryPath;
                    }
                    filename = publishDialog.getFilename();
                    File tempDir = new File("tmp");
                    if (!tempDir.exists()) {
                        tempDir.mkdir();
                    }
                    if (!(tempF = new File(tempDir, publishDialog.getFilename() + extension)).exists()) {
                        tempF.createNewFile();
                    }
                    tempF.deleteOnExit();
                    IOUtils.copy((InputStream)new FileInputStream(new File(publishingFile)), (OutputStream)new FileOutputStream(tempF));
                    publisher.publishToServer(filename + ".mondrian.xml", databaseName, filename, repositoryPath, selectedPath, publishDatasource, true, publishDialog.isExistentDatasource(), tempF.getAbsolutePath());
                }
            }
            catch (XulException e) {
                e.printStackTrace();
                SpoonFactory.getInstance().messageBox("Could not create dialog: " + e.getLocalizedMessage(), "Dialog Error", false, 2);
            }
        }
        catch (Exception e) {
            throw new ModelerException((Throwable)e);
        }
        return filename;
    }

    public static void publishPrpt(MasterReport report, ModelerWorkspace workspace, String modelName, String prpt, int treeDepth, DatabaseMeta databaseMeta, String xmiFile, boolean checkDatasources, boolean showServerSelection, boolean showFolders, boolean showCurrentFolder, String serverPathTemplate, String databaseName) throws ModelerException {
        block13: {
            try {
                if (StringUtils.isEmpty((String)prpt)) {
                    SpoonFactory.getInstance().messageBox(BaseMessages.getString(ModelerWorkspace.class, (String)"ModelServerPublish.Publish.UnsavedModel", (String[])new String[0]), "Dialog Error", false, 2);
                    return;
                }
                ModelServerPublish publisher = new ModelServerPublish();
                publisher.setModel(workspace);
                Spoon spoon = (Spoon)SpoonFactory.getInstance();
                try {
                    String thePrptPublishingPath;
                    XulDialogPublish publishDialog = new XulDialogPublish(spoon.getShell());
                    publishDialog.setFolderTreeDepth(treeDepth);
                    publishDialog.setFileMode(true);
                    publishDialog.setDatabaseMeta(databaseMeta);
                    String name = prpt.substring(prpt.lastIndexOf(File.separator) + 1);
                    publishDialog.setFilename(name);
                    publishDialog.setCheckDatasources(checkDatasources);
                    publishDialog.setPathTemplate(serverPathTemplate);
                    publishDialog.setPath(cachedPath);
                    publishDialog.setSelectedServer(cachedServer);
                    publishDialog.setModelName(workspace.getModelName());
                    publishDialog.showDialog();
                    if (!publishDialog.isAccepted()) break block13;
                    cachedPath = thePrptPublishingPath = publishDialog.getPath();
                    BiServerConnection biServerConnection = publishDialog.getBiServerConnection();
                    publisher.setBiServerConnection(biServerConnection);
                    cachedServer = biServerConnection;
                    boolean publishDatasource = publishDialog.isPublishDataSource();
                    String theXmiPublishingPath = null;
                    if (serverPathTemplate != null) {
                        String theSolution = null;
                        theSolution = thePrptPublishingPath.indexOf("/") != -1 ? thePrptPublishingPath.substring(0, thePrptPublishingPath.indexOf("/")) : thePrptPublishingPath;
                        theXmiPublishingPath = serverPathTemplate.replace("{path}", theSolution);
                    }
                    String theXmiFile = xmiFile.substring(xmiFile.lastIndexOf(File.separator) + 1, xmiFile.length());
                    PmdDataFactory thePmdDataFactory = (PmdDataFactory)report.getDataFactory();
                    String theDomainId = theXmiPublishingPath + "/" + theXmiFile;
                    thePmdDataFactory.setDomainId(theDomainId);
                    String theMQLQuery = thePmdDataFactory.getQuery("default");
                    String theQuery = theMQLQuery.substring(0, theMQLQuery.indexOf("<domain_id>") + 11) + theDomainId + theMQLQuery.substring(theMQLQuery.indexOf("</domain_id>"));
                    thePmdDataFactory.setQuery("default", theQuery);
                    try {
                        File tempF;
                        File tempDir = new File("tmp");
                        if (!tempDir.exists()) {
                            tempDir.mkdir();
                        }
                        if (!(tempF = new File(tempDir, publishDialog.getFilename())).exists()) {
                            tempF.createNewFile();
                        }
                        tempF.deleteOnExit();
                        BundleWriter.writeReportToZipFile((MasterReport)report, (File)tempF);
                        publisher.publishPrptToServer(theXmiPublishingPath, thePrptPublishingPath, publishDatasource, publishDialog.isExistentDatasource(), publishDialog.isPublishXmi(), xmiFile, tempF.getAbsolutePath());
                    }
                    catch (Exception e) {
                        throw new ModelerException((Throwable)e);
                    }
                    finally {
                        thePmdDataFactory.setQuery("default", theMQLQuery);
                    }
                }
                catch (XulException e) {
                    e.printStackTrace();
                    SpoonFactory.getInstance().messageBox("Could not create dialog: " + e.getLocalizedMessage(), "Dialog Error", false, 2);
                }
            }
            catch (Exception e) {
                throw new ModelerException((Throwable)e);
            }
        }
    }

    public static String getBiServerCompatibleDatabaseName(String name) {
        if (name == null) {
            return null;
        }
        return name.replaceAll("\\s", "_");
    }
}

