/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.publish;

import java.util.List;
import org.pentaho.commons.util.repository.type.CmisObject;
import org.pentaho.commons.util.repository.type.TypesOfFileableObjects;
import org.pentaho.platform.util.client.BiPlatformRepositoryClientNavigationService;
import org.pentaho.ui.xul.util.AbstractModelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolutionObject
extends AbstractModelNode<SolutionObject> {
    private String name;
    private CmisObject cmisObject;
    private BiPlatformRepositoryClientNavigationService navigationService;

    public SolutionObject() {
    }

    public SolutionObject(CmisObject cmisObject, BiPlatformRepositoryClientNavigationService navigationService, int maxDepth) {
        this.cmisObject = cmisObject;
        this.name = cmisObject.findStringProperty("LocalizedName", null);
        this.navigationService = navigationService;
        try {
            List children = navigationService.getDescendants("PLATFORMORIG", cmisObject.findIdProperty("ObjectId", null), new TypesOfFileableObjects("folders"), 1, null, false, false);
            if (maxDepth == -1 || this.calculateDepth() < maxDepth) {
                for (CmisObject obj : children) {
                    this.add(new SolutionObject(obj, navigationService, maxDepth));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean add(SolutionObject child) {
        child.setParent(this);
        return super.add((Object)child);
    }

    private int calculateDepth() {
        int d = 0;
        SolutionObject parent = this;
        while (parent != null) {
            ++d;
            parent = (SolutionObject)this.getParent();
        }
        return d;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CmisObject getCmisObject() {
        return this.cmisObject;
    }

    public void setCmisObject(CmisObject cmisObject) {
        this.cmisObject = cmisObject;
    }

    public String getImage() {
        if (this.cmisObject == null) {
            return null;
        }
        String type = this.cmisObject.findStringProperty("ObjectTypeId", null);
        if ("Folder".equals(type)) {
            return "images/sm_folder_icon.png";
        }
        return null;
    }
}

