/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.publish;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.agilebi.spoon.AbstractSwtXulDialogController;
import org.pentaho.agilebi.spoon.publish.BiServerConfig;
import org.pentaho.agilebi.spoon.publish.BiServerConfigUtil;
import org.pentaho.agilebi.spoon.publish.BiServerConnection;
import org.pentaho.agilebi.spoon.publish.BiServerConnectionForm;
import org.pentaho.agilebi.spoon.publish.ModelServerPublish;
import org.pentaho.agilebi.spoon.publish.PublishException;
import org.pentaho.agilebi.spoon.publish.PublishOverwriteDelegate;
import org.pentaho.agilebi.spoon.publish.SolutionObject;
import org.pentaho.agilebi.spoon.publish.XulDialogPublishModel;
import org.pentaho.commons.util.repository.type.CmisObject;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingException;
import org.pentaho.ui.xul.binding.BindingExceptionHandler;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.WaitBoxRunnable;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulCheckbox;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.components.XulWaitBox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulListbox;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.util.XulDialogCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XulDialogPublish
extends AbstractSwtXulDialogController
implements BindingExceptionHandler,
PublishOverwriteDelegate {
    private static Logger logger = LoggerFactory.getLogger(XulDialogPublish.class);
    private int folderTreeDepth = 99;
    private BindingFactory bf = new SwtBindingFactory();
    private XulListbox serverMenuList;
    private XulTextbox folderTextbox;
    private XulTree filesBox;
    private XulButton okButton;
    private XulCheckbox publishDatasourceCheck;
    private XulCheckbox publishModelCheck;
    private BiServerConfig biServerConfig;
    private ModelServerPublish publisher;
    private DatabaseMeta databaseMeta;
    private boolean publishDataSource = false;
    private boolean checkDatasources = false;
    private boolean accepted = false;
    private boolean datasourceExists = false;
    private CmisObject currentFolder;
    private String pathTemplate = "{path}{file}";
    private XulDialog biserverDialog;
    private XulDialogPublishModel publishModel;
    private XulDialog folderSelectionDialog;
    private XulTree folderTree;
    private XulButton folderSelectionDialogAccept;
    private boolean fileMode;
    private BiServerConnectionForm biserverForm = new BiServerConnectionForm();
    private XulTextbox publishpassword;
    private XulTextbox password;
    private XulTextbox userid;
    private XulTextbox url;
    private XulTextbox name;
    private boolean doNotPublishDatasource;
    private boolean addingNewServer;

    public XulDialogPublish(Shell shell) throws XulException {
        super(shell);
        this.setName("dialog");
        this.initDialogController("org/pentaho/agilebi/spoon/publish/res/publish.xul", "publish", null, null);
    }

    protected Object getDialogResult() {
        return null;
    }

    public Logger getLogger() {
        return logger;
    }

    public void init() {
        ModelServerPublish.overwriteDelegate = this;
        this.biServerConfig = BiServerConfig.getInstance();
        this.publishModel = new XulDialogPublishModel(this.biServerConfig);
        this.bf.setDocument(this.document);
        this.bf.setExceptionHandler((BindingExceptionHandler)this);
        this.folderTextbox = (XulTextbox)this.document.getElementById("folderTextbox");
        this.serverMenuList = (XulListbox)this.document.getElementById("serverlist");
        this.filesBox = (XulTree)this.document.getElementById("filesBox");
        this.okButton = (XulButton)this.document.getElementById("publish_accept");
        this.publishDatasourceCheck = (XulCheckbox)this.document.getElementById("publishDatasource");
        this.publishModelCheck = (XulCheckbox)this.document.getElementById("publishModel");
        this.biserverDialog = (XulDialog)this.document.getElementById("biserverEditDialog");
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.publishModel, "filename", "filename", "value", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.publishModel, "path", (Object)this.folderTextbox, "value", new BindingConvertor[0]);
        Binding serverListBinding = this.bf.createBinding((Object)this.publishModel.getServerCollection(), "children", (Object)this.serverMenuList, "elements", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        Binding serverListBindingIdx = this.bf.createBinding((Object)this.publishModel, "selectedConnection", (Object)this.serverMenuList, "selectedItem", new BindingConvertor[0]);
        this.publishpassword = (XulTextbox)this.document.getElementById("publishpassword");
        this.password = (XulTextbox)this.document.getElementById("password");
        this.userid = (XulTextbox)this.document.getElementById("userid");
        this.url = (XulTextbox)this.document.getElementById("url");
        this.name = (XulTextbox)this.document.getElementById("name");
        this.bf.createBinding((Object)this.biserverForm, "userId", (Object)this.userid, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.biserverForm, "password", (Object)this.password, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.biserverForm, "publishPassword", (Object)this.publishpassword, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.biserverForm, "url", (Object)this.url, "value", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.biserverForm, "name", (Object)this.name, "value", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.bf.createBinding((Object)this.serverMenuList, "selectedItem", (Object)this, "selectedServer", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.biserverForm, "valid", (Object)this.document.getElementById("biserverEditDialog_accept"), "!disabled", new BindingConvertor[0]);
        BindingConvertor<BiServerConnection, Boolean> btnConvertor = new BindingConvertor<BiServerConnection, Boolean>(){

            public Boolean sourceToTarget(BiServerConnection arg0) {
                return arg0 == null;
            }

            public BiServerConnection targetToSource(Boolean arg0) {
                return null;
            }
        };
        this.bf.createBinding((Object)this.publishModel, "selectedConnection", "editServerBtn", "disabled", new BindingConvertor[]{btnConvertor});
        this.bf.createBinding((Object)this.publishModel, "selectedConnection", "deleteServerBtn", "disabled", new BindingConvertor[]{btnConvertor});
        this.bf.createBinding((Object)this.publishModel, "selectedConnection", "browseBtn", "disabled", new BindingConvertor[]{btnConvertor});
        this.folderSelectionDialog = (XulDialog)this.document.getElementById("folderSelectionDialog");
        this.folderTree = (XulTree)this.document.getElementById("folderTree");
        this.folderSelectionDialogAccept = (XulButton)this.document.getElementById("folderSelectionDialog_accept");
        this.bf.createBinding((Object)this.publishModel, "solutions", (Object)this.folderTree, "elements", new BindingConvertor[0]);
        this.bf.createBinding((Object)this.folderTree, "selectedItem", (Object)this.folderSelectionDialogAccept, "disabled", new BindingConvertor[]{new BindingConvertor<Object, Boolean>(){

            public Boolean sourceToTarget(Object arg0) {
                return arg0 == null;
            }

            public Object targetToSource(Boolean arg0) {
                return null;
            }
        }});
        Binding modelNameBinding = this.bf.createBinding((Object)this.publishModel, "modelName", (Object)this.publishModelCheck, "label", new BindingConvertor[]{new BindingConvertor<String, String>(){

            public String sourceToTarget(String value) {
                return BaseMessages.getString(((Object)((Object)this)).getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Model", (String[])new String[]{value});
            }

            public String targetToSource(String value) {
                return null;
            }
        }});
        this.bf.createBinding((Object)this.publishModelCheck, "checked", (Object)this.publishModel, "publishXmi", new BindingConvertor[0]);
        Binding validBinding = this.bf.createBinding((Object)this.publishModel, "valid", "publish_accept", "!disabled", new BindingConvertor[0]);
        try {
            serverListBinding.fireSourceChanged();
            serverListBindingIdx.fireSourceChanged();
            modelNameBinding.fireSourceChanged();
            validBinding.fireSourceChanged();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setFilename(String fName) {
        this.publishModel.setFilename(fName);
    }

    public String getFilename() {
        return this.publishModel.getFilename();
    }

    public BiServerConnection getBiServerConnection() {
        return this.publishModel.getSelectedConnection();
    }

    public void browseServer() {
        final boolean isPublishDataSourceCheck = this.publishDatasourceCheck.isChecked();
        if (!this.publishModel.isConnected()) {
            try {
                XulWaitBox wait = (XulWaitBox)this.document.createElement("waitbox");
                wait.setTitle(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Connect.Title", (String[])new String[0]));
                wait.setMessage(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Connect.Message", (String[])new String[0]));
                wait.setIndeterminate(true);
                wait.setDialogParent(this.getDialog().getRootObject());
                wait.setRunnable(new WaitBoxRunnable(wait){

                    public void cancel() {
                    }

                    public void run() {
                        boolean connected = XulDialogPublish.this.connect();
                        XulDialogPublish.this.publishDataSource = !XulDialogPublish.this.doNotPublishDatasource && isPublishDataSourceCheck;
                        this.waitBox.stop();
                        if (!connected) {
                            return;
                        }
                        XulDialogPublish.this.publishModel.setConnected(true);
                        XulDialogPublish.this.document.invokeLater(new Runnable(){

                            public void run() {
                                XulDialogPublish.this.folderSelectionDialog.show();
                            }
                        });
                    }
                });
                wait.start();
            }
            catch (XulException e) {
                logger.debug("Error browsing server", (Throwable)e);
                this.connect();
                this.folderSelectionDialog.show();
            }
        } else {
            this.folderSelectionDialog.show();
        }
    }

    public void folderAccept() {
        this.publishModel.setSelectedFolder((SolutionObject)((Object)this.folderTree.getSelectedItem()));
        this.folderSelectionDialog.hide();
    }

    public void folderCancel() {
        this.folderSelectionDialog.hide();
    }

    protected void changePath() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> folders = new ArrayList<String>();
        if (this.currentFolder != null) {
            CmisObject folder = this.currentFolder;
            while (folder != null) {
                folders.add(0, folder.findStringProperty("LocalizedName", null));
                try {
                    List objects = this.publisher.getNavigationService().getFolderParent("PLATFORMORIG", folder.findIdProperty("ObjectId", null), null, false, false, false);
                    if (objects != null && objects.size() > 0) {
                        folder = (CmisObject)objects.get(0);
                        continue;
                    }
                    folder = null;
                    break;
                }
                catch (Exception e) {
                    folder = null;
                    logger.error("Error navigating path", (Throwable)e);
                }
            }
        }
        for (String folderName : folders) {
            if ("".equals(folderName)) continue;
            sb.append('/').append(folderName);
        }
        sb.append('/');
        String tmp = sb.toString();
        String path = this.pathTemplate.replace("{path}", tmp);
        this.folderTextbox.setValue(path);
    }

    public void okClick() {
        final boolean isPublishDataSourceCheck = this.publishDatasourceCheck.isChecked();
        this.accepted = true;
        if (!this.publishModel.isConnected()) {
            try {
                XulWaitBox wait = (XulWaitBox)this.document.createElement("waitbox");
                wait.setTitle(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Connect.Title", (String[])new String[0]));
                wait.setMessage(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Connect.Message", (String[])new String[0]));
                wait.setIndeterminate(true);
                wait.setDialogParent(this.getDialog().getRootObject());
                wait.setRunnable(new WaitBoxRunnable(wait){

                    public void cancel() {
                    }

                    public void run() {
                        boolean connected = XulDialogPublish.this.connect();
                        XulDialogPublish.this.publishDataSource = !XulDialogPublish.this.doNotPublishDatasource && isPublishDataSourceCheck;
                        this.waitBox.stop();
                        if (!connected) {
                            return;
                        }
                        XulDialogPublish.this.document.invokeLater(new Runnable(){

                            public void run() {
                                XulDialogPublish.this.onDialogAccept();
                            }
                        });
                    }
                });
                wait.start();
            }
            catch (XulException e) {
                logger.debug("error connecting", (Throwable)e);
                this.connect();
                this.onDialogAccept();
            }
        } else {
            this.onDialogAccept();
        }
    }

    public void cancelClick() {
        this.onDialogCancel();
    }

    public void setFolderTreeDepth(int folderTreeDepth) {
        this.publishModel.setFolderTreeDepth(folderTreeDepth);
    }

    protected boolean connect() {
        try {
            this.publisher = new ModelServerPublish();
            this.publisher.setBiServerConnection(this.publishModel.getSelectedConnection());
            this.checkDatasources();
            this.publishModel.createSolutionTree();
            this.publishModel.setSelectedFolder(null);
        }
        catch (Exception e) {
            logger.error("Error connecting", (Throwable)e);
            e.printStackTrace();
            SpoonFactory.getInstance().messageBox(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.CouldNotGetDataSources", (String[])new String[]{e.getLocalizedMessage()}), BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Error", (String[])new String[0]), false, 2);
            return false;
        }
        return true;
    }

    private void checkDatasources() throws Exception {
        if (this.publisher == null) {
            return;
        }
        int result = this.publisher.compareDataSourceWithRemoteConnection(this.databaseMeta);
        switch (result) {
            case 4: {
                this.doNotPublishDatasource = true;
                this.datasourceExists = true;
                break;
            }
            case 1: {
                this.datasourceExists = false;
                this.doNotPublishDatasource = false;
                break;
            }
            case 8: {
                this.doNotPublishDatasource = true;
                this.datasourceExists = false;
                break;
            }
            case 2: {
                this.datasourceExists = true;
                this.doNotPublishDatasource = false;
            }
        }
    }

    public boolean isExistentDatasource() {
        return this.datasourceExists;
    }

    public void setSelectedServer(BiServerConnection selectedServer) {
        this.currentFolder = null;
        this.publishModel.setSelectedConnection(selectedServer);
    }

    public void editServer() {
        if (this.publishModel.getSelectedConnection() == null) {
            return;
        }
        this.addingNewServer = false;
        this.biserverForm.setConn(this.publishModel.getSelectedConnection());
        this.biserverDialog.show();
        this.biServerConfig.save();
    }

    public void newServer() {
        this.addingNewServer = true;
        this.biserverForm.setConn(new BiServerConnection());
        this.biserverDialog.show();
        this.biServerConfig.save();
    }

    public void deleteServer() {
        try {
            XulConfirmBox confirm = (XulConfirmBox)this.document.createElement("confirmbox");
            confirm.setTitle(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.DeleteServer.Title", (String[])new String[0]));
            confirm.setMessage(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.DeleteServer.Message", (String[])new String[0]));
            confirm.addDialogCallback(new XulDialogCallback(){

                public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                    if (returnCode != XulDialogCallback.Status.ACCEPT) {
                        return;
                    }
                    XulDialogPublish.this.biServerConfig.getServerConnections().remove(XulDialogPublish.this.publishModel.getSelectedConnection());
                    XulDialogPublish.this.biServerConfig.save();
                    XulDialogPublish.this.publishModel.setSelectedConnection(null);
                }

                public void onError(XulComponent sender, Throwable t) {
                    logger.error("Error deleting server", t);
                    XulDialogPublish.this.biServerConfig.getServerConnections().remove(XulDialogPublish.this.publishModel.getSelectedConnection());
                    XulDialogPublish.this.biServerConfig.save();
                    XulDialogPublish.this.publishModel.setSelectedConnection(null);
                }
            });
            confirm.open();
        }
        catch (XulException e) {
            logger.error("Error deleting server", (Throwable)e);
            this.biServerConfig.getServerConnections().remove(this.publishModel.getSelectedConnection());
            this.biServerConfig.save();
            this.publishModel.setSelectedConnection(null);
        }
    }

    public void testServerConnection() {
        BiServerConfigUtil.testServerConnection(this.biserverForm.getConnectionCopy());
    }

    public void biserverCancel() {
        this.biserverDialog.hide();
    }

    public void biserverAccept() {
        this.biserverDialog.hide();
        BiServerConnection conn = this.biserverForm.saveConn();
        if (this.addingNewServer) {
            this.biServerConfig.getServerConnections().add(conn);
        }
        this.biServerConfig.save();
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta databaseMeta) {
        this.databaseMeta = databaseMeta;
        XulCheckbox datasourceCheck = (XulCheckbox)this.document.getElementById("publishDatasource");
        datasourceCheck.setLabel(BaseMessages.getString(this.getClass(), (String)"Spoon.Perspectives.AgileBi.Publish.Data", (String[])new String[]{databaseMeta.getName()}));
    }

    public boolean isPublishDataSource() {
        return this.publishDataSource;
    }

    public void setPublishDataSource(boolean publishDataSource) {
        this.publishDataSource = publishDataSource;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public String getPath() {
        return this.publishModel.getPath();
    }

    public void setShowDatasourceStatus(boolean showDatasourceStatus) {
        XulComponent component = this.document.getElementById("datasourceGroupBox");
        component.setVisible(showDatasourceStatus);
    }

    public String getPathTemplate() {
        return this.pathTemplate;
    }

    public void setPathTemplate(String pathTemplate) {
        this.pathTemplate = pathTemplate;
    }

    public void setCheckDatasources(boolean checkDatasources) {
        this.checkDatasources = checkDatasources;
    }

    public void handleException(BindingException t) {
        PublishException ex = this.extractPublishException(t);
        if (ex == null) {
            logger.error("Unknown Exception", (Throwable)t);
            t.printStackTrace();
            return;
        }
        logger.error("Unknown exception", (Throwable)ex);
        try {
            XulMessageBox msg = (XulMessageBox)this.document.createElement("messagebox");
            msg.setTitle(BaseMessages.getString(this.getClass(), (String)"connection.error.title", (String[])new String[0]));
            msg.setMessage(BaseMessages.getString(this.getClass(), (String)"connection.error.message", (String[])new String[]{ex.getMessage()}));
            msg.setIcon((Object)39);
            msg.open();
        }
        catch (XulException xulException) {
            // empty catch block
        }
    }

    private PublishException extractPublishException(BindingException e) {
        Object curr;
        for (curr = e; curr != null && !(curr instanceof PublishException); curr = curr.getCause()) {
        }
        return (PublishException)(curr instanceof PublishException ? curr : null);
    }

    public boolean isPublishXmi() {
        return this.publishModel.isPublishXmi();
    }

    public void setFileMode(boolean b) {
        this.fileMode = b;
        this.publishModelCheck.setVisible(b);
    }

    public void setPath(String path) {
        this.publishModel.setPath(path);
    }

    public void setModelName(String name) {
        this.publishModel.setModelName(name);
    }

    public boolean handleOverwriteNotification(String name) {
        try {
            XulConfirmBox confirm = (XulConfirmBox)this.document.createElement("confirmbox");
            confirm.setModalParent(this.getDialog().getRootObject());
            confirm.setTitle(BaseMessages.getString(this.getClass(), (String)"Publish.Overwrite.Title", (String[])new String[0]));
            confirm.setMessage(BaseMessages.getString(this.getClass(), (String)"Publish.Overwrite.Message", (String[])new String[]{name}));
            if (confirm.open() == 64) {
                return true;
            }
        }
        catch (XulException e) {
            logger.error("Errpr showing overwrite notification", (Throwable)e);
            return false;
        }
        return false;
    }
}

