/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.publish;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.pentaho.agilebi.spoon.publish.BiServerConfig;
import org.pentaho.agilebi.spoon.publish.BiServerConnection;
import org.pentaho.agilebi.spoon.publish.BiServerConnectionCollection;
import org.pentaho.agilebi.spoon.publish.PublishException;
import org.pentaho.agilebi.spoon.publish.SolutionObject;
import org.pentaho.commons.util.repository.type.CmisObject;
import org.pentaho.commons.util.repository.type.TypesOfFileableObjects;
import org.pentaho.platform.util.client.BiPlatformRepositoryClient;
import org.pentaho.platform.util.client.BiPlatformRepositoryClientNavigationService;
import org.pentaho.ui.xul.XulEventSourceAdapter;

public class XulDialogPublishModel
extends XulEventSourceAdapter {
    private BiServerConnection selectedConnection;
    private BiServerConnectionCollection serverCollection;
    private String filename;
    private SolutionObject solutions;
    private SolutionObject selectedFolder;
    private int folderTreeDepth = -1;
    private BiPlatformRepositoryClientNavigationService navigationService;
    private boolean publishXmi = true;
    private BiPlatformRepositoryClient client;
    private boolean isValid;
    private boolean connected;
    private String path;
    private String modelName;

    public XulDialogPublishModel(BiServerConfig config) {
        this.setServerCollection(config.getServerConnections());
    }

    public BiServerConnection getSelectedConnection() {
        return this.selectedConnection;
    }

    public void setSelectedConnection(BiServerConnection selectedConnection) {
        BiServerConnection prevVal = this.selectedConnection;
        this.selectedConnection = selectedConnection;
        if (prevVal != selectedConnection) {
            this.setConnected(false);
        }
        this.firePropertyChange("selectedConnection", prevVal, this.selectedConnection);
        this.calculateValidity();
    }

    public BiServerConnectionCollection getServerCollection() {
        return this.serverCollection;
    }

    public void setServerCollection(BiServerConnectionCollection serverCollection) {
        this.serverCollection = serverCollection;
        this.firePropertyChange("serverCollection", null, (Object)this.serverCollection);
        this.calculateValidity();
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        String prevVal = this.filename;
        this.filename = filename;
        this.firePropertyChange("filename", prevVal, this.filename);
        this.calculateValidity();
    }

    public SolutionObject getSolutions() {
        return this.solutions;
    }

    public void setSolutions(SolutionObject solutions) {
        this.solutions = solutions;
        this.firePropertyChange("solutions", null, (Object)this.solutions);
        this.calculateValidity();
    }

    public void createSolutionTree() throws PublishException {
        BiPlatformRepositoryClient client = new BiPlatformRepositoryClient();
        client.setServerUri(this.selectedConnection.getUrl());
        client.setUserId(this.selectedConnection.getUserId());
        client.setPassword(this.selectedConnection.getPassword());
        try {
            client.connect();
        }
        catch (Exception e) {
            throw new PublishException("Could not connect to the server", e);
        }
        try {
            this.navigationService = client.getNavigationService();
            List solutions = this.navigationService.getDescendants("PLATFORMORIG", "", new TypesOfFileableObjects("folders"), 1, null, false, false);
            SolutionObject root = new SolutionObject();
            for (CmisObject obj : solutions) {
                root.add(new SolutionObject(obj, this.navigationService, this.folderTreeDepth));
            }
            this.setSolutions(root);
        }
        catch (Exception e) {
            throw new PublishException("Error building solution document", e);
        }
    }

    public BiPlatformRepositoryClientNavigationService getNavigationService() {
        return this.navigationService;
    }

    public SolutionObject getSelectedFolder() {
        return this.selectedFolder;
    }

    public void setSelectedFolder(SolutionObject selectedFolder) {
        SolutionObject prevVal = this.selectedFolder;
        this.selectedFolder = selectedFolder;
        if (this.getNavigationService() != null && this.getSelectedFolder() != null) {
            this.setPath(this.getNavigationService().getRepositoryPath(this.getSelectedFolder().getCmisObject()));
        }
        this.firePropertyChange("selectedFolder", (Object)prevVal, (Object)this.selectedFolder);
        this.calculateValidity();
    }

    public int getFolderTreeDepth() {
        return this.folderTreeDepth;
    }

    public void setFolderTreeDepth(int folderTreeDepth) {
        this.folderTreeDepth = folderTreeDepth;
    }

    public boolean isPublishXmi() {
        return this.publishXmi;
    }

    public void setPublishXmi(boolean publish) {
        this.publishXmi = publish;
    }

    private void calculateValidity() {
        this.firePropertyChange("valid", null, this.isValid());
    }

    public boolean isValid() {
        return StringUtils.isNotEmpty((String)this.getFilename()) && this.path != null && this.selectedConnection != null;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String prevVal = this.path;
        this.path = path;
        this.firePropertyChange("path", prevVal, this.path);
        this.calculateValidity();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        String prevVal = this.modelName;
        this.modelName = modelName;
        this.firePropertyChange("modelName", prevVal, this.modelName);
    }
}

