/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.visualizations;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizationManager {
    private File pluginsLocation;
    private List<IVisualization> visualizations = new ArrayList<IVisualization>();
    private static VisualizationManager instance;
    public static final String PLUGIN_FILE = "plugin.xml";

    public static VisualizationManager getInstance() {
        if (instance == null) {
            instance = new VisualizationManager("plugins/spoon/agile-bi/visualizations");
        }
        return instance;
    }

    protected VisualizationManager() {
    }

    public VisualizationManager(String aLocation) {
        this.pluginsLocation = new File(aLocation);
        this.loadVisualizations(this.pluginsLocation);
    }

    private void loadVisualizations(File aDir) {
        File[] theFiles = aDir.listFiles();
        if (theFiles == null) {
            return;
        }
        for (int i = 0; i < theFiles.length; ++i) {
            File theFile = theFiles[i];
            if (!theFile.isDirectory()) continue;
            File[] dirFiles = theFile.listFiles();
            for (int j = 0; j < dirFiles.length; ++j) {
                File pluginFile = dirFiles[j];
                if (!pluginFile.getName().equals(PLUGIN_FILE)) continue;
                this.loadVisualizationFile(pluginFile);
            }
        }
        Collections.sort(this.visualizations, new Comparator(){

            public int compare(Object o1, Object o2) {
                IVisualization v1 = (IVisualization)o1;
                IVisualization v2 = (IVisualization)o2;
                if (v1.getOrder() > v2.getOrder()) {
                    return -1;
                }
                if (v1.getOrder() < v2.getOrder()) {
                    return 1;
                }
                return v1.getTitle().compareTo(v2.getTitle());
            }
        });
    }

    protected void loadVisualizationFile(File file) {
        try {
            FileSystemXmlApplicationContext context = new FileSystemXmlApplicationContext(new String[]{file.getPath()}, false);
            context.setClassLoader(this.getClass().getClassLoader());
            context.refresh();
            Map beans = context.getBeansOfType(IVisualization.class);
            for (Object key : beans.keySet()) {
                IVisualization vis = (IVisualization)beans.get(key);
                if (vis.getOrder() < 0) continue;
                this.visualizations.add(vis);
            }
        }
        catch (XmlBeanDefinitionStoreException e) {
            e.printStackTrace();
        }
    }

    public List<IVisualization> getVisualizations() {
        return this.visualizations;
    }

    public List<String> getVisualizationNames() {
        ArrayList<String> theNames = new ArrayList<String>();
        List<IVisualization> theVisualizations = this.getVisualizations();
        for (IVisualization theVisualization : theVisualizations) {
            theNames.add(theVisualization.getTitle());
        }
        return theNames;
    }

    public IVisualization getVisualization(String aVisualization) {
        List<IVisualization> theVisualizations = this.getVisualizations();
        Iterator<IVisualization> theItr = theVisualizations.iterator();
        IVisualization theVisualization = null;
        while (theItr.hasNext() && !(theVisualization = theItr.next()).getTitle().equals(aVisualization)) {
            theVisualization = null;
        }
        return theVisualization;
    }
}

