/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.visualizations.analyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jaxen.JaxenException;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;
import org.jaxen.dom4j.Dom4jXPath;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerPerspective;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelerSourceFactory;
import org.pentaho.agilebi.spoon.ModelerHelper;
import org.pentaho.agilebi.spoon.PDIMessages;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.perspective.AbstractPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiVisualizationPerspective;
import org.pentaho.agilebi.spoon.visualizations.AbstractVisualization;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.analyzer.AnalyzerVisualizationController;
import org.pentaho.agilebi.spoon.visualizations.analyzer.AnalyzerVisualizationMeta;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.lifecycle.pdi.AgileBILifecycleListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.RegistryFactory;
import org.pentaho.metadata.registry.Type;
import org.pentaho.metadata.registry.Verb;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzerVisualization
extends AbstractVisualization {
    public static final String WEB_VISUALIZATION = "org/pentaho/agilebi/spoon/visualizations/analyzer/analyzer_visualization_browser.xul";
    private static Logger logger = LoggerFactory.getLogger(AnalyzerVisualization.class);
    private String newUrl;
    private String openUrl;
    private String saveJavascript;
    private String callerId;
    private String refreshDataJavascript;
    private String refreshModelJavascript;
    private String getStateJavascript;
    private String setStateJavascript;
    private String reportName;

    public String getId() {
        return "ANALYZER";
    }

    public String getNewUrl() {
        return this.newUrl;
    }

    public void setNewUrl(String aUrl) {
        this.newUrl = aUrl;
    }

    public String getOpenUrl() {
        return this.openUrl;
    }

    public void setOpenUrl(String openUrl) {
        this.openUrl = openUrl;
    }

    public void setSaveJavascript(String saveJavascript) {
        this.saveJavascript = saveJavascript;
    }

    public String getSaveJavascript() {
        return this.saveJavascript;
    }

    public void setRefreshDataJavascript(String refreshDataJavascript) {
        this.refreshDataJavascript = refreshDataJavascript;
    }

    public String getRefreshDataJavascript() {
        return this.refreshDataJavascript;
    }

    public void setRefreshModelJavascript(String refreshModelJavascript) {
        this.refreshModelJavascript = refreshModelJavascript;
    }

    public String getRefreshModelJavascript() {
        return this.refreshModelJavascript;
    }

    public String generateSaveJavascript(String filename) {
        String[] pathAndFilename = this.getPathAndFilename(filename);
        String str = this.replaceField(this.saveJavascript, "path", pathAndFilename[0], true);
        str = this.replaceField(str, "filename", pathAndFilename[1], false);
        str = this.replaceField(str, "port", "" + AgileBILifecycleListener.consolePort, false);
        return str;
    }

    public String generateOpenUrl(String filename) {
        String[] pathAndFilename = this.getPathAndFilename(filename);
        String str = this.replaceField(this.openUrl, "path", pathAndFilename[0], true);
        str = this.replaceField(str, "filename", pathAndFilename[1], true);
        str = this.replaceField(str, "port", "" + AgileBILifecycleListener.consolePort, false);
        return str;
    }

    private String replaceField(String str, String fieldName, String value, boolean urlEncode) {
        if (urlEncode) {
            value = URLEncoder.encode(value);
        }
        return str.replaceAll("\\$\\{" + fieldName + "\\}", value);
    }

    public String generateNewUrl(String fileLocation, String modelId) {
        String str = this.replaceField(this.newUrl, "modelLocation", fileLocation, true);
        str = this.replaceField(str, "modelId", modelId, true);
        str = this.replaceField(str, "port", "" + AgileBILifecycleListener.consolePort, false);
        long avoidBrowserCache = Calendar.getInstance().getTimeInMillis();
        str = str + "&rnd=" + avoidBrowserCache;
        return str;
    }

    public String generateRefreshDataJavascript(String fileLocation, String modelId) {
        String str = this.replaceField(this.refreshDataJavascript, "modelLocation", fileLocation, true);
        str = this.replaceField(str, "modelId", modelId, true);
        str = this.replaceField(str, "port", "" + AgileBILifecycleListener.consolePort, false);
        return str;
    }

    public String generateRefreshModelJavascript(String fileLocation, String modelId) {
        String str = this.replaceField(this.refreshModelJavascript, "modelLocation", fileLocation, true);
        str = str.replaceAll("tmpview", this.reportName);
        str = this.replaceField(str, "modelId", modelId, true);
        str = this.replaceField(str, "port", "" + AgileBILifecycleListener.consolePort, false);
        str = this.replaceField(str, "basedir", new File("").getAbsolutePath(), true);
        return str;
    }

    public void createVisualizationFromModel(ModelerWorkspace model, boolean tempModel) {
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        try {
            if (tempModel) {
                ModelerHelper theHelper = ModelerHelper.getInstance();
                model = theHelper.clone(model);
            }
            SwtXulLoader theXulLoader = new SwtXulLoader();
            theXulLoader.registerClassLoader((Object)this.getClass().getClassLoader());
            String theFileName = model.getFileName();
            if (theFileName == null) {
                theFileName = "models/" + model.getModelName() + ".xmi";
            }
            this.flushAnalyzerCache();
            AnalyzerVisualizationController theController = new AnalyzerVisualizationController((Composite)spoon.tabfolder.getSwtTabset(), this, theFileName, model.getModelName(), null, null);
            theController.setModel(model);
            XulDomContainer theXulContainer = theXulLoader.loadXul(WEB_VISUALIZATION, (Object)new PDIMessages(IVisualization.class));
            theXulContainer.addEventHandler((XulEventHandler)theController);
            Composite theMainBox = (Composite)theXulContainer.getDocumentRoot().getElementById("mainVBox").getManagedObject();
            SwtXulRunner theRunner = new SwtXulRunner();
            theRunner.addContainer(theXulContainer);
            theRunner.initialize();
            this.createTabForBrowser(theMainBox, theController, model);
            this.reportName = "Unsaved Report";
            String contentId = "020-agilebiVisualization\t" + theController.toString();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private void flushAnalyzerCache() {
        ICacheManager cacheMgr = PentahoSystem.getCacheManager(null);
        if (cacheMgr != null) {
            cacheMgr.clearRegionCache("mondrian-catalog-cache");
        }
    }

    private void createTabForBrowser(Composite composite, AnalyzerVisualizationController controller, ModelerWorkspace model) throws KettleException {
        SpoonPerspectiveManager.getInstance().activatePerspective(AgileBiVisualizationPerspective.class);
        AbstractPerspective.XulTabAndPanel tabAndPanel = AgileBiVisualizationPerspective.getInstance().createTab();
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 4;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)layoutData);
        Composite parentComposite = (Composite)tabAndPanel.panel.getManagedObject();
        composite.setParent(parentComposite);
        parentComposite.layout(true);
        controller.getMeta().setTab(tabAndPanel.tab);
        AgileBiVisualizationPerspective.getInstance().setNameForTab(tabAndPanel.tab, controller.getMeta().getName());
        AgileBiVisualizationPerspective.getInstance().setMetaForTab(tabAndPanel.tab, controller.getMeta());
        AgileBiVisualizationPerspective.getInstance().setModel(model);
        AgileBiVisualizationPerspective.getInstance().setSelectedMeta(controller.getMeta());
        Spoon.getInstance().enableMenus();
    }

    public static Document getXAnalyzerDocument(File file) throws Exception {
        FileInputStream in = new FileInputStream(file);
        StringBuilder sb = new StringBuilder();
        byte[] b = new byte[2048];
        int n = in.read(b);
        while (n != -1) {
            sb.append(new String(b, 0, n));
            n = in.read(b);
        }
        Document doc = DocumentHelper.parseText((String)sb.toString());
        return doc;
    }

    public static String getDocumentText(Document doc, String xPath) throws JaxenException {
        Dom4jXPath xpath = new Dom4jXPath(xPath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pho", "http://www.pentaho.com");
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
        Node node = (Node)xpath.selectSingleNode((Object)doc);
        return node.getText();
    }

    public static void setDocumentText(Document doc, String xPath, String value) throws JaxenException {
        Dom4jXPath xpath = new Dom4jXPath(xPath);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("pho", "http://www.pentaho.com");
        xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
        Node node = (Node)xpath.selectSingleNode((Object)doc);
        node.setText(value);
    }

    public boolean open(org.w3c.dom.Node transNode, String fname, boolean importfile) {
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        try {
            LogicalModel logical;
            Object property;
            File f = new File(fname);
            this.reportName = f.getName();
            this.reportName = this.reportName.substring(0, this.reportName.indexOf(".xanalyzer"));
            FileInputStream in = new FileInputStream(f);
            StringBuilder sb = new StringBuilder();
            byte[] b = new byte[2048];
            int n = in.read(b);
            while (n != -1) {
                sb.append(new String(b, 0, n));
                n = in.read(b);
            }
            Document doc = DocumentHelper.parseText((String)sb.toString());
            Dom4jXPath xpath = new Dom4jXPath("//@catalog");
            Dom4jXPath xpath2 = new Dom4jXPath("//@cube");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("pho", "http://www.pentaho.com");
            xpath.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            xpath2.setNamespaceContext((NamespaceContext)new SimpleNamespaceContext(map));
            Node node = (Node)xpath.selectSingleNode((Object)doc);
            Node node2 = (Node)xpath2.selectSingleNode((Object)doc);
            String modelFileName = node.getText();
            String modelId = node2.getText();
            SwtXulLoader theXulLoader = new SwtXulLoader();
            theXulLoader.registerClassLoader((Object)this.getClass().getClassLoader());
            AnalyzerVisualizationController theController = new AnalyzerVisualizationController((Composite)spoon.tabfolder.getSwtTabset(), this, modelFileName, modelId, f.toString(), f.getName());
            theController.setDirty(false);
            XulDomContainer theXulContainer = theXulLoader.loadXul(WEB_VISUALIZATION, (Object)new PDIMessages(IVisualization.class));
            theXulContainer.addEventHandler((XulEventHandler)theController);
            Composite theMainBox = (Composite)theXulContainer.getDocumentRoot().getElementById("mainVBox").getManagedObject();
            SwtXulRunner theRunner = new SwtXulRunner();
            theRunner.addContainer(theXulContainer);
            theRunner.initialize();
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            XmiParser parser = new XmiParser();
            FileInputStream inputStream = new FileInputStream(new File(modelFileName));
            Domain domain = parser.parseXmi((InputStream)inputStream);
            inputStream.close();
            if (model.getDomain() != null && (property = (logical = model.getLogicalModel(ModelerPerspective.ANALYSIS)).getProperty("source_type")) != null) {
                IModelerSource theSource = ModelerSourceFactory.generateSource((String)property.toString());
                theSource.initialize(domain);
                model.setModelSource(theSource);
            }
            if (domain.getId() == null) {
                domain.setId(modelId);
            }
            model.setDomain(domain);
            model.setModelName(domain.getId());
            model.setFileName(modelFileName);
            model.setTemporary(false);
            theController.setModel(model);
            theXulContainer.addEventHandler((XulEventHandler)theController);
            this.createTabForBrowser(theMainBox, theController, model);
            this.flushAnalyzerCache();
            theController.openReport(fname);
            String fullPath = f.getAbsolutePath();
            spoon.getProperties().addLastFile("Analyzer", fullPath, null, false, null);
            spoon.addMenuLast();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean save(EngineMetaInterface meta, String fname, boolean isExport) {
        AnalyzerVisualizationMeta wvmeta = (AnalyzerVisualizationMeta)meta;
        wvmeta.save(fname);
        File f = new File(fname);
        this.reportName = f.getName();
        this.reportName = this.reportName.substring(0, this.reportName.indexOf(".xanalyzer"));
        String fullPath = f.getAbsolutePath();
        Spoon spoon = (Spoon)SpoonFactory.getInstance();
        spoon.getProperties().addLastFile("Model", fullPath, null, false, null);
        spoon.addMenuLast();
        wvmeta.setFilename(f.getAbsolutePath());
        String name = this.getPathAndFilename(fname)[1].replace("." + this.getExtension(), "");
        AgileBiVisualizationPerspective.getInstance().setNameForTab(wvmeta.getTab(), name);
        RegistryFactory factory = RegistryFactory.getInstance();
        IMetadataRegistry registry = factory.getMetadataRegistry();
        Entity vizEntity = new Entity(fname, name, Type.TYPE_ANALYZER_VIEW.getId());
        registry.addEntity(vizEntity);
        String modelId = wvmeta.browser.getModel().getFileName();
        Entity modelEntity = registry.getEntity(modelId, Type.TYPE_OLAP_MODEL.getId());
        if (modelEntity != null) {
            Link link = new Link(vizEntity, Verb.VERB_USES, modelEntity);
            registry.addLink(link);
        }
        try {
            registry.commit();
        }
        catch (Exception e) {
            logger.error("Could not commit metadata registry", (Throwable)e);
        }
        return true;
    }

    public void syncMetaName(EngineMetaInterface arg0, String arg1) {
    }

    public String[] getPathAndFilename(String filename) {
        int loc = filename.lastIndexOf(File.separator);
        String path = "";
        String fname = "";
        if (loc == -1) {
            fname = filename;
        } else {
            path = filename.substring(0, loc);
            fname = filename.substring(loc + 1);
        }
        return new String[]{path, fname};
    }

    public String getGetStateJavascript() {
        return this.getStateJavascript;
    }

    public void setGetStateJavascript(String getStateJavascript) {
        this.getStateJavascript = getStateJavascript;
    }

    public String getSetStateJavascript() {
        return this.setStateJavascript;
    }

    public void setSetStateJavascript(String setStateJavascript) {
        this.setStateJavascript = setStateJavascript;
    }

    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals("xanalyzer");
    }

    public boolean acceptsXml(String nodeName) {
        return nodeName.equals("reportRecord");
    }

    public String[] getFileTypeDisplayNames(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("org/pentaho/agilebi/spoon/visualizations/analyzer/analyzer_visualization_browser", locale, this.getClass().getClassLoader());
        return new String[]{bundle.getString("AnalyzerViz.fileTypeName")};
    }

    public String getRootNodeName() {
        return null;
    }

    public String[] getSupportedExtensions() {
        return new String[]{"xanalyzer"};
    }

    public void setCaller(String callerId) {
        this.callerId = callerId;
    }
}

