/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.visualizations.analyzer;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import mondrian.rolap.agg.AggregationManager;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Composite;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.spoon.ModelerHelper;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.agilebi.spoon.publish.PublisherHelper;
import org.pentaho.agilebi.spoon.visualizations.AbstractVisualization;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.PropertyPanelController;
import org.pentaho.agilebi.spoon.visualizations.analyzer.AnalyzerVisualization;
import org.pentaho.agilebi.spoon.visualizations.analyzer.AnalyzerVisualizationMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulBrowser;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulEditpanel;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class AnalyzerVisualizationController
extends AbstractXulEventHandler
implements FileListener,
PropertyPanelController {
    public static final String XUL_FILE_ANALYZER_TOOLBAR_PROPERTIES = "plugins/spoon/agile-bi/ui/analyzer-toolbar.properties";
    private String xmiFileLocation = null;
    private String modelId = null;
    private AnalyzerVisualization visualization;
    private AnalyzerVisualizationMeta meta;
    private String visFileLocation = null;
    private XulBrowser browser;
    private Spoon spoon;
    private String location;
    private BindingFactory bf;
    private Binding modelNameBinding;
    private Binding factTableNameBinding;
    private String factTableName;
    private XulEditpanel propPanel;
    private ModelerWorkspace workspace;
    private boolean dirty = true;
    private static Logger logger = LoggerFactory.getLogger(AnalyzerVisualizationController.class);
    private String fileName;
    private boolean showFields = true;
    private boolean showFilters = false;
    private boolean showFieldLayout = false;
    private boolean propVisible = true;

    public AnalyzerVisualizationController(Composite parent, AnalyzerVisualization visualization, String xmiFileLocation, String modelId, String aVisFileLocaiton, String fileName) throws SWTError {
        this.visualization = visualization;
        this.xmiFileLocation = xmiFileLocation;
        this.modelId = modelId;
        this.visFileLocation = aVisFileLocaiton;
        this.meta = new AnalyzerVisualizationMeta(this);
        this.spoon = (Spoon)SpoonFactory.getInstance();
        this.location = visualization.generateNewUrl(xmiFileLocation, modelId);
        this.bf = new DefaultBindingFactory();
        this.fileName = fileName;
    }

    public void init() {
        this.browser = (XulBrowser)this.document.getElementById("web_visualization_browser");
        this.propPanel = (XulEditpanel)this.document.getElementById("propPanel");
        this.browser.setSrc(Const.NVL((String)this.location, (String)"http://"));
        this.bf.setDocument(this.document);
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.modelNameBinding = this.bf.createBinding((Object)this, "modelId", "modelName", "value", new BindingConvertor[0]);
        this.factTableNameBinding = this.bf.createBinding((Object)this, "factTableName", "factTableName", "value", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.propPanel, "visible", (Object)this, "propVisible", new BindingConvertor[0]);
        this.fireBindings();
        this.setPropVisible(false);
    }

    public void openReport(String aReport) {
        String theLocation = this.location.substring(0, this.location.indexOf("?"));
        try {
            aReport = URLEncoder.encode(aReport, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        long avoidBrowserCache = Calendar.getInstance().getTimeInMillis();
        theLocation = theLocation + "?command=open&solution=&path=&action=" + aReport + "&edit=true&showFieldList=true&flush=true&rnd=" + avoidBrowserCache;
        this.browser.setSrc(theLocation);
    }

    private String processFactTableName() {
        IPhysicalModel theModel;
        List theTables;
        String theName = null;
        Domain theDomain = ModelerHelper.getInstance().loadDomain(this.xmiFileLocation);
        List theModels = theDomain.getPhysicalModels();
        if (theModels != null && theModels.size() > 0 && (theTables = (theModel = (IPhysicalModel)theModels.get(0)).getPhysicalTables()) != null && theTables.size() > 0) {
            IPhysicalTable theTable = (IPhysicalTable)theTables.get(0);
            theName = theTable.getName("en_US");
        }
        return theName;
    }

    private void fireBindings() {
        try {
            this.modelNameBinding.fireSourceChanged();
            this.factTableNameBinding.fireSourceChanged();
        }
        catch (Exception e) {
            logger.info("Error firing bindings", (Throwable)e);
        }
    }

    public String getFactTableName() {
        if (this.factTableName == null) {
            this.factTableName = this.processFactTableName();
        }
        return this.factTableName;
    }

    public void setFactTableName(String aFactTableName) {
        this.factTableName = aFactTableName;
    }

    public AnalyzerVisualization getVisualization() {
        return this.visualization;
    }

    public String getVisFileLocation() {
        return this.visFileLocation;
    }

    public void save(String filename) {
        this.visFileLocation = filename;
        this.browser.execute(this.visualization.generateSaveJavascript(filename));
    }

    public void save() {
        try {
            this.spoon.saveToFile((EngineMetaInterface)this.meta);
            this.setDirty(false);
        }
        catch (KettleException e) {
            logger.error("error saving", (Throwable)e);
            this.showErrorDialog(BaseMessages.getString(IVisualization.class, (String)"error_saving", (String[])new String[0]));
        }
    }

    public void saveAs() {
        try {
            this.spoon.saveFileAs((EngineMetaInterface)this.meta);
            this.setDirty(false);
        }
        catch (KettleException e) {
            logger.error("error saving", (Throwable)e);
            this.showErrorDialog(BaseMessages.getString(IVisualization.class, (String)"error_saving", (String[])new String[0]));
        }
    }

    private void showErrorDialog(String msg) {
        try {
            XulMessageBox dlg = (XulMessageBox)this.document.createElement("messagebox");
            dlg.setTitle(BaseMessages.getString(IVisualization.class, (String)"error_title", (String[])new String[0]));
            dlg.setMessage(msg);
            dlg.open();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    public void editModel() {
        AgileBiModelerPerspective.getInstance().open(null, this.xmiFileLocation, false);
    }

    public void refreshData() {
        AggregationManager.instance().getCacheControl(null, null).flushSchemaCache();
        this.browser.execute(this.visualization.generateRefreshDataJavascript(this.xmiFileLocation, this.modelId));
    }

    public void refreshModel() {
        AggregationManager.instance().getCacheControl(null, null).flushSchemaCache();
        this.browser.execute(this.visualization.generateRefreshModelJavascript(this.xmiFileLocation, this.modelId));
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public AnalyzerVisualizationMeta getMeta() {
        return this.meta;
    }

    public boolean canHandleSave() {
        return true;
    }

    public boolean setFocus() {
        return true;
    }

    public boolean open(Node arg0, String arg1, boolean arg2) {
        return false;
    }

    public boolean save(EngineMetaInterface arg0, String arg1, boolean arg2) {
        return false;
    }

    public void syncMetaName(EngineMetaInterface arg0, String arg1) {
    }

    public void setXmiFileLocation(String xmiFileLocation) {
        this.xmiFileLocation = xmiFileLocation;
    }

    public void setVisFileLocation(String visFileLocation) {
        this.visFileLocation = visFileLocation;
    }

    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals("xanalyzer");
    }

    public boolean acceptsXml(String nodeName) {
        return nodeName.equals("reportRecord");
    }

    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Models"};
    }

    public String getRootNodeName() {
        return null;
    }

    public String[] getSupportedExtensions() {
        return new String[]{"xmi"};
    }

    public String getName() {
        return "analyzerVis";
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileLocation() {
        return this.xmiFileLocation;
    }

    public void toggleFieldList() {
        this.showFields = !this.showFields;
        this.browser.execute("window.cv.rptEditor._toggleReportPane(window.cv.rptEditor.fieldList, " + this.showFields + ", false, true)");
    }

    public void toggleFilters() {
        this.showFilters = !this.showFilters;
        this.browser.execute("window.cv.rptEditor._toggleReportPane(window.cv.rptEditor.report.nodeFilter," + this.showFilters + ",true,true)");
    }

    public void toggleFieldLayout() {
        this.showFieldLayout = !this.showFieldLayout;
        this.browser.execute("window.cv.rptEditor._toggleReportPane(window.cv.rptEditor.report.nodeLayout," + this.showFieldLayout + ",true,true)");
    }

    public void undo() {
        this.browser.execute("window.cv.rptEditor.report.history.undo()");
    }

    public void redo() {
        this.browser.execute("window.cv.rptEditor.report.history.redo()");
    }

    public void reset() {
        this.browser.execute("window.cv.rptEditor.report.onReset()");
    }

    public void getReportPDF() {
        this.browser.execute("window.cv.io.getReportInFormat(window.cv.rptEditor.report.getReportXml(), \"PDF\", null, null, window.cv.rptEditor.report.isDirty())");
    }

    public void showReportOptions() {
        this.browser.execute("window.cv.rptEditor.report.rptDlg.showReportOptions()");
    }

    public void togglePropertiesPanel() {
        this.setPropVisible(!this.isPropVisible());
    }

    public boolean isPropVisible() {
        return this.propVisible;
    }

    public void setPropVisible(boolean vis) {
        boolean prevVal = this.propVisible;
        this.propVisible = vis;
        this.firePropertyChange("propVisible", prevVal, vis);
    }

    public void publish() throws ModelerException {
        if (this.isDirty()) {
            try {
                XulMessageBox msg = (XulMessageBox)this.document.createElement("messagebox");
                msg.setTitle(BaseMessages.getString(AbstractVisualization.class, (String)"Publish.UnsavedChangesWarning.Title", (String[])new String[0]));
                msg.setMessage(BaseMessages.getString(AbstractVisualization.class, (String)"Publish.UnsavedChangesWarning.Message", (String[])new String[0]));
                msg.open();
            }
            catch (XulException e) {
                throw new ModelerException((Throwable)e);
            }
            return;
        }
        EngineMetaInterface engineMeta = this.spoon.getActiveMeta();
        String publishingFile = engineMeta.getFilename();
        int treeDepth = 100;
        DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.workspace.getModelSource()).getDatabaseMeta();
        boolean checkDatasources = true;
        boolean showServerSelection = true;
        boolean showFolders = true;
        boolean showCurrentFolder = true;
        String serverPathTemplate = "{path}/resources/metadata";
        String databaseName = PublisherHelper.getBiServerCompatibleDatabaseName(this.workspace.getDatabaseName());
        String extension = ".xanalyzer";
        String filename = new File(publishingFile).getName();
        String newName = PublisherHelper.publishAnalysis(this.workspace, filename, treeDepth, databaseMeta, publishingFile, checkDatasources, true, showFolders, showCurrentFolder, serverPathTemplate, extension, databaseName);
        this.setName(newName);
    }

    public void setModel(ModelerWorkspace aWorkspace) {
        this.workspace = aWorkspace;
    }

    public ModelerWorkspace getModel() {
        return this.workspace;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

