/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.visualizations.prpt;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.pentaho.agilebi.modeler.IModelerSource;
import org.pentaho.agilebi.modeler.IModelerWorkspaceHelper;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ModelerSourceFactory;
import org.pentaho.agilebi.spoon.ModelerHelper;
import org.pentaho.agilebi.spoon.PDIMessages;
import org.pentaho.agilebi.spoon.SpoonModelerWorkspaceHelper;
import org.pentaho.agilebi.spoon.perspective.AbstractPerspective;
import org.pentaho.agilebi.spoon.perspective.AgileBiVisualizationPerspective;
import org.pentaho.agilebi.spoon.visualizations.AbstractVisualization;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.prpt.PRPTMeta;
import org.pentaho.agilebi.spoon.visualizations.prpt.PRPTVisualizationController;
import org.pentaho.agilebi.spoon.wizard.EmbeddedWizard;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.registry.Entity;
import org.pentaho.metadata.registry.IMetadataRegistry;
import org.pentaho.metadata.registry.Link;
import org.pentaho.metadata.registry.RegistryFactory;
import org.pentaho.metadata.registry.Type;
import org.pentaho.metadata.registry.Verb;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.fonts.LibFontBoot;
import org.pentaho.reporting.libraries.resourceloader.LibLoaderBoot;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.WaitBoxRunnable;
import org.pentaho.ui.xul.components.XulWaitBox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class PRPTVisualization
extends AbstractVisualization {
    private static Logger logger = LoggerFactory.getLogger(PRPTVisualization.class);
    private String callerId = null;

    public PRPTVisualization() {
        System.setProperty("org.jpedal.suppressViewerPopups", "true");
    }

    public void createVisualizationFromModel(String modelFileLocation, String modelId) {
    }

    public String getId() {
        return "REPORTING";
    }

    public boolean accepts(String fileName) {
        return fileName.endsWith(".prpt");
    }

    public boolean acceptsXml(String nodeName) {
        return false;
    }

    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{BaseMessages.getString(IVisualization.class, (String)"prpt_file_type_name", (String[])new String[0])};
    }

    public String getRootNodeName() {
        return null;
    }

    public String[] getSupportedExtensions() {
        return new String[]{"prpt"};
    }

    public boolean open(Node transNode, String fname, boolean importfile) {
        try {
            if (!ClassicEngineBoot.getInstance().isBootDone()) {
                ObjectUtilities.setClassLoader((ClassLoader)this.getClass().getClassLoader());
                ObjectUtilities.setClassLoaderSource((String)"ClassContext");
                LibLoaderBoot.getInstance().start();
                LibFontBoot.getInstance().start();
                ClassicEngineBoot.getInstance().start();
            }
            ResourceManager theResourceManager = new ResourceManager();
            theResourceManager.registerDefaults();
            File theReportFile = new File(fname);
            Resource theResource = theResourceManager.createDirectly((Object)theReportFile, MasterReport.class);
            MasterReport masterReport = (MasterReport)theResource.getResource();
            AbstractPerspective.XulTabAndPanel tabAndPanel = AgileBiVisualizationPerspective.getInstance().createTab();
            AgileBiVisualizationPerspective.getInstance().setNameForTab(tabAndPanel.tab, this.getPathAndFilename(fname)[1].replace(".prpt", ""));
            SpoonPerspectiveManager.getInstance().activatePerspective(AgileBiVisualizationPerspective.class);
            SwtXulLoader theXulLoader = new SwtXulLoader();
            theXulLoader.registerClassLoader((Object)this.getClass().getClassLoader());
            theXulLoader.register("PRPT", "org.pentaho.agilebi.spoon.visualizations.xul.PrptViewerTag");
            XulDomContainer theXulContainer = theXulLoader.loadXul("org/pentaho/agilebi/spoon/visualizations/prpt/prptVisualization.xul", (Object)new PDIMessages(IVisualization.class));
            PRPTMeta meta = new PRPTMeta();
            meta.setTab(tabAndPanel.tab);
            AgileBiVisualizationPerspective.getInstance().setMetaForTab(tabAndPanel.tab, meta);
            PRPTVisualizationController controller = new PRPTVisualizationController(meta, masterReport);
            controller.setFileName(fname);
            controller.setDirty(false);
            PmdDataFactory theDataFactory = (PmdDataFactory)masterReport.getDataFactory();
            String theXmiFile = theDataFactory.getXmiFile();
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            XmiParser parser = new XmiParser();
            FileInputStream inputStream = new FileInputStream(new File(theXmiFile));
            Domain domain = parser.parseXmi((InputStream)inputStream);
            inputStream.close();
            LogicalModel logical = (LogicalModel)domain.getLogicalModels().get(0);
            Object property = logical.getProperty("source_type");
            if (property != null) {
                IModelerSource theSource = ModelerSourceFactory.generateSource((String)property.toString());
                theSource.initialize(domain);
                model.setModelSource(theSource);
            }
            model.setDomain(domain);
            model.setModelName(domain.getId());
            model.setFileName(theXmiFile);
            model.setTemporary(false);
            controller.setModel(model);
            theXulContainer.addEventHandler((XulEventHandler)controller);
            Composite theMainBox = (Composite)theXulContainer.getDocumentRoot().getElementById("mainContainer").getManagedObject();
            SwtXulRunner theRunner = new SwtXulRunner();
            theRunner.addContainer(theXulContainer);
            theRunner.initialize();
            theMainBox.setParent((Composite)tabAndPanel.panel.getManagedObject());
            ((Composite)tabAndPanel.panel.getManagedObject()).layout(true);
            AgileBiVisualizationPerspective.getInstance().setSelectedMeta(meta);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean save(EngineMetaInterface meta, String fname, boolean isExport) {
        try {
            PRPTMeta prptMeta = (PRPTMeta)meta;
            prptMeta.save(fname);
            prptMeta.controller.setDirty(false);
            if (!fname.endsWith(".prpt")) {
                fname = fname + ".prpt";
            }
            File f = new File(fname);
            String fullPath = f.getAbsolutePath();
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            spoon.getProperties().addLastFile("Model", fullPath, null, false, null);
            String name = this.getPathAndFilename(fname)[1].replace(".prpt", "");
            AgileBiVisualizationPerspective.getInstance().setNameForTab(prptMeta.getTab(), fname);
            AgileBiVisualizationPerspective.getInstance().setNameForTab(prptMeta.getTab(), name);
            RegistryFactory factory = RegistryFactory.getInstance();
            IMetadataRegistry registry = factory.getMetadataRegistry();
            Entity vizEntity = new Entity(fname, name, Type.TYPE_REPORT.getId());
            registry.addEntity(vizEntity);
            String modelId = prptMeta.controller.getModel().getFileName();
            Entity modelEntity = registry.getEntity(modelId, Type.TYPE_OLAP_MODEL.getId());
            if (modelEntity != null) {
                Link link = new Link(vizEntity, Verb.VERB_USES, modelEntity);
                registry.addLink(link);
            }
            try {
                registry.commit();
            }
            catch (Exception e) {
                logger.error("Could not commit metadata registry", (Throwable)e);
            }
            spoon.addMenuLast();
            return true;
        }
        catch (ModelerException e) {
            logger.error("error saving", (Throwable)e);
            return false;
        }
    }

    public void syncMetaName(EngineMetaInterface meta, String name) {
    }

    public void createVisualizationFromModel(ModelerWorkspace model, final boolean tempModel) {
        try {
            if (tempModel) {
                ModelerHelper theHelper = ModelerHelper.getInstance();
                model = theHelper.clone(model);
            }
            final ModelerWorkspace fModel = model;
            Spoon spoon = (Spoon)SpoonFactory.getInstance();
            Document document = spoon.getMainSpoonContainer().getDocumentRoot();
            XulWaitBox box = (XulWaitBox)document.createElement("waitbox");
            box.setIndeterminate(true);
            box.setMaximum(10);
            box.setCanCancel(false);
            box.setTitle(BaseMessages.getString(ModelerWorkspace.class, (String)"wait_dialog_title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(ModelerWorkspace.class, (String)"wait_dialog_message", (String[])new String[0]));
            box.setCancelLabel(BaseMessages.getString(ModelerWorkspace.class, (String)"wait_dialog_btn", (String[])new String[0]));
            box.setDialogParent((Object)((Spoon)SpoonFactory.getInstance()).getShell());
            box.setRunnable(new WaitBoxRunnable(box){
                boolean canceled;
                {
                    super(x0);
                    this.canceled = false;
                }

                public void run() {
                    try {
                        ObjectUtilities.setClassLoader((ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
                        ObjectUtilities.setClassLoaderSource((String)"ClassContext");
                        if (!ClassicEngineBoot.getInstance().isBootDone()) {
                            ClassicEngineBoot engineBoot = ClassicEngineBoot.getInstance();
                            engineBoot.start();
                        }
                        EmbeddedWizard wizard = new EmbeddedWizard(fModel, tempModel);
                        this.waitBox.stop();
                        wizard.run(null);
                    }
                    catch (Exception e) {
                        logger.error("Error initializing reporting", (Throwable)e);
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", e);
                            }
                        });
                    }
                    this.waitBox.stop();
                }

                public void cancel() {
                    this.canceled = true;
                }
            });
            box.start();
        }
        catch (Exception e1) {
            logger.error("Error creating visualization", (Throwable)e1);
            new ErrorDialog(((Spoon)SpoonFactory.getInstance()).getShell(), "Error", "Error creating visualization", e1);
        }
    }

    public void createVisualizationFromMasterReport(MasterReport rpt, boolean tempModel) {
        try {
            if (!ClassicEngineBoot.getInstance().isBootDone()) {
                LibLoaderBoot.getInstance().start();
                LibFontBoot.getInstance().start();
                ClassicEngineBoot.getInstance().start();
            }
            AbstractPerspective.XulTabAndPanel tabAndPanel = AgileBiVisualizationPerspective.getInstance().createTab();
            AgileBiVisualizationPerspective.getInstance().setNameForTab(tabAndPanel.tab, "Untitled Report");
            SpoonPerspectiveManager.getInstance().activatePerspective(AgileBiVisualizationPerspective.class);
            SwtXulLoader theXulLoader = new SwtXulLoader();
            theXulLoader.registerClassLoader((Object)this.getClass().getClassLoader());
            theXulLoader.register("PRPT", "org.pentaho.agilebi.spoon.visualizations.xul.PrptViewerTag");
            XulDomContainer theXulContainer = theXulLoader.loadXul("org/pentaho/agilebi/spoon/visualizations/prpt/prptVisualization.xul", (Object)new PDIMessages(IVisualization.class));
            Composite theMainBox = (Composite)theXulContainer.getDocumentRoot().getElementById("mainContainer").getManagedObject();
            PRPTMeta meta = new PRPTMeta();
            AgileBiVisualizationPerspective.getInstance().setMetaForTab(tabAndPanel.tab, meta);
            meta.setTab(tabAndPanel.tab);
            PRPTVisualizationController controller = new PRPTVisualizationController(meta, rpt);
            PmdDataFactory theDataFactory = (PmdDataFactory)rpt.getDataFactory();
            String theXmiFile = theDataFactory.getXmiFile();
            XmiParser parser = new XmiParser();
            FileInputStream inputStream = new FileInputStream(new File(theXmiFile));
            Domain domain = parser.parseXmi((InputStream)inputStream);
            inputStream.close();
            ModelerWorkspace model = new ModelerWorkspace((IModelerWorkspaceHelper)new SpoonModelerWorkspaceHelper(), SpoonModelerWorkspaceHelper.initGeoContext());
            LogicalModel logical = (LogicalModel)domain.getLogicalModels().get(0);
            Object property = logical.getProperty("source_type");
            if (property != null) {
                IModelerSource theSource = ModelerSourceFactory.generateSource((String)property.toString());
                theSource.initialize(domain);
                model.setModelSource(theSource);
            }
            model.setDomain(domain);
            model.setModelName(((LogicalModel)domain.getLogicalModels().get(0)).getName("en_US"));
            model.setFileName(theXmiFile);
            model.setTemporary(tempModel);
            controller.setModel(model);
            theXulContainer.addEventHandler((XulEventHandler)controller);
            SwtXulRunner theRunner = new SwtXulRunner();
            theRunner.addContainer(theXulContainer);
            theRunner.initialize();
            theMainBox.setParent((Composite)tabAndPanel.panel.getManagedObject());
            ((Composite)tabAndPanel.panel.getManagedObject()).layout(true);
            AgileBiVisualizationPerspective.getInstance().setSelectedMeta(meta);
            Spoon.getInstance().enableMenus();
        }
        catch (Exception e) {
            logger.error("Error creating visualization", (Throwable)e);
        }
    }

    public String[] getPathAndFilename(String filename) {
        int loc = filename.lastIndexOf(File.separator);
        String path = "";
        String fname = "";
        if (loc == -1) {
            fname = filename;
        } else {
            path = filename.substring(0, loc);
            fname = filename.substring(loc + 1);
        }
        return new String[]{path, fname};
    }

    public void setCaller(String callerId) {
        this.callerId = callerId;
    }
}

