/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.visualizations.prpt;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.pentaho.agilebi.modeler.ModelerException;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.modeler.util.ISpoonModelerSource;
import org.pentaho.agilebi.spoon.ModelerHelper;
import org.pentaho.agilebi.spoon.perspective.AgileBiModelerPerspective;
import org.pentaho.agilebi.spoon.publish.PublisherHelper;
import org.pentaho.agilebi.spoon.visualizations.AbstractVisualization;
import org.pentaho.agilebi.spoon.visualizations.IVisualization;
import org.pentaho.agilebi.spoon.visualizations.PropertyPanelController;
import org.pentaho.agilebi.spoon.visualizations.prpt.PRPTMeta;
import org.pentaho.agilebi.spoon.visualizations.xul.PrptViewerTag;
import org.pentaho.agilebi.spoon.wizard.EmbeddedWizard;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.IPhysicalModel;
import org.pentaho.metadata.model.IPhysicalTable;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriter;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.containers.XulEditpanel;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PRPTVisualizationController
extends AbstractXulEventHandler
implements PropertyPanelController {
    private Spoon spoon;
    private EngineMetaInterface meta;
    private MasterReport report;
    private String fileName;
    private Binding modelNameBinding;
    private Binding factTableNameBinding;
    private BindingFactory bf;
    private static Logger logger = LoggerFactory.getLogger(PRPTVisualizationController.class);
    private String factTableName;
    private String modelId;
    private PrptViewerTag viewer;
    private XulEditpanel propPanel;
    private XulMenuList zoomList;
    private ModelerWorkspace model;
    private boolean dirty = true;
    private TreeMap<Double, String> zoomMap = new TreeMap();
    private boolean propVisible;

    public PRPTVisualizationController(PRPTMeta meta, MasterReport rpt) {
        this.zoomMap.put(0.5, "50%");
        this.zoomMap.put(0.75, "75%");
        this.zoomMap.put(1.0, "100%");
        this.zoomMap.put(1.25, "125%");
        this.zoomMap.put(1.5, "150%");
        this.zoomMap.put(2.0, "200%");
        this.propVisible = true;
        this.spoon = (Spoon)SpoonFactory.getInstance();
        meta.setController(this);
        this.meta = meta;
        this.report = rpt;
    }

    public String getName() {
        return "prpt";
    }

    public void init() {
        this.bf = new DefaultBindingFactory();
        this.bf.setDocument(this.document);
        this.propPanel = (XulEditpanel)this.document.getElementById("propPanel");
        this.zoomList = (XulMenuList)this.document.getElementById("zoomlist");
        String xmiFileLocation = this.getXmiFileLocation();
        if (xmiFileLocation != null) {
            Domain theDomain = ModelerHelper.getInstance().loadDomain(xmiFileLocation);
            this.modelId = ((LogicalModel)theDomain.getLogicalModels().get(0)).getName("en_US");
        } else {
            this.modelId = BaseMessages.getString(IVisualization.class, (String)"unavailable", (String[])new String[0]);
        }
        this.bf.setBindingType(Binding.Type.ONE_WAY);
        this.modelNameBinding = this.bf.createBinding((Object)this, "modelId", "modelName", "value", new BindingConvertor[0]);
        this.factTableNameBinding = this.bf.createBinding((Object)this, "factTableName", "factTableName", "value", new BindingConvertor[0]);
        this.bf.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bf.createBinding((Object)this.propPanel, "visible", (Object)this, "propVisible", new BindingConvertor[0]);
        this.viewer = (PrptViewerTag)this.document.getElementById("prptViewer");
        this.bf.createBinding((Object)this.viewer, "zoom", (Object)this.zoomList, "selectedIndex", new BindingConvertor[]{new BindingConvertor<Double, Integer>(){

            public Integer sourceToTarget(Double value) {
                return new ArrayList(PRPTVisualizationController.this.zoomMap.keySet()).indexOf(PRPTVisualizationController.this.viewer.getZoom());
            }

            public Double targetToSource(Integer value) {
                switch (value) {
                    case 5: {
                        return 2.0;
                    }
                }
                return 0.5 + 0.25 * (double)value.intValue();
            }
        }});
        this.loadReport();
        this.fireBindings();
    }

    private void fireBindings() {
        try {
            this.modelNameBinding.fireSourceChanged();
            this.factTableNameBinding.fireSourceChanged();
        }
        catch (Exception e) {
            logger.info("error firing bindings", (Throwable)e);
        }
    }

    public String getModelId() {
        return this.modelId;
    }

    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    public void setFactTableName(String name) {
        this.factTableName = name;
    }

    public String getFactTableName() {
        if (this.factTableName == null) {
            this.factTableName = this.processFactTableName();
        }
        return this.factTableName;
    }

    private String processFactTableName() {
        IPhysicalModel theModel;
        List theTables;
        String theName = null;
        String xmiFileLocation = this.getXmiFileLocation();
        if (xmiFileLocation == null) {
            return BaseMessages.getString(IVisualization.class, (String)"unavailable", (String[])new String[0]);
        }
        Domain theDomain = ModelerHelper.getInstance().loadDomain(xmiFileLocation);
        List theModels = theDomain.getPhysicalModels();
        if (theModels != null && theModels.size() > 0 && (theTables = (theModel = (IPhysicalModel)theModels.get(0)).getPhysicalTables()) != null && theTables.size() > 0) {
            IPhysicalTable theTable = (IPhysicalTable)theTables.get(0);
            theName = theTable.getName("en_US");
        }
        return theName;
    }

    public void save(String fileName) throws ModelerException {
        this.fileName = fileName;
        try {
            BundleWriter.writeReportToZipFile((MasterReport)this.report, (File)new File(fileName));
            this.setDirty(false);
        }
        catch (Exception e) {
            throw new ModelerException((Throwable)e);
        }
    }

    public void save() {
        try {
            this.spoon.saveToFile(this.meta);
            this.setDirty(false);
        }
        catch (KettleException e) {
            logger.error("error saving", (Throwable)e);
            this.showErrorDialog(BaseMessages.getString(IVisualization.class, (String)"error_saving", (String[])new String[0]));
        }
    }

    public void saveAs() {
        try {
            this.spoon.saveFileAs(this.meta);
        }
        catch (KettleException e) {
            logger.error("error saving", (Throwable)e);
            this.showErrorDialog(BaseMessages.getString(IVisualization.class, (String)"error_saving", (String[])new String[0]));
        }
    }

    private void showErrorDialog(String msg) {
        try {
            XulMessageBox dlg = (XulMessageBox)this.document.createElement("messagebox");
            dlg.setTitle(BaseMessages.getString(IVisualization.class, (String)"error_title", (String[])new String[0]));
            dlg.setMessage(msg);
            dlg.open();
        }
        catch (XulException e) {
            e.printStackTrace();
        }
    }

    public void editReport() {
        String xmiFileLocation = this.getXmiFileLocation();
        if (xmiFileLocation != null) {
            EmbeddedWizard wiz = new EmbeddedWizard();
            try {
                wiz.run((AbstractReportDefinition)this.report);
            }
            catch (ReportProcessingException e) {
                e.printStackTrace();
            }
        } else {
            try {
                XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
                box.setTitle(BaseMessages.getString(IVisualization.class, (String)"error_title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(IVisualization.class, (String)"prpt_no_model", (String[])new String[0]));
                box.open();
            }
            catch (XulException e) {
                e.printStackTrace();
            }
        }
    }

    public void editModel() {
        String xmiFileLocation = this.getXmiFileLocation();
        if (xmiFileLocation != null) {
            AgileBiModelerPerspective.getInstance().open(null, xmiFileLocation, false);
        } else {
            try {
                XulMessageBox box = (XulMessageBox)this.document.createElement("messagebox");
                box.setTitle(BaseMessages.getString(IVisualization.class, (String)"error_title", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(IVisualization.class, (String)"prpt_no_model", (String[])new String[0]));
                box.open();
            }
            catch (XulException e) {
                e.printStackTrace();
            }
        }
    }

    public String getXmiFileLocation() {
        if (!(this.report.getDataFactory() instanceof PmdDataFactory)) {
            return null;
        }
        return ((PmdDataFactory)this.report.getDataFactory()).getXmiFile();
    }

    public void publish() throws ModelerException {
        if (this.isDirty()) {
            try {
                XulMessageBox msg = (XulMessageBox)this.document.createElement("messagebox");
                msg.setTitle(BaseMessages.getString(AbstractVisualization.class, (String)"Publish.UnsavedChangesWarning.Title", (String[])new String[0]));
                msg.setMessage(BaseMessages.getString(AbstractVisualization.class, (String)"Publish.UnsavedChangesWarning.Message", (String[])new String[0]));
                msg.open();
            }
            catch (XulException e) {
                throw new ModelerException((Throwable)e);
            }
            return;
        }
        int treeDepth = -1;
        DatabaseMeta databaseMeta = ((ISpoonModelerSource)this.model.getModelSource()).getDatabaseMeta();
        boolean checkDatasources = true;
        boolean showServerSelection = true;
        boolean showFolders = true;
        boolean showCurrentFolder = false;
        String serverPathTemplate = "{path}/resources/metadata";
        String databaseName = this.model.getDatabaseName();
        String modelName = this.model.getModelName();
        PmdDataFactory thePmdDataFactory = (PmdDataFactory)this.report.getDataFactory();
        String theOldDomainId = thePmdDataFactory.getDomainId();
        String thePrpt = this.getFileName();
        PublisherHelper.publishPrpt(this.report, this.model, modelName, thePrpt, treeDepth, databaseMeta, this.model.getFileName(), checkDatasources, showServerSelection, showFolders, showCurrentFolder, serverPathTemplate, databaseName);
        thePmdDataFactory.setDomainId(theOldDomainId);
        this.save(thePrpt);
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void loadReport() {
        this.viewer.setMasterReport(this.report);
    }

    public void refresh() {
        this.loadReport();
    }

    public void togglePropertiesPanel() {
        this.setPropVisible(!this.isPropVisible());
    }

    public boolean isPropVisible() {
        return this.propVisible;
    }

    public void setPropVisible(boolean vis) {
        boolean prevVal = this.propVisible;
        this.propVisible = vis;
        this.firePropertyChange("propVisible", prevVal, vis);
    }

    public void start() {
        this.viewer.start();
    }

    public void previous() {
        this.viewer.previous();
    }

    public void next() {
        this.viewer.next();
    }

    public void last() {
        this.viewer.last();
    }

    public void zoomOut() {
        this.viewer.zoomOut();
    }

    public void zoomIn() {
        this.viewer.zoomIn();
    }

    public void setModel(ModelerWorkspace model) {
        this.model = model;
    }

    public ModelerWorkspace getModel() {
        return this.model;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }
}

