/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.visualizations.xul;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewPane;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.internal.PreviewPaneUtilities;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swt.SwtElement;
import org.pentaho.ui.xul.util.SwtXulUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrptViewerTag
extends SwtElement {
    private String src;
    private PreviewPane viewer;
    private Composite viewerComposite;
    private MasterReport masterReport;
    private Composite mainPanel;
    private boolean showToolbar = true;
    private ToolBar toolbar;
    private Composite toolbarPanel;
    private Combo combo;
    private XulDomContainer domContainer;
    private static Logger log = LoggerFactory.getLogger(PrptViewerTag.class);
    private TreeMap<Double, String> zoomMap = new TreeMap();
    private Double curZoom;

    public PrptViewerTag(Element self, XulComponent parent, XulDomContainer container, String tagName) {
        super("prpt");
        this.zoomMap.put(0.5, "50%");
        this.zoomMap.put(0.75, "75%");
        this.zoomMap.put(1.0, "100%");
        this.zoomMap.put(1.25, "125%");
        this.zoomMap.put(1.5, "150%");
        this.zoomMap.put(2.0, "200%");
        this.curZoom = 1.0;
        this.domContainer = container;
        Composite parentComposite = (Composite)parent.getManagedObject();
        this.mainPanel = new Composite(parentComposite, 2048);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.mainPanel.setLayout((Layout)layout);
        parentComposite.layout(true);
        this.setManagedObject(this.mainPanel);
    }

    public void start() {
        this.viewer.setPageNumber(1);
    }

    public void previous() {
        this.viewer.setPageNumber(Math.max(1, this.viewer.getPageNumber() - 1));
    }

    public void next() {
        this.viewer.setPageNumber(Math.min(this.viewer.getNumberOfPages(), this.viewer.getPageNumber() + 1));
    }

    public void last() {
        this.viewer.setPageNumber(this.viewer.getNumberOfPages());
    }

    public void zoomOut() {
        double nextZoomOut = PreviewPaneUtilities.getNextZoomOut((double)this.viewer.getZoom(), (double[])this.viewer.getZoomFactors());
        if (nextZoomOut < 0.5) {
            return;
        }
        this.viewer.setZoom(nextZoomOut);
    }

    public void zoomIn() {
        double nextZoomIn = PreviewPaneUtilities.getNextZoomIn((double)this.viewer.getZoom(), (double[])this.viewer.getZoomFactors());
        if (nextZoomIn > 2.0) {
            return;
        }
        this.viewer.setZoom(nextZoomIn);
    }

    public void layout() {
        if (!this.initialized) {
            this.toolbarPanel = new Composite(this.mainPanel, 0);
            GridData data = new GridData();
            data.horizontalAlignment = 4;
            data.verticalIndent = 0;
            data.horizontalIndent = 0;
            data.grabExcessHorizontalSpace = true;
            this.toolbarPanel.setLayoutData((Object)data);
            this.toolbarPanel.setLayout((Layout)new FillLayout());
            Display d = this.mainPanel.getDisplay();
            if (d == null) {
                d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
            }
            this.toolbar = new ToolBar(this.toolbarPanel, 256);
            ToolItem item = new ToolItem(this.toolbar, 8);
            Image img = SwtXulUtil.getCachedImage((String)"org/pentaho/agilebi/spoon/visualizations/prpt/images/begining.png", (XulDomContainer)this.domContainer, (Display)d);
            item.setImage(img);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    PrptViewerTag.this.start();
                }
            });
            item = new ToolItem(this.toolbar, 8);
            img = SwtXulUtil.getCachedImage((String)"org/pentaho/agilebi/spoon/visualizations/prpt/images/back.png", (XulDomContainer)this.domContainer, (Display)d);
            item.setImage(img);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    PrptViewerTag.this.previous();
                }
            });
            item = new ToolItem(this.toolbar, 8);
            img = SwtXulUtil.getCachedImage((String)"org/pentaho/agilebi/spoon/visualizations/prpt/images/forward.png", (XulDomContainer)this.domContainer, (Display)d);
            item.setImage(img);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    PrptViewerTag.this.next();
                }
            });
            item = new ToolItem(this.toolbar, 8);
            img = SwtXulUtil.getCachedImage((String)"org/pentaho/agilebi/spoon/visualizations/prpt/images/end.png", (XulDomContainer)this.domContainer, (Display)d);
            item.setImage(img);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    PrptViewerTag.this.last();
                }
            });
            new ToolItem(this.toolbar, 2);
            item = new ToolItem(this.toolbar, 8);
            img = SwtXulUtil.getCachedImage((String)"org/pentaho/agilebi/spoon/visualizations/prpt/images/minus.png", (XulDomContainer)this.domContainer, (Display)d);
            item.setImage(img);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    PrptViewerTag.this.zoomOut();
                }
            });
            item = new ToolItem(this.toolbar, 8);
            img = SwtXulUtil.getCachedImage((String)"org/pentaho/agilebi/spoon/visualizations/prpt/images/plus.png", (XulDomContainer)this.domContainer, (Display)d);
            item.setImage(img);
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    PrptViewerTag.this.zoomIn();
                }
            });
            item = new ToolItem(this.toolbar, 2);
            this.combo = new Combo((Composite)this.toolbar, 4);
            this.combo.setItems(new String[]{"50%", "75%", "100%", "125%", "150%", "200%"});
            this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int idx = ((Combo)e.widget).getSelectionIndex();
                    switch (idx) {
                        case 5: {
                            PrptViewerTag.this.viewer.setZoom(2.0);
                        }
                    }
                    PrptViewerTag.this.viewer.setZoom(0.5 + 0.25 * (double)idx);
                }
            });
            this.combo.select(2);
            this.combo.pack();
            item.setControl((Control)this.combo);
            item.setWidth(80);
            new ToolItem(this.toolbar, 2);
            this.createViewer();
            GridData gData = new GridData(1808);
            this.viewerComposite.setLayoutData((Object)gData);
            this.setShowtoolbar(this.getShowtoolbar());
            this.mainPanel.layout(true);
            if (this.src != null) {
                this.loadPRPT();
            }
        }
        this.initialized = true;
    }

    private void createViewer() {
        Composite swingComposite = new Composite(this.mainPanel, 0x1000000);
        Frame swingFrame = SWT_AWT.new_Frame((Composite)swingComposite);
        JPanel browserPanel = new JPanel();
        browserPanel.setLayout(new BorderLayout());
        swingFrame.add(browserPanel);
        this.viewer = new PreviewPane();
        browserPanel.add((Component)this.viewer, "Center");
        this.viewerComposite = swingComposite;
    }

    protected Browser createBrowser(Composite parent) {
        return new Browser(parent, 0);
    }

    public boolean getShowtoolbar() {
        return this.showToolbar;
    }

    public void setShowtoolbar(boolean flag) {
        this.showToolbar = flag;
        if (this.toolbarPanel != null) {
            this.toolbarPanel.setVisible(flag);
            ((GridData)this.toolbarPanel.getLayoutData()).exclude = !this.showToolbar;
            this.mainPanel.layout(true);
        }
    }

    public String getSrc() {
        return this.src;
    }

    public void setSrc(String src) {
        this.src = src;
        if (this.initialized) {
            this.loadPRPT();
        }
    }

    public void setMasterReport(MasterReport aMasterRerport) {
        this.masterReport = aMasterRerport;
        if (this.initialized) {
            this.loadPRPT();
        }
    }

    public Double getZoom() {
        return this.viewer.getZoom();
    }

    public void setZoom(Double val) {
        this.viewer.setZoom(val.doubleValue());
    }

    private void loadPRPT() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    if (PrptViewerTag.this.masterReport == null) {
                        ResourceManager theResourceManager = new ResourceManager();
                        theResourceManager.registerDefaults();
                        File theReportFile = new File(PrptViewerTag.this.src);
                        Resource theResource = theResourceManager.createDirectly((Object)theReportFile, MasterReport.class);
                        PrptViewerTag.this.masterReport = (MasterReport)theResource.getResource();
                    }
                    ModifiableConfiguration cfg = (ModifiableConfiguration)PrptViewerTag.this.masterReport.getConfiguration();
                    cfg.setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.gui.base.ToolbarAvailable", "false");
                    PrptViewerTag.this.viewer.setReportJob(PrptViewerTag.this.masterReport);
                    PrptViewerTag.this.viewer.getZoomModel().addListDataListener(new ListDataListener(){

                        public void contentsChanged(ListDataEvent arg0) {
                            PrptViewerTag.this.combo.select(new ArrayList(PrptViewerTag.this.zoomMap.keySet()).indexOf(PrptViewerTag.this.viewer.getZoom()));
                            Double prevZoom = PrptViewerTag.this.curZoom;
                            PrptViewerTag.this.changeSupport.firePropertyChange("zoom", prevZoom, PrptViewerTag.this.getZoom());
                            PrptViewerTag.this.curZoom = PrptViewerTag.this.getZoom();
                        }

                        public void intervalAdded(ListDataEvent arg0) {
                        }

                        public void intervalRemoved(ListDataEvent arg0) {
                        }
                    });
                }
                catch (Exception e) {
                    log.error("error loading PRPT", (Throwable)e);
                }
            }
        });
    }
}

