/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.wizard;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.swt.widgets.Display;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.spoon.wizard.PreviewWizardController;
import org.pentaho.agilebi.spoon.wizard.ui.xul.DefaultWizardDesignTimeContext;
import org.pentaho.agilebi.spoon.wizard.ui.xul.steps.DataSourceAndQueryStep;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardContentPanel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.WizardController;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.FormatStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LayoutStep;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.steps.LookAndFeelStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.swt.SwtXulLoader;

public class EmbeddedWizard {
    private static final String MAIN_WIZARD_PANEL = "org/pentaho/reporting/engine/classic/wizard/ui/xul/res/main_wizard_panel.xul";
    private ModelerWorkspace model;
    private XulDialog dialog;
    private PreviewWizardController wizardController;
    private boolean tempModel;
    private AbstractReportDefinition retVal = null;

    public EmbeddedWizard() {
        this(null, false);
    }

    public EmbeddedWizard(ModelerWorkspace model, boolean tempModel) {
        this.model = model;
        this.tempModel = tempModel;
        this.init();
    }

    private void init() {
        this.wizardController = new PreviewWizardController(new WizardEditorModel(), new DefaultBindingFactory(), this.tempModel);
        this.wizardController.addStep((AbstractWizardStep)new LookAndFeelStep());
        this.wizardController.addStep(new DataSourceAndQueryStep());
        this.wizardController.addStep((AbstractWizardStep)new LayoutStep());
        this.wizardController.addStep((AbstractWizardStep)new FormatStep());
        this.wizardController.addPropertyChangeListener("cancelled", new CancelHandler());
        this.wizardController.addPropertyChangeListener("finished", new FinishedHandler());
    }

    public AbstractReportDefinition run(final AbstractReportDefinition original) throws ReportProcessingException {
        if (!Display.getDefault().getThread().equals(Thread.currentThread())) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    try {
                        EmbeddedWizard.this.retVal = EmbeddedWizard.this.run(original);
                    }
                    catch (ReportProcessingException e) {
                        e.printStackTrace();
                    }
                }
            });
            return this.retVal;
        }
        if (original != null) {
            this.wizardController.getEditorModel().setReportDefinition(original, true);
        } else {
            MasterReport report = new MasterReport();
            CompoundDataFactory cdf = new CompoundDataFactory();
            report.setDataFactory((DataFactory)cdf);
            this.wizardController.getEditorModel().setReportDefinition((AbstractReportDefinition)report, false);
            ((DataSourceAndQueryStep)this.wizardController.getStep(1)).setModel(this.model);
        }
        try {
            SwtXulLoader loader = new SwtXulLoader();
            loader.setOuterContext((Object)((Spoon)SpoonFactory.getInstance()).getShell());
            loader.registerClassLoader((Object)this.getClass().getClassLoader());
            XulDomContainer mainWizardContainer = loader.loadXul(MAIN_WIZARD_PANEL);
            new WizardContentPanel((WizardController)this.wizardController).addContent(mainWizardContainer);
            this.wizardController.registerMainXULContainer(mainWizardContainer);
            this.wizardController.onLoad();
            Document documentRoot = mainWizardContainer.getDocumentRoot();
            XulComponent root = documentRoot.getRootElement();
            if (!(root instanceof XulDialog)) {
                throw new XulException("Root panel is not an instance of XulDialog: " + root);
            }
            this.dialog = (XulDialog)root;
            DefaultWizardDesignTimeContext context = new DefaultWizardDesignTimeContext(this.wizardController.getEditorModel());
            this.wizardController.setDesignTimeContext(context);
            if (this.wizardController.getEditorModel().isEditing()) {
                this.wizardController.setActiveStep(0);
                Object origTemp = original.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "template");
                if (origTemp != null) {
                    ((LookAndFeelStep)this.wizardController.getStep(0)).setSelectedTemplateByPath(origTemp.toString());
                }
                if (this.wizardController.getStep(0).isValid()) {
                    this.wizardController.setActiveStep(1);
                    if (this.wizardController.getStep(1).isValid()) {
                        this.wizardController.setActiveStep(2);
                    }
                }
            } else {
                ((LookAndFeelStep)this.wizardController.getStep(0)).setSelectedTemplate(Integer.valueOf(0));
            }
            this.dialog.show();
        }
        catch (Exception e) {
            DebugLog.log((Object)"Failed to initialze the wizard", (Throwable)e);
            return null;
        }
        return null;
    }

    private class FinishedHandler
    implements PropertyChangeListener {
        private FinishedHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (EmbeddedWizard.this.wizardController.isFinished()) {
                EmbeddedWizard.this.dialog.hide();
            }
        }
    }

    private class CancelHandler
    implements PropertyChangeListener {
        private CancelHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (EmbeddedWizard.this.wizardController.isCancelled()) {
                EmbeddedWizard.this.dialog.hide();
            }
        }
    }
}

