/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.wizard;

import org.pentaho.agilebi.spoon.visualizations.VisualizationManager;
import org.pentaho.agilebi.spoon.visualizations.prpt.PRPTVisualization;
import org.pentaho.agilebi.spoon.visualizations.xul.PrptViewerTag;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessor;
import org.pentaho.reporting.engine.classic.wizard.WizardProcessorUtil;
import org.pentaho.reporting.engine.classic.wizard.model.WizardSpecification;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.LinearWizardController;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.binding.DefaultBindingFactory;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulRoot;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewWizardController
extends LinearWizardController {
    private static Logger logger = LoggerFactory.getLogger(PreviewWizardController.class);
    private XulDomContainer theXulContainer;
    private boolean tempModel;

    public PreviewWizardController(WizardEditorModel aModel, DefaultBindingFactory aFactory, boolean tempModel) {
        super(aModel, (BindingFactory)aFactory);
        this.tempModel = tempModel;
    }

    public void preview() {
        try {
            AbstractReportDefinition element = this.processWizardSpecification();
            SwtXulLoader theXulLoader = new SwtXulLoader();
            theXulLoader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
            theXulLoader.setOuterContext(((XulRoot)this.document.getRootElement()).getRootObject());
            theXulLoader.register("PRPT", "org.pentaho.agilebi.spoon.visualizations.xul.PrptViewerTag");
            this.theXulContainer = theXulLoader.loadXul("org/pentaho/agilebi/spoon/wizard/prptPreview.xul");
            this.theXulContainer.addEventHandler((XulEventHandler)new PreviewCloseHandler());
            SwtXulRunner theRunner = new SwtXulRunner();
            theRunner.addContainer(this.theXulContainer);
            theRunner.initialize();
            PrptViewerTag thePrptViewerTag = (PrptViewerTag)this.theXulContainer.getDocumentRoot().getElementById("prptViewer");
            thePrptViewerTag.setMasterReport((MasterReport)element);
            XulDialog theDialog = (XulDialog)this.theXulContainer.getDocumentRoot().getElementById("prpt-preview");
            theDialog.show();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error previewing", (Throwable)e);
        }
    }

    public void finish() {
        try {
            MasterReport element = (MasterReport)this.processWizardSpecification();
            element = WizardProcessorUtil.materialize((MasterReport)element, (WizardProcessor)new WizardProcessor());
            VisualizationManager theManager = VisualizationManager.getInstance();
            PRPTVisualization theVisualization = (PRPTVisualization)theManager.getVisualization("Report Wizard");
            if (theVisualization != null) {
                theVisualization.createVisualizationFromMasterReport(element, this.tempModel);
            }
            ((XulDialog)this.document.getElementById("main_wizard_window")).hide();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("error finishing", (Throwable)e);
        }
    }

    private AbstractReportDefinition processWizardSpecification() throws Exception {
        AbstractReportDefinition reportDefinition = this.getEditorModel().getReportDefinition();
        AbstractReportDefinition element = (AbstractReportDefinition)reportDefinition.derive();
        WizardSpecification spec = this.getEditorModel().getReportSpec();
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/wizard", "enable", (Object)Boolean.TRUE);
        WizardProcessorUtil.applyWizardSpec((AbstractReportDefinition)element, (WizardSpecification)((WizardSpecification)spec.clone()));
        WizardProcessorUtil.ensureWizardProcessorIsAdded((AbstractReportDefinition)element, null);
        return element;
    }

    public static class PreviewCloseHandler
    extends AbstractXulEventHandler {
        public String getName() {
            return "controller";
        }

        public void close() {
            ((XulDialog)this.document.getElementById("prpt-preview")).hide();
        }
    }
}

