/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.agilebi.spoon.wizard.ui.xul.steps;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.TableModel;
import org.pentaho.agilebi.modeler.ModelerWorkspace;
import org.pentaho.agilebi.spoon.wizard.EmbeddedWizard;
import org.pentaho.commons.metadata.mqleditor.MqlQuery;
import org.pentaho.commons.metadata.mqleditor.editor.MQLEditorService;
import org.pentaho.commons.metadata.mqleditor.editor.SwtMqlEditor;
import org.pentaho.commons.metadata.mqleditor.editor.service.MQLEditorServiceImpl;
import org.pentaho.commons.metadata.mqleditor.editor.service.util.MQLEditorServiceDelegate;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.states.datarow.StaticDataRow;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributeContext;
import org.pentaho.reporting.engine.classic.core.wizard.DataAttributes;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchema;
import org.pentaho.reporting.engine.classic.core.wizard.DataSchemaModel;
import org.pentaho.reporting.engine.classic.core.wizard.DefaultDataAttributeContext;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.IPmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdDataFactory;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.WizardEditorModel;
import org.pentaho.reporting.engine.classic.wizard.ui.xul.components.AbstractWizardStep;
import org.pentaho.reporting.libraries.base.util.DebugLog;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.ui.datasources.pmd.PmdPreviewWorker;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulLoader;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.XulServiceCallback;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.DefaultXulOverlay;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceAndQueryStep
extends AbstractWizardStep {
    private static final String DATASOURCE_AND_QUERY_STEP_OVERLAY = "org/pentaho/agilebi/spoon/wizard/ui/xul/res/datasource_and_query_step_Overlay.xul";
    private static final String HANDLER_NAME = "datasource_and_query_step_handler";
    private static final String CURRENT_QUERY_PROPERTY_NAME = "currentQuery";
    private static final String DATA_SOURCE_NAME_LABEL_ID = "data_source_name_label";
    private static final String AVAILABLE_COLUMNS_PROPERTY_NAME = "availableColumns";
    private static final String ELEMENTS_PROPERTY_NAME = "elements";
    private static final String QUERY_RESULT_LIST_ID = "query_result_list";
    private static final String NEXT_BTN_ID = "next_btn";
    private static final String DEFAULT = "default";
    private PmdDataFactory df;
    private ModelerWorkspace model;
    private File modelFile;
    private List<String> availableColumns;

    public void stepActivating() {
        super.stepActivating();
        if (this.model != null && this.df == null) {
            if (this.getEditorModel().getReportDefinition().getDataFactory() != null && this.getEditorModel().getReportDefinition().getDataFactory() instanceof CompoundDataFactory) {
                CompoundDataFactory cdf = (CompoundDataFactory)this.getEditorModel().getReportDefinition().getDataFactory();
                for (int i = 0; i < cdf.size(); ++i) {
                    cdf.remove(i);
                }
            }
            this.df = new PmdDataFactory();
            PmdConnectionProvider connectionProvider = new PmdConnectionProvider();
            this.df.setConnectionProvider((IPmdConnectionProvider)connectionProvider);
            this.df.setXmiFile(this.model.getFileName());
            this.df.setDomainId(DEFAULT);
            this.getEditorModel().getReportDefinition().setDataFactory((DataFactory)this.df);
        } else {
            DataFactory savedDf = this.getEditorModel().getReportDefinition().getDataFactory();
            this.df = savedDf instanceof PmdDataFactory ? (PmdDataFactory)savedDf : (PmdDataFactory)((CompoundDataFactory)savedDf).getDataFactoryForQuery(DEFAULT);
            if (this.df == null) {
                this.df = new PmdDataFactory();
                PmdConnectionProvider connectionProvider = new PmdConnectionProvider();
                this.df.setConnectionProvider((IPmdConnectionProvider)connectionProvider);
                if (this.model != null) {
                    this.df.setXmiFile(this.model.getFileName());
                }
                this.df.setDomainId(DEFAULT);
            }
            if (this.getEditorModel() != null) {
                this.getEditorModel().getReportDefinition().setDataFactory((DataFactory)this.df);
            }
        }
        this.updateGui();
        this.setValid(this.validateStep());
    }

    private void updateGui() {
        XulLabel datasourceLabel = (XulLabel)this.getDocument().getElementById(DATA_SOURCE_NAME_LABEL_ID);
        if (datasourceLabel != null && this.modelFile != null) {
            datasourceLabel.setValue(this.modelFile.getName().substring(0, this.modelFile.getName().lastIndexOf(46)));
        }
        this.createColumnsList();
    }

    private void createColumnsList() {
        DataSchemaModel dataSchemaModel = this.getEditorModel().getDataSchema();
        DataSchema dataSchema = dataSchemaModel.getDataSchema();
        Object[] names = dataSchema.getNames();
        Arrays.sort(names);
        ArrayList<String> items = new ArrayList<String>();
        if (names != null) {
            DefaultDataAttributeContext dataAttributeContext = new DefaultDataAttributeContext();
            for (Object name : names) {
                String displayStr;
                DataAttributes attributes;
                String source;
                if (!((String)name).startsWith("::column::") || (source = (String)(attributes = dataSchema.getAttributes((String)name)).getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/core", "source", String.class, (DataAttributeContext)dataAttributeContext)).equals("environment") || source.equals("parameter") || (displayStr = (String)attributes.getMetaAttribute("http://reporting.pentaho.org/namespaces/engine/meta-attributes/formatting", "label", String.class, (DataAttributeContext)dataAttributeContext)) == null || displayStr.length() <= 0) continue;
                items.add(displayStr);
            }
        }
        if (items.size() < 1) {
            items.add(BaseMessages.getString(EmbeddedWizard.class, (String)"DataSourceAndQueryStep.no_defined_fields", (String[])new String[0]));
        }
        this.setAvailableColumns(items);
    }

    protected boolean validateStep() {
        AbstractReportDefinition reportDefinition = this.getEditorModel().getReportDefinition();
        if (reportDefinition.getDataFactory() == null || StringUtils.isEmpty((String)reportDefinition.getQuery())) {
            DebugLog.log((Object)("Have no query or no datafactory " + reportDefinition.getDataFactory() + " " + reportDefinition.getQuery()));
            return false;
        }
        String queryName = reportDefinition.getQuery();
        if (this.df == null || !this.df.isQueryExecutable(queryName, (DataRow)new StaticDataRow())) {
            return false;
        }
        try {
            AbstractReportDefinition abstractReportDefinition = (AbstractReportDefinition)reportDefinition.derive();
            abstractReportDefinition.setDataFactory((DataFactory)this.df);
            DataSchemaModel schemaModel = WizardEditorModel.compileDataSchemaModel((AbstractReportDefinition)abstractReportDefinition);
            return schemaModel.isValid();
        }
        catch (Exception ee) {
            this.getDesignTimeContext().userError(ee);
            return false;
        }
    }

    public void createPresentationComponent(XulDomContainer mainWizardContainer) throws XulException {
        super.createPresentationComponent(mainWizardContainer);
        mainWizardContainer.loadOverlay(DATASOURCE_AND_QUERY_STEP_OVERLAY);
        mainWizardContainer.addEventHandler((XulEventHandler)new DatasourceAndQueryStepHandler());
    }

    public String getCurrentQuery() {
        return this.getEditorModel().getReportDefinition().getQuery();
    }

    public void setCurrentQuery(String currentQuery) {
        String oldQuery = this.getCurrentQuery();
        this.getEditorModel().updateQuery((DataFactory)this.df, DEFAULT);
        this.firePropertyChange(CURRENT_QUERY_PROPERTY_NAME, oldQuery, currentQuery);
        this.setValid(this.validateStep());
        this.updateGui();
    }

    public void setAvailableColumns(List<String> newValue) {
        List<String> oldValue = this.availableColumns;
        this.availableColumns = newValue;
        this.firePropertyChange(AVAILABLE_COLUMNS_PROPERTY_NAME, oldValue, newValue);
    }

    public List<String> getAvailableColumns() {
        return this.availableColumns;
    }

    protected void setValid(boolean valid) {
        XulButton nextButton = (XulButton)this.getDocument().getElementById(NEXT_BTN_ID);
        nextButton.setDisabled(!valid);
    }

    public String getStepName() {
        return BaseMessages.getString(EmbeddedWizard.class, (String)"DataSourceAndQueryStep.name", (String[])new String[0]);
    }

    public void setModel(ModelerWorkspace model) {
        this.model = model;
    }

    public void setBindings() {
        this.getBindingFactory().createBinding((Object)this, AVAILABLE_COLUMNS_PROPERTY_NAME, QUERY_RESULT_LIST_ID, ELEMENTS_PROPERTY_NAME, new BindingConvertor[0]);
    }

    protected class DatasourceAndQueryStepHandler
    extends AbstractXulEventHandler {
        public String getName() {
            return DataSourceAndQueryStep.HANDLER_NAME;
        }

        private IMetadataDomainRepository getDomainRepo() throws ReportDataFactoryException {
            IPmdConnectionProvider connectionProvider = ((PmdDataFactory)DataSourceAndQueryStep.this.getEditorModel().getReportDefinition().getDataFactory()).getConnectionProvider();
            IMetadataDomainRepository repo = connectionProvider.getMetadataDomainRepository(DataSourceAndQueryStep.DEFAULT, DataSourceAndQueryStep.this.getEditorModel().getReportDefinition().getResourceManager(), DataSourceAndQueryStep.this.getEditorModel().getReportDefinition().getContentBase(), DataSourceAndQueryStep.this.df.getXmiFile());
            return repo;
        }

        private MQLEditorServiceDelegate getMqlServiceDelegate() throws ReportDataFactoryException {
            MQLEditorServiceDelegate delegate = new MQLEditorServiceDelegate(this.getDomainRepo()){

                public String[][] getPreviewData(MqlQuery query, int page, int limit) {
                    try {
                        Query mqlQuery = this.convertQueryModel(query);
                        String mqlString = new QueryXmlHelper().toXML(mqlQuery);
                        MasterReport masterReport = (MasterReport)DataSourceAndQueryStep.this.getEditorModel().getReportDefinition();
                        PmdDataFactory df = (PmdDataFactory)masterReport.getDataFactory();
                        df.initialize(masterReport.getConfiguration(), masterReport.getResourceManager(), masterReport.getContentBase(), masterReport.getResourceBundleFactory());
                        df.setQuery(DataSourceAndQueryStep.DEFAULT, mqlString);
                        PmdPreviewWorker worker = new PmdPreviewWorker(df, DataSourceAndQueryStep.DEFAULT, 0, limit);
                        worker.run();
                        if (worker.getException() != null) {
                            worker.getException().printStackTrace();
                        }
                        TableModel model = worker.getResultTableModel();
                        int colCount = model.getColumnCount();
                        int rowCount = model.getRowCount();
                        String[][] results = new String[rowCount][colCount];
                        for (int y = 0; y < rowCount; ++y) {
                            for (int x = 0; x < colCount; ++x) {
                                results[y][x] = "" + model.getValueAt(y, x);
                            }
                        }
                        return results;
                    }
                    catch (ReportDataFactoryException e) {
                        DataSourceAndQueryStep.this.getDesignTimeContext().userError((Exception)((Object)e));
                        return null;
                    }
                }
            };
            return delegate;
        }

        private MQLEditorService getMqlService(MQLEditorServiceDelegate delegate) {
            MQLEditorServiceImpl mqlService = new MQLEditorServiceImpl(delegate){

                public void getPreviewData(MqlQuery query, int page, int limit, XulServiceCallback<String[][]> callback) {
                    callback.success((Object)this.delegate.getPreviewData(query, page, limit));
                }
            };
            return mqlService;
        }

        public void doEditQuery() {
            try {
                IMetadataDomainRepository repo = this.getDomainRepo();
                MQLEditorServiceDelegate delegate = this.getMqlServiceDelegate();
                SwtMqlEditor editor = new SwtMqlEditor(repo, this.getMqlService(delegate), delegate){

                    protected XulLoader getLoader() {
                        try {
                            SwtXulLoader loader = new SwtXulLoader();
                            loader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
                            return loader;
                        }
                        catch (XulException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                };
                String queryString = null;
                if (DataSourceAndQueryStep.this.df != null && DataSourceAndQueryStep.this.df.getQuery(DataSourceAndQueryStep.DEFAULT) != null) {
                    queryString = DataSourceAndQueryStep.this.df.getQuery(DataSourceAndQueryStep.DEFAULT);
                    editor.setQuery(queryString);
                }
                editor.addOverlay((XulOverlay)new DefaultXulOverlay("org/pentaho/agilebi/spoon/wizard/ui/xul/res/mqleditor-overlay.xul"));
                editor.show();
                if (editor.getOkClicked()) {
                    queryString = editor.getQuery();
                    DataSourceAndQueryStep.this.df.setQuery(DataSourceAndQueryStep.DEFAULT, queryString);
                    DataSourceAndQueryStep.this.setCurrentQuery(DataSourceAndQueryStep.DEFAULT);
                }
            }
            catch (Exception e) {
                DataSourceAndQueryStep.this.getDesignTimeContext().userError(e);
            }
        }
    }
}

